/*
 * Decompiled with CFR 0.152.
 */
package info.bix.tokai.bixpp.binding;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.Validate;

public class Base64Header
implements Serializable {
    private static final long serialVersionUID = -284872604208672704L;
    private String _name;
    private String _recordFormat = "";
    private byte[] _base64 = new byte[0];

    public byte[] getBase64() {
        return this._base64;
    }

    public String getName() {
        return this._name;
    }

    public String getRecordFormat() {
        return this._recordFormat;
    }

    public void setBase64(byte[] base64) {
        Validate.notNull((Object)base64);
        this._base64 = base64;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setRecordFormat(String recordFormat) {
        Validate.notNull((Object)recordFormat);
        this._recordFormat = recordFormat;
    }

    public void setBase64(File file) throws IOException {
        Validate.notNull((Object)file);
        FileInputStream inputStream = new FileInputStream(file);
        this.setBase64(inputStream);
    }

    public void setBase64(URL url) throws IOException {
        Validate.notNull((Object)url);
        this.setBase64(url.openStream());
    }

    public void setBase64(InputStream inputStream) throws IOException {
        Validate.notNull((Object)inputStream);
        ByteArrayOutputStream outputStream = null;
        try {
            outputStream = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
            this.setBase64(outputStream.toByteArray());
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(outputStream);
            IOUtils.closeQuietly((InputStream)inputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)outputStream);
        IOUtils.closeQuietly((InputStream)inputStream);
    }
}

