/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml;

import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.exolab.castor.mapping.ClassDescriptor;
import org.exolab.castor.mapping.CollectionHandler;
import org.exolab.castor.mapping.FieldDescriptor;
import org.exolab.castor.mapping.FieldHandler;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.mapping.TypeConvertor;
import org.exolab.castor.mapping.loader.CollectionHandlers;
import org.exolab.castor.mapping.loader.FieldHandlerImpl;
import org.exolab.castor.mapping.loader.MappingLoader;
import org.exolab.castor.mapping.loader.TypeInfo;
import org.exolab.castor.mapping.xml.BindXml;
import org.exolab.castor.mapping.xml.ClassMapping;
import org.exolab.castor.mapping.xml.FieldMapping;
import org.exolab.castor.mapping.xml.MapTo;
import org.exolab.castor.mapping.xml.Property;
import org.exolab.castor.mapping.xml.types.BindXmlAutoNamingType;
import org.exolab.castor.mapping.xml.types.CollectionType;
import org.exolab.castor.util.LocalConfiguration;
import org.exolab.castor.xml.FieldValidator;
import org.exolab.castor.xml.Introspector;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.NodeType;
import org.exolab.castor.xml.ResolverException;
import org.exolab.castor.xml.XMLClassDescriptor;
import org.exolab.castor.xml.XMLFieldDescriptor;
import org.exolab.castor.xml.XMLNaming;
import org.exolab.castor.xml.handlers.ContainerFieldHandler;
import org.exolab.castor.xml.handlers.ToStringFieldHandler;
import org.exolab.castor.xml.util.ClassDescriptorResolverImpl;
import org.exolab.castor.xml.util.XMLClassDescriptorAdapter;
import org.exolab.castor.xml.util.XMLClassDescriptorImpl;
import org.exolab.castor.xml.util.XMLFieldDescriptorImpl;
import org.exolab.castor.xml.validators.NameValidator;

public class XMLMappingLoader
extends MappingLoader {
    private static final String XML_PREFIX = "xml:";
    private static final Class[] EMPTY_ARGS = new Class[0];
    private static final String NCNAME = "NCName";
    private static final Class[] STRING_ARG = new Class[]{class$java$lang$String == null ? (class$java$lang$String = XMLMappingLoader.class$("java.lang.String")) : class$java$lang$String};
    private static final String VALUE_OF = "valueOf";
    private ClassDescriptorResolverImpl _cdResolver;
    private XMLNaming _naming = null;
    private NodeType _primitiveNodeType = null;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$exolab$castor$mapping$MapItem;
    static /* synthetic */ Class class$org$exolab$castor$xml$util$ContainerElement;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Number;

    public XMLMappingLoader(ClassLoader loader, PrintWriter logWriter) throws MappingException {
        super(loader, logWriter);
        LocalConfiguration config = LocalConfiguration.getInstance();
        this._primitiveNodeType = config.getPrimitiveNodeType();
        this._naming = config.getXMLNaming();
    }

    private void createResolver() {
        this._cdResolver = new ClassDescriptorResolverImpl();
        this._cdResolver.setIntrospection(false);
        this._cdResolver.setLoadPackageMappings(false);
    }

    protected void resolveRelations(ClassDescriptor clsDesc) throws MappingException {
        FieldDescriptor[] fields = clsDesc.getFields();
        for (int i = 0; i < fields.length; ++i) {
            ClassDescriptor relDesc;
            if (fields[i].getClassDescriptor() != null || (relDesc = this.getDescriptor(fields[i].getFieldType())) == NoDescriptor || relDesc == null || !(relDesc instanceof XMLClassDescriptor) || !(fields[i] instanceof XMLFieldDescriptorImpl)) continue;
            ((XMLFieldDescriptorImpl)fields[i]).setClassDescriptor((XMLClassDescriptor)relDesc);
        }
        if (clsDesc instanceof XMLClassDescriptorImpl) {
            ((XMLClassDescriptorImpl)clsDesc).sortDescriptors();
        }
    }

    protected ClassDescriptor createDescriptor(ClassMapping clsMap) throws MappingException {
        String xmlName;
        ClassDescriptor clsDesc;
        if (clsMap.getAutoComplete() && clsMap.getMapTo() == null && clsMap.getFieldMappingCount() == 0 && clsMap.getIdentityCount() == 0) {
            if (this._cdResolver == null) {
                this.createResolver();
            }
            try {
                clsDesc = this._cdResolver.resolve(clsMap.getName());
                if (clsDesc != null) {
                    return clsDesc;
                }
            }
            catch (ResolverException rx) {
                // empty catch block
            }
        }
        clsDesc = super.createDescriptor(clsMap);
        MapTo mapTo = clsMap.getMapTo();
        if (mapTo == null || mapTo.getXml() == null) {
            String clsName = clsDesc.getJavaClass().getName();
            int idx = clsName.lastIndexOf(46);
            if (idx >= 0) {
                clsName = clsName.substring(idx + 1);
            }
            xmlName = this._naming.toXMLName(clsName);
        } else {
            xmlName = clsMap.getMapTo().getXml();
        }
        XMLClassDescriptorAdapter xmlClassDesc = new XMLClassDescriptorAdapter(clsDesc, xmlName, this._primitiveNodeType);
        if (clsMap.getAutoComplete()) {
            int i;
            XMLClassDescriptor referenceDesc = null;
            Class type = xmlClassDesc.getJavaClass();
            if (this._cdResolver == null) {
                this.createResolver();
            }
            try {
                referenceDesc = this._cdResolver.resolve(type);
            }
            catch (ResolverException rx) {
                throw new MappingException(rx);
            }
            if (referenceDesc == null) {
                Introspector introspector = new Introspector();
                try {
                    referenceDesc = introspector.generateClassDescriptor(type);
                    if (clsMap.getExtends() != null) {
                        ((XMLClassDescriptorImpl)referenceDesc).setExtends(null);
                    }
                }
                catch (MarshalException mx) {
                    String error = "unable to introspect class '" + type.getName() + "' for auto-complete: ";
                    throw new MappingException(error + mx.getMessage());
                }
            }
            String identity = "";
            if (clsMap.getIdentityCount() > 0) {
                identity = clsMap.getIdentity(0);
            }
            FieldDescriptor[] fields = xmlClassDesc.getFields();
            XMLFieldDescriptor[] introFields = referenceDesc.getAttributeDescriptors();
            for (i = 0; i < introFields.length; ++i) {
                if (this.isMatchFieldName(fields, introFields[i].getFieldName())) continue;
                if (introFields[i].getFieldName().equals(identity)) {
                    xmlClassDesc.setIdentity(introFields[i]);
                    continue;
                }
                xmlClassDesc.addFieldDescriptor(introFields[i]);
            }
            introFields = referenceDesc.getElementDescriptors();
            for (i = 0; i < introFields.length; ++i) {
                if (this.isMatchFieldName(fields, introFields[i].getFieldName())) continue;
                if (introFields[i].getFieldName().equals(identity)) {
                    xmlClassDesc.setIdentity(introFields[i]);
                    continue;
                }
                xmlClassDesc.addFieldDescriptor(introFields[i]);
            }
            XMLFieldDescriptor field = referenceDesc.getContentDescriptor();
            if (field != null && !this.isMatchFieldName(fields, field.getFieldName())) {
                xmlClassDesc.addFieldDescriptor(field);
            }
        }
        if (mapTo != null) {
            xmlClassDesc.setNameSpacePrefix(mapTo.getNsPrefix());
            xmlClassDesc.setNameSpaceURI(mapTo.getNsUri());
        }
        return xmlClassDesc;
    }

    private boolean isMatchFieldName(FieldDescriptor[] fields, String fieldName) {
        for (int i = 0; i < fields.length; ++i) {
            if (!fields[i].getFieldName().equals(fieldName)) continue;
            return true;
        }
        return false;
    }

    protected FieldDescriptor createFieldDesc(Class javaClass, FieldMapping fieldMap) throws MappingException {
        String setter;
        Class fieldType;
        Class type;
        CollectionType colType = fieldMap.getCollection();
        String xmlName = null;
        NodeType nodeType = null;
        String match = null;
        boolean isReference = false;
        boolean isXMLTransient = false;
        if (fieldMap.getType() == null && colType != null && (colType == CollectionType.HASHTABLE || colType == CollectionType.MAP)) {
            fieldMap.setType((class$org$exolab$castor$mapping$MapItem == null ? (class$org$exolab$castor$mapping$MapItem = XMLMappingLoader.class$("org.exolab.castor.mapping.MapItem")) : class$org$exolab$castor$mapping$MapItem).getName());
        }
        FieldDescriptor fieldDesc = super.createFieldDesc(javaClass, fieldMap);
        BindXml xml = fieldMap.getBindXml();
        boolean deriveNameByClass = false;
        if (xml != null) {
            xmlName = xml.getName();
            if (xml.getNode() != null) {
                nodeType = NodeType.getNodeType(xml.getNode().toString());
            }
            match = xml.getMatches();
            isReference = xml.getReference();
            isXMLTransient = xml.getTransient();
            BindXmlAutoNamingType autoName = xml.getAutoNaming();
            if (autoName != null) {
                deriveNameByClass = autoName == BindXmlAutoNamingType.DERIVEBYCLASS;
            }
        }
        isXMLTransient = isXMLTransient || fieldDesc.isTransient();
        String namespace = null;
        if (xmlName != null && xmlName.length() > 0) {
            if (xmlName.charAt(0) == '{') {
                int idx = xmlName.indexOf(125);
                if (idx < 0) {
                    throw new MappingException("Invalid QName: " + xmlName);
                }
                namespace = xmlName.substring(1, idx);
                xmlName = xmlName.substring(idx + 1);
            } else if (xmlName.startsWith(XML_PREFIX)) {
                namespace = "http://www.w3.org/XML/1998/namespace";
                xmlName = xmlName.substring(4);
            }
        }
        if (nodeType == null) {
            nodeType = XMLMappingLoader.isPrimitive(javaClass) ? this._primitiveNodeType : NodeType.Element;
        }
        if (!deriveNameByClass && xmlName == null && match == null) {
            xmlName = this._naming.toXMLName(fieldDesc.getFieldName());
            match = xmlName + ' ' + fieldDesc.getFieldName();
        }
        XMLFieldDescriptorImpl xmlDesc = new XMLFieldDescriptorImpl(fieldDesc, xmlName, nodeType, this._primitiveNodeType);
        xmlDesc.setTransient(isXMLTransient);
        xmlDesc.setValidator(new FieldValidator());
        xmlDesc.setUseParentsNamespace(true);
        if (deriveNameByClass) {
            xmlDesc.setXMLName(null);
        }
        if (namespace != null) {
            xmlDesc.setNameSpaceURI(namespace);
        }
        if (match != null) {
            xmlDesc.setMatches(match);
            if (xmlName == null) {
                xmlDesc.setXMLName(null);
            }
        }
        xmlDesc.setReference(isReference);
        xmlDesc.setContainer(fieldMap.getContainer());
        if (xml != null) {
            Property[] props;
            if (xml.getClassMapping() != null) {
                ClassDescriptor cd = this.createDescriptor(xml.getClassMapping());
                xmlDesc.setClassDescriptor((XMLClassDescriptor)cd);
            }
            if (xml.getLocation() != null) {
                xmlDesc.setLocationPath(xml.getLocation());
            }
            String xmlType = xml.getType();
            xmlDesc.setSchemaType(xmlType);
            xmlDesc.setQNamePrefix(xml.getQNamePrefix());
            NameValidator validator = null;
            if (NCNAME.equals(xmlType)) {
                validator = new NameValidator(0);
                xmlDesc.setValidator(new FieldValidator(validator));
            }
            if ((props = xml.getProperty()) != null && props.length > 0) {
                for (int pIdx = 0; pIdx < props.length; ++pIdx) {
                    Property prop = props[pIdx];
                    xmlDesc.setProperty(prop.getName(), prop.getValue());
                }
            }
        }
        if (colType == null && CollectionHandlers.hasHandler(type = fieldDesc.getFieldType())) {
            String typeName = CollectionHandlers.getCollectionName(type);
            colType = CollectionType.valueOf(typeName);
        }
        if (colType != null) {
            FieldHandler handler;
            if (colType == CollectionType.HASHTABLE || colType == CollectionType.MAP) {
                String methodName = fieldMap.getSetMethod();
                if (methodName != null) {
                    if (!methodName.startsWith("add")) {
                        xmlDesc.setMapped(true);
                    }
                } else {
                    xmlDesc.setMapped(true);
                }
            }
            if ((nodeType == NodeType.Namespace || xmlDesc.isMapped()) && (handler = xmlDesc.getHandler()) instanceof FieldHandlerImpl) {
                FieldHandlerImpl handlerImpl = (FieldHandlerImpl)handler;
                handlerImpl.setConvertFrom(new IdentityConvertor());
            }
            if (nodeType == NodeType.Element && fieldMap.hasContainer() && !fieldMap.getContainer()) {
                xmlDesc = this.wrapCollection(xmlDesc);
            }
        } else if (!(isReference || isXMLTransient || XMLMappingLoader.isPrimitive(fieldType = xmlDesc.getFieldType()))) {
            Constructor cons = null;
            try {
                cons = fieldType.getConstructor(EMPTY_ARGS);
                if (!Modifier.isPublic(cons.getModifiers())) {
                    cons = null;
                }
            }
            catch (NoSuchMethodException nsmx) {
                // empty catch block
            }
            try {
                Method method;
                Class<?> returnType;
                if (cons == null && (returnType = (method = fieldType.getMethod(VALUE_OF, STRING_ARG)).getReturnType()) != null && fieldType.isAssignableFrom(returnType) && fieldMap.getHandler() == null) {
                    ToStringFieldHandler handler = new ToStringFieldHandler(fieldType, xmlDesc.getHandler());
                    xmlDesc.setHandler(handler);
                    xmlDesc.setImmutable(true);
                }
            }
            catch (NoSuchMethodException nsmx) {
                // empty catch block
            }
        }
        if ((setter = fieldMap.getSetMethod()) != null && setter.startsWith("%")) {
            int index = 0;
            index = Integer.parseInt(setter = setter.substring(1));
            if (index < 1 || index > 9) {
                throw new MappingException("mapper.invalidParameterIndex", setter);
            }
            xmlDesc.setConstructorArgumentIndex(--index);
        }
        return xmlDesc;
    }

    public void setLoadPackageMappings(boolean loadPackageMappings) {
        if (this._cdResolver == null) {
            this.createResolver();
        }
        this._cdResolver.setLoadPackageMappings(loadPackageMappings);
    }

    protected TypeInfo getTypeInfo(Class fieldType, CollectionHandler colHandler, FieldMapping fieldMap) throws MappingException {
        return new TypeInfo(fieldType, null, null, null, fieldMap.getRequired(), null, colHandler, false);
    }

    private XMLFieldDescriptorImpl wrapCollection(XMLFieldDescriptorImpl fieldDesc) throws MappingException {
        Class type = class$org$exolab$castor$xml$util$ContainerElement == null ? (class$org$exolab$castor$xml$util$ContainerElement = XMLMappingLoader.class$("org.exolab.castor.xml.util.ContainerElement")) : class$org$exolab$castor$xml$util$ContainerElement;
        XMLClassDescriptorImpl classDesc = new XMLClassDescriptorImpl(type);
        XMLFieldDescriptorImpl newFieldDesc = new XMLFieldDescriptorImpl(fieldDesc, fieldDesc.getXMLName(), fieldDesc.getNodeType(), this._primitiveNodeType);
        newFieldDesc.setXMLName(null);
        newFieldDesc.setMatches("*");
        classDesc.addFieldDescriptor(newFieldDesc);
        fieldDesc.setClassDescriptor(classDesc);
        ContainerFieldHandler handler = new ContainerFieldHandler(fieldDesc.getHandler());
        newFieldDesc.setHandler(handler);
        fieldDesc.setHandler(handler);
        return new ContainerElementFieldDescriptor(fieldDesc, this._primitiveNodeType);
    }

    protected static boolean isPrimitive(Class type) {
        if (type.isPrimitive()) {
            return true;
        }
        if (type == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = XMLMappingLoader.class$("java.lang.Boolean")) : class$java$lang$Boolean) || type == (class$java$lang$Character == null ? (class$java$lang$Character = XMLMappingLoader.class$("java.lang.Character")) : class$java$lang$Character)) {
            return true;
        }
        return type.getSuperclass() == (class$java$lang$Number == null ? (class$java$lang$Number = XMLMappingLoader.class$("java.lang.Number")) : class$java$lang$Number);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class ContainerElementFieldDescriptor
    extends XMLFieldDescriptorImpl {
        ContainerElementFieldDescriptor(XMLFieldDescriptorImpl fieldDesc, NodeType primitiveNodeType) throws MappingException {
            super(fieldDesc, fieldDesc.getXMLName(), fieldDesc.getNodeType(), primitiveNodeType);
        }

        public Class getFieldType() {
            return class$org$exolab$castor$xml$util$ContainerElement == null ? (class$org$exolab$castor$xml$util$ContainerElement = XMLMappingLoader.class$("org.exolab.castor.xml.util.ContainerElement")) : class$org$exolab$castor$xml$util$ContainerElement;
        }
    }

    class IdentityConvertor
    implements TypeConvertor {
        IdentityConvertor() {
        }

        public Object convert(Object object, String param) throws ClassCastException {
            return object;
        }
    }
}

