/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.javasource;

import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JConstructor;
import org.exolab.javasource.JDocComment;
import org.exolab.javasource.JEnumConstant;
import org.exolab.javasource.JField;
import org.exolab.javasource.JMember;
import org.exolab.javasource.JMethod;
import org.exolab.javasource.JModifiers;
import org.exolab.javasource.JNamedMap;
import org.exolab.javasource.JParameter;
import org.exolab.javasource.JSourceWriter;
import org.exolab.javasource.JType;

public class JEnum
extends JClass {
    private JNamedMap _constants = new JNamedMap();

    protected JEnum(String name) throws IllegalArgumentException {
        super(name);
        this.getJDocComment().setComment("Enumeration " + this.getLocalName() + ".");
    }

    public void addMember(JMember jMember) throws IllegalArgumentException {
        if (jMember instanceof JEnumConstant) {
            this.addConstant((JEnumConstant)jMember);
        } else {
            super.addMember(jMember);
        }
    }

    public void addConstant(JEnumConstant jConstant) throws IllegalArgumentException {
        if (jConstant == null) {
            throw new IllegalArgumentException("Enum fields cannot be null");
        }
        String name = jConstant.getName();
        if (this._constants.get(name) != null) {
            String err = "duplicate name found: " + name;
            throw new IllegalArgumentException(err);
        }
        this._constants.put(name, jConstant);
    }

    public JEnumConstant getConstant(String name) {
        return (JEnumConstant)this._constants.get(name);
    }

    public JEnumConstant[] getConstants() {
        int size = this._constants.size();
        JEnumConstant[] farray = new JEnumConstant[size];
        for (int i = 0; i < size; ++i) {
            farray[i] = (JEnumConstant)this._constants.get(i);
        }
        return farray;
    }

    public void setSuperClass(String superClass) {
        throw new RuntimeException("Enum classes are not allowed to extend other classes.");
    }

    public void print(JSourceWriter jsw) {
        int i;
        Enumeration enumeration;
        int i2;
        if (jsw == null) {
            throw new IllegalArgumentException("argument 'jsw' should not be null.");
        }
        StringBuffer buffer = new StringBuffer();
        this.printHeader(jsw);
        this.printPackageDeclaration(jsw);
        Vector<String> removeImports = null;
        if (this._innerClasses != null && this._innerClasses.size() > 0) {
            removeImports = new Vector<String>();
            for (i2 = 0; i2 < this._innerClasses.size(); ++i2) {
                JClass iClass = (JClass)this._innerClasses.elementAt(i2);
                enumeration = iClass.getImports();
                while (enumeration.hasMoreElements()) {
                    String classname = (String)enumeration.nextElement();
                    if (this.hasImport(classname)) continue;
                    this.addImport(classname);
                    removeImports.addElement(classname);
                }
            }
        }
        this.printImportDeclarations(jsw);
        if (removeImports != null) {
            for (i2 = 0; i2 < removeImports.size(); ++i2) {
                this.removeImport((String)removeImports.elementAt(i2));
            }
        }
        this.getJDocComment().print(jsw);
        buffer.setLength(0);
        this.getAnnotatedElementHelper().printAnnotations(jsw);
        JModifiers modifiers = this.getModifiers();
        if (modifiers.isPrivate()) {
            buffer.append("private ");
        } else if (modifiers.isPublic()) {
            buffer.append("public ");
        }
        buffer.append("enum ");
        buffer.append(this.getLocalName());
        buffer.append(' ');
        if (this.getInterfaceCount() > 0) {
            boolean endl = false;
            if (this.getInterfaceCount() > 1) {
                jsw.writeln(buffer.toString());
                buffer.setLength(0);
                endl = true;
            }
            buffer.append("implements ");
            enumeration = this.getInterfaces();
            while (enumeration.hasMoreElements()) {
                buffer.append(enumeration.nextElement());
                if (!enumeration.hasMoreElements()) continue;
                buffer.append(", ");
            }
            if (endl) {
                jsw.writeln(buffer.toString());
                buffer.setLength(0);
            } else {
                buffer.append(' ');
            }
        }
        buffer.append('{');
        jsw.writeln(buffer.toString());
        buffer.setLength(0);
        jsw.writeln();
        jsw.indent();
        if (this._constants.size() > 0) {
            jsw.writeln();
            jsw.writeln("  //------------------/");
            jsw.writeln(" //- Enum Constants -/");
            jsw.writeln("//------------------/");
            jsw.writeln();
        }
        for (i = 0; i < this._constants.size(); ++i) {
            JEnumConstant jConstant = (JEnumConstant)this._constants.get(i);
            jConstant.print(jsw);
            if (i < this._constants.size() - 1) {
                jsw.write(",");
            } else {
                jsw.write(";");
            }
            jsw.writeln();
        }
        if (this._fields.size() > 0) {
            jsw.writeln();
            jsw.writeln("  //--------------------------/");
            jsw.writeln(" //- Class/Member Variables -/");
            jsw.writeln("//--------------------------/");
            jsw.writeln();
        }
        for (i = 0; i < this._fields.size(); ++i) {
            JField jField = (JField)this._fields.get(i);
            JDocComment comment = jField.getComment();
            if (comment != null) {
                comment.print(jsw);
            }
            jField.printAnnotations(jsw);
            jsw.write(jField.getModifiers().toString());
            jsw.write(32);
            JType type = jField.getType();
            String typeName = type.toString();
            if (typeName.equals(this.toString())) {
                typeName = type.getLocalName();
            }
            jsw.write(typeName);
            jsw.write(32);
            jsw.write(jField.getName());
            String init = jField.getInitString();
            if (init != null) {
                jsw.write(" = ");
                jsw.write(init);
            }
            jsw.writeln(';');
            jsw.writeln();
        }
        if (!this._staticInitializer.isEmpty()) {
            jsw.writeln();
            jsw.writeln("static {");
            jsw.writeln(this._staticInitializer.toString());
            jsw.writeln("};");
            jsw.writeln();
        }
        if (this._constructors.size() > 0) {
            jsw.writeln();
            jsw.writeln("  //----------------/");
            jsw.writeln(" //- Constructors -/");
            jsw.writeln("//----------------/");
            jsw.writeln();
        }
        for (i = 0; i < this._constructors.size(); ++i) {
            JConstructor jConstructor = (JConstructor)this._constructors.elementAt(i);
            jConstructor.print(jsw);
            jsw.writeln();
        }
        if (this._methods.size() > 0) {
            jsw.writeln();
            jsw.writeln("  //-----------/");
            jsw.writeln(" //- Methods -/");
            jsw.writeln("//-----------/");
            jsw.writeln();
        }
        for (i = 0; i < this._methods.size(); ++i) {
            JMethod jMethod = (JMethod)this._methods.elementAt(i);
            jMethod.print(jsw);
            jsw.writeln();
        }
        if (this._innerClasses != null && this._innerClasses.size() > 0) {
            jsw.writeln();
            jsw.writeln("  //-----------------/");
            jsw.writeln(" //- Inner Classes -/");
            jsw.writeln("//-----------------/");
            jsw.writeln();
            for (i = 0; i < this._innerClasses.size(); ++i) {
                JClass jClass = (JClass)this._innerClasses.elementAt(i);
                jClass.print(jsw, true);
                jsw.writeln();
            }
        }
        jsw.unindent();
        jsw.writeln('}');
        jsw.flush();
    }

    public static void main(String[] args) {
        JSourceWriter jsw = new JSourceWriter(new PrintWriter(System.out));
        JEnum color = new JEnum("Color");
        color.addConstant(new JEnumConstant("RED"));
        color.addConstant(new JEnumConstant("GREEN"));
        color.addConstant(new JEnumConstant("BLUE"));
        color.print(jsw);
        color = new JEnum("Color");
        color.addField(new JField(new JType("String"), "_rgb"));
        JConstructor jConstructor = new JConstructor(color);
        jConstructor.addParameter(new JParameter(new JType("String"), "rgb"));
        jConstructor.setSourceCode("_rgb = rgb;");
        color.addConstructor(jConstructor);
        color.addConstant(new JEnumConstant("RED", new String[]{"\"#FF0000\""}));
        color.addConstant(new JEnumConstant("GREEN", new String[]{"\"#00FF00\""}));
        color.addConstant(new JEnumConstant("BLUE", new String[]{"\"#0000FF\""}));
        color.print(jsw);
        JEnum operation = new JEnum("Operation");
        JEnumConstant plus = new JEnumConstant("PLUS");
        JMethod jMethod = new JMethod(new JType("double"), "eval");
        jMethod.getModifiers().makePackage();
        jMethod.addParameter(new JParameter(JClass.Double, "x"));
        jMethod.addParameter(new JParameter(JClass.Double, "y"));
        jMethod.setSourceCode("return x + y;");
        plus.addMethod(jMethod);
        operation.addConstant(plus);
        JEnumConstant minus = new JEnumConstant("MINUS");
        jMethod = new JMethod(JClass.Double, "eval");
        jMethod.getModifiers().makePackage();
        jMethod.addParameter(new JParameter(JClass.Double, "x"));
        jMethod.addParameter(new JParameter(JClass.Double, "y"));
        jMethod.setSourceCode("return x - y;");
        minus.addMethod(jMethod);
        operation.addConstant(minus);
        JEnumConstant times = new JEnumConstant("TIMES");
        jMethod = new JMethod(JClass.Double, "eval");
        jMethod.getModifiers().makePackage();
        jMethod.addParameter(new JParameter(JClass.Double, "x"));
        jMethod.addParameter(new JParameter(JClass.Double, "y"));
        jMethod.setSourceCode("return x * y;");
        times.addMethod(jMethod);
        operation.addConstant(times);
        jMethod = new JMethod(JClass.Double, "eval");
        jMethod.getModifiers().makePackage();
        jMethod.addParameter(new JParameter(JClass.Double, "x"));
        jMethod.addParameter(new JParameter(JClass.Double, "y"));
        jMethod.getModifiers().setAbstract(true);
        operation.addMethod(jMethod);
        operation.print(jsw);
        jsw.flush();
    }
}

