import info.bix.tokai.bixpp.binding.BIXpp;
import info.bix.tokai.bixpp.binding.DescriptionItem;
import info.bix.tokai.bixpp.binding.Item;
import info.bix.tokai.bixpp.io.BIXppIO;
import info.bix.tokai.bixpp.xml.XMLException;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;


public class Sample4 {

    public static void main(String[] args) {

        try {
            BIXpp bixpp;

            bixpp = BIXppIO.read(new File("spinach-j.xml"));

            bixpp.getProducer().setName("John Smith");

            bixpp.getRecordSet().getRecord(1).getItem(0).setValue(25.0);

            DescriptionItem descriptionitem = new DescriptionItem();
            descriptionitem.setIndex(19);
            descriptionitem.setName("1̏oElq");
            bixpp.getRecordingDefinition().addDefinitionItem(descriptionitem);

            Item item = new Item();
            item.setDescription("{͒AɋCBv̌̏ႩȂB");
            bixpp.getRecordSet().getRecord(32).addItem(item);

            BIXppIO.write(bixpp, new File("result2.xml"));

        } catch (XMLException e) {
            e.printStackTrace();
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }

    }

}
