/*
 * Decompiled with CFR 0.152.
 */
package info.bix.tokai.bixpp.io;

import info.bix.tokai.bixpp.binding.BIXpp;
import info.bix.tokai.bixpp.binding.Cultivation;
import info.bix.tokai.bixpp.binding.Link;
import info.bix.tokai.bixpp.binding.RecordingDefinition;
import info.bix.tokai.bixpp.io.CSVExporter;
import info.bix.tokai.bixpp.io.CSVImporter;
import info.bix.tokai.bixpp.io.InputStreamCreator;
import info.bix.tokai.bixpp.xml.SchemaLoadingException;
import info.bix.tokai.bixpp.xml.ValidationException;
import info.bix.tokai.bixpp.xml.XMLException;
import info.bix.tokai.bixpp.xml.XMLValidator;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.util.Date;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.Validate;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;

public final class BIXppIO {
    private static final String BIXPP_MAPPING_FILE = "BIX-ppMapping.xml";
    static /* synthetic */ Class class$0;

    private BIXppIO() {
    }

    public static BIXpp read(File bixppFile) throws ValidationException, XMLException, IOException {
        return BIXppIO.read(bixppFile, false);
    }

    public static BIXpp read(URL bixppURL) throws ValidationException, XMLException, IOException {
        return BIXppIO.read(bixppURL, false);
    }

    public static BIXpp read(InputStream bixppStream) throws ValidationException, XMLException, IOException {
        return BIXppIO.read(bixppStream, false);
    }

    public static void write(BIXpp bixpp, File bixppFile) throws IOException {
        Validate.notNull(bixpp);
        Validate.notNull(bixppFile);
        BIXppIO.write(bixpp, new FileOutputStream(bixppFile));
        try {
            bixpp.setFileURL(bixppFile.toURL());
        }
        catch (Exception e) {
            bixpp.setFileURL(null);
            e.printStackTrace();
        }
    }

    public static void write(BIXpp bixpp, OutputStream bixppStream) throws IOException {
        Validate.notNull(bixpp);
        Validate.notNull(bixppStream);
        bixpp.setVersion(3.0f);
        if (bixpp.getCultivationCount() == 0) {
            bixpp.addCultivation(new Cultivation());
        }
        bixpp.setUpdate(new Date(System.currentTimeMillis()));
        StringWriter writer = null;
        try {
            try {
                writer = new StringWriter();
                Marshaller marshaller = new Marshaller(writer);
                marshaller.setValidation(false);
                marshaller.setRootElement("BIX-pp");
                marshaller.setSchemaLocation("http://w3.fb.u-tokai.ac.jp/BIX-pp/XMLSchema http://w3.fb.u-tokai.ac.jp/BIX-pp/XMLSchema/BIX-pp.xsd");
                Mapping mapping = new Mapping();
                mapping.loadMapping(new Link().getClass().getClassLoader().getResource(BIXPP_MAPPING_FILE));
                marshaller.setMapping(mapping);
                marshaller.marshal(bixpp);
                String language = System.getProperty("user.language");
                if (language.equals("ja")) {
                    writer.getBuffer().insert(38, "<?xml-stylesheet type=\"text/xsl\" href=\"http://w3.fb.u-tokai.ac.jp/bix-pp/XMLSchema/BIX-pp-j.xsl\"?>");
                } else {
                    writer.getBuffer().insert(38, "<?xml-stylesheet type=\"text/xsl\" href=\"http://w3.fb.u-tokai.ac.jp/bix-pp/XMLSchema/BIX-pp.xsl\"?>");
                }
                BufferedWriter writer2 = new BufferedWriter(new OutputStreamWriter(bixppStream, "UTF-8"));
                ((Writer)writer2).write(((Object)writer).toString(), 0, ((Object)writer).toString().length());
                ((Writer)writer2).close();
            }
            catch (MarshalException e) {
                e.printStackTrace();
            }
            catch (org.exolab.castor.xml.ValidationException e) {
                e.printStackTrace();
            }
            catch (MappingException e) {
                e.printStackTrace();
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                throw e;
            }
        }
        finally {
            if (writer != null) {
                IOUtils.closeQuietly(writer);
            }
        }
    }

    public static BIXpp importCSV(BIXpp bixpp, File csvFile) throws IOException {
        Validate.notNull(csvFile);
        return BIXppIO.importCSV(bixpp, csvFile.toURL());
    }

    public static BIXpp importCSV(BIXpp bixpp, URL csvURL) throws IOException {
        Validate.notNull(csvURL);
        return BIXppIO.importCSV(bixpp, InputStreamCreator.openStream(csvURL));
    }

    public static BIXpp importCSV(BIXpp bixpp, InputStream csvStream) throws IOException {
        Validate.notNull(csvStream);
        CSVImporter importer = new CSVImporter(bixpp);
        return importer.importCSV(csvStream);
    }

    public static void exportCSV(BIXpp bixpp, File csvFile) throws IOException {
        Validate.notNull(bixpp);
        Validate.notNull(csvFile);
        RecordingDefinition rd = bixpp.getRecordingDefinition();
        long[] indices = new long[rd.getDefinitionItemCount()];
        int i = 0;
        while (i < indices.length) {
            indices[i] = rd.getDefinitionItem(i).getIndex();
            ++i;
        }
        BIXppIO.exportCSV(bixpp, csvFile, indices);
    }

    public static void exportCSV(BIXpp bixpp, File csvFile, long[] indices) throws IOException {
        Validate.notNull(bixpp);
        Validate.notNull(csvFile);
        Validate.notNull(indices);
        CSVExporter exporter = new CSVExporter();
        exporter.exportCSV(bixpp, csvFile, indices);
    }

    public static BIXpp read(File bixppFile, boolean validate) throws ValidationException, XMLException, IOException {
        Validate.notNull(bixppFile);
        return BIXppIO.read(bixppFile.toURL(), validate);
    }

    public static BIXpp read(URL bixppURL, boolean validate) throws ValidationException, XMLException, IOException {
        Validate.notNull(bixppURL);
        BIXpp bixpp = BIXppIO.read(InputStreamCreator.openStream(bixppURL), validate);
        bixpp.setFileURL(bixppURL);
        return bixpp;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BIXpp read(InputStream bixppStream, boolean validate) throws ValidationException, XMLException, IOException {
        Validate.notNull(bixppStream);
        if (validate) {
            try {
                BIXppIO.verify(bixppStream);
            }
            catch (ValidationException e) {
                throw e;
            }
            catch (IOException e) {
                throw e;
            }
        }
        BufferedReader reader = null;
        try {
            BIXpp bixpp = null;
            reader = new BufferedReader(new InputStreamReader(bixppStream, "UTF8"));
            Unmarshaller unmarshaller = new Unmarshaller(BIXpp.class);
            unmarshaller.setValidation(false);
            Mapping mapping = new Mapping();
            mapping.loadMapping(new Link().getClass().getClassLoader().getResource(BIXPP_MAPPING_FILE));
            unmarshaller.setMapping(mapping);
            BIXpp bIXpp = bixpp = (BIXpp)unmarshaller.unmarshal(reader);
            IOUtils.closeQuietly(reader);
            return bIXpp;
        }
        catch (MappingException e) {
            try {
                e.printStackTrace();
                return null;
                catch (IOException e2) {
                    throw e2;
                }
                catch (Exception e3) {
                    throw new XMLException(e3);
                }
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                IOUtils.closeQuietly(reader);
            }
        }
    }

    private static boolean verify(InputStream stream) throws ValidationException, IOException {
        try {
            XMLValidator validator = new XMLValidator(BIXpp.class.getClassLoader().getResourceAsStream("BIX-pp.xsd"));
            return validator.validate(stream);
        }
        catch (SchemaLoadingException e) {
            e.printStackTrace();
        }
        catch (ValidationException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        return false;
    }
}

