/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.u_tokai.fb.w3.bixcomposite;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jp.ac.u_tokai.fb.w3.bixcomposite.swing.event.BixChartMouseEvent;
import jp.ac.u_tokai.fb.w3.bixcomposite.swing.event.BixChartMouseListener;
import jp.ac.u_tokai.fb.w3.common.AbstractDateChanger;
import jp.ac.u_tokai.fb.w3.common.swing.OutOfRecordBountException;
import jp.ac.u_tokai.fb.w3.common.swing.Timer;
import jp.ac.u_tokai.fb.w3.common.swing.event.BixppOpenListener;
import jp.ac.u_tokai.fb.w3.common.swing.event.ImageControllEvent;
import jp.ac.u_tokai.fb.w3.common.swing.event.ImageControllListener;

public class BixCompositeDateChanger
extends AbstractDateChanger
implements BixppOpenListener,
ImageControllListener,
ChangeListener,
BixChartMouseListener {
    private Timer timer = new Timer(this.delay, new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            if (BixCompositeDateChanger.this.recordIndex < BixCompositeDateChanger.this.recordCount - 1) {
                try {
                    BixCompositeDateChanger.this.setRecordIndex(BixCompositeDateChanger.this.recordIndex + 1);
                }
                catch (OutOfRecordBountException e1) {
                    BixCompositeDateChanger.this.timer.stop();
                }
            } else {
                BixCompositeDateChanger.this.timer.stop();
            }
        }
    });
    private int delay = 100;

    public void setDelay(int delay) {
        this.delay = delay;
        this.timer.setDelay(delay);
    }

    public void playButtonPressed(ImageControllEvent e) {
        if (!this.timer.isRunning()) {
            if (this.recordIndex < this.recordCount - 1) {
                this.timer.start();
            } else {
                try {
                    this.setRecordIndex(0);
                    this.timer.start();
                }
                catch (OutOfRecordBountException outOfRecordBountException) {
                    // empty catch block
                }
            }
        }
    }

    public void stopButtonPressed(ImageControllEvent e) {
        this.timer.stop();
        try {
            this.setRecordIndex(0);
        }
        catch (OutOfRecordBountException outOfRecordBountException) {
            // empty catch block
        }
    }

    public void pauseButtonPressed(ImageControllEvent e) {
        this.timer.stop();
    }

    public void backButtonPressed(ImageControllEvent e) {
        try {
            if (this.recordIndex > 0) {
                this.setRecordIndex(this.recordIndex - 1);
            }
        }
        catch (OutOfRecordBountException e1) {
            e1.printStackTrace();
        }
    }

    public void nextButtonPressed(ImageControllEvent e) {
        try {
            if (this.recordIndex < this.recordCount - 1) {
                this.setRecordIndex(this.recordIndex + 1);
            }
        }
        catch (OutOfRecordBountException e1) {
            e1.printStackTrace();
        }
    }

    public void delayChanged(ImageControllEvent e) {
        this.timer.setDelay(e.getDelay());
    }

    public void stateChanged(ChangeEvent e) {
        int t = ((JSlider)e.getSource()).getValue();
        if (t == this.recordIndex) {
            return;
        }
        try {
            this.setRecordIndex(t);
        }
        catch (OutOfRecordBountException outOfRecordBountException) {
            // empty catch block
        }
    }

    public void chartShapeClicked(BixChartMouseEvent e) {
        try {
            this.setRecordIndex(e.getRecordIndex());
        }
        catch (OutOfRecordBountException outOfRecordBountException) {
            // empty catch block
        }
    }
}

