/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.u_tokai.fb.w3.bixcomposite.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.RenderingHints;
import java.awt.SystemColor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JPanel;
import jp.ac.u_tokai.fb.w3.bixcomposite.swing.event.BixChartMouseEvent;
import jp.ac.u_tokai.fb.w3.bixcomposite.swing.event.BixChartMouseListener;
import jp.ac.u_tokai.fb.w3.bixpp.schema.ver20.BIXpp;
import jp.ac.u_tokai.fb.w3.bixpp.schema.ver20.EventItem;
import jp.ac.u_tokai.fb.w3.bixpp.schema.ver20.Item;
import jp.ac.u_tokai.fb.w3.bixpp.schema.ver20.Record;
import jp.ac.u_tokai.fb.w3.bixpp.schema.ver20.RecordSet;
import jp.ac.u_tokai.fb.w3.common.swing.event.BixppOpenEvent;
import jp.ac.u_tokai.fb.w3.common.swing.event.BixppOpenListener;
import jp.ac.u_tokai.fb.w3.common.swing.event.ChangeDateEvent;
import jp.ac.u_tokai.fb.w3.common.swing.event.ChangeDateListener;
import jp.ac.u_tokai.fb.w3.common.swing.event.SelectDataItemEvent;
import jp.ac.u_tokai.fb.w3.common.swing.event.SelectDataItemListener;
import jp.ac.u_tokai.fb.w3.common.swing.event.SelectEventItemEvent;
import jp.ac.u_tokai.fb.w3.common.swing.event.SelectEventItemListener;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.plot.CombinedDomainXYPlot;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.StandardXYItemRenderer;
import org.jfree.data.XYSeries;
import org.jfree.data.XYSeriesCollection;
import org.jfree.ui.RectangleAnchor;
import org.jfree.ui.TextAnchor;

public class BixCompositeChartPanel
extends JPanel
implements BixppOpenListener,
SelectDataItemListener,
SelectEventItemListener,
ChangeDateListener {
    private Vector listeners = new Vector();
    private XYPlot eventPlot;
    private XYPlot dataPlot;
    private StandardXYItemRenderer dataRenderer;
    private StandardXYItemRenderer eventRenderer;
    private BIXpp bixpp;
    private ValueMarker marker;
    private ChartPanel chartPanel;
    private XYSeriesCollection eventSeriesCollection;
    private XYSeriesCollection dataSeriesCollection;
    private XYSeries dataSeries;
    private CombinedDomainXYPlot cplot;
    private NumberAxis raxis1;
    private NumberAxis raxis0;
    private NumberAxis daxis;
    private Ellipse2D defaultCircle = new Ellipse2D.Double(-4.0, -4.0, 8.0, 8.0);
    private Ellipse2D mouseEnteredCircle = new Ellipse2D.Double(-6.0, -6.0, 12.0, 12.0);

    public BixCompositeChartPanel() {
        this.initialize();
    }

    private void initialize() {
        this.daxis = new NumberAxis("\u7d4c\u904e\u65e5\u6570");
        this.daxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        this.daxis.setAutoRange(false);
        this.daxis.setAutoTickUnitSelection(true);
        this.daxis.setTickMarksVisible(false);
        this.raxis0 = new NumberAxis("");
        this.raxis0.setVisible(true);
        this.raxis0.setAutoRange(true);
        this.raxis0.setAutoRangeIncludesZero(false);
        this.raxis0.setTickLabelsVisible(true);
        this.raxis0.setAutoTickUnitSelection(true);
        this.raxis1 = new NumberAxis();
        this.raxis1.setVisible(false);
        this.raxis1.setAutoRange(true);
        this.raxis1.setUpperMargin(0.2);
        this.raxis1.setLowerMargin(0.2);
        this.dataRenderer = new StandardXYItemRenderer();
        this.dataRenderer.setPlotShapes(true);
        this.dataRenderer.setShapesFilled(true);
        this.dataRenderer.setPlotLines(true);
        this.dataRenderer.setSeriesPaint(0, Color.BLUE);
        this.dataRenderer.setShape(this.defaultCircle);
        this.eventRenderer = new StandardXYItemRenderer();
        this.eventRenderer.setPlotShapes(true);
        this.eventRenderer.setShapesFilled(true);
        this.eventRenderer.setPlotLines(false);
        this.eventRenderer.setSeriesPaint(0, Color.BLACK);
        this.eventRenderer.setSeriesPaint(1, Color.BLUE);
        this.eventRenderer.setSeriesPaint(2, Color.CYAN);
        this.eventRenderer.setSeriesPaint(3, Color.LIGHT_GRAY);
        this.eventRenderer.setSeriesPaint(4, Color.GREEN);
        this.eventRenderer.setSeriesPaint(5, Color.MAGENTA);
        this.eventRenderer.setSeriesPaint(6, Color.ORANGE);
        this.eventRenderer.setSeriesPaint(7, Color.PINK);
        this.eventRenderer.setSeriesPaint(8, Color.RED);
        this.eventRenderer.setSeriesPaint(9, Color.GRAY);
        this.eventRenderer.setSeriesPaint(10, Color.DARK_GRAY);
        this.eventRenderer.setShape(this.defaultCircle);
        this.eventRenderer.setStroke(null);
        this.cplot = new CombinedDomainXYPlot(this.daxis);
        this.dataSeriesCollection = new XYSeriesCollection();
        this.eventSeriesCollection = new XYSeriesCollection();
        this.dataPlot = new XYPlot(this.dataSeriesCollection, null, this.raxis0, this.dataRenderer);
        this.dataPlot.setBackgroundPaint(SystemColor.control);
        this.eventPlot = new XYPlot(this.eventSeriesCollection, null, this.raxis1, this.eventRenderer);
        this.eventPlot.setBackgroundPaint(SystemColor.control);
        this.eventPlot.setRangeGridlinesVisible(false);
        this.cplot.add(this.dataPlot, 2);
        this.cplot.add(this.eventPlot, 1);
        JFreeChart chart = new JFreeChart("", JFreeChart.DEFAULT_TITLE_FONT, this.cplot, true);
        chart.setBackgroundPaint(SystemColor.control);
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        chart.setRenderingHints(hints);
        chart.setLegend(null);
        this.chartPanel = new ChartPanel(chart);
        this.chartPanel.getPopupMenu().remove(0);
        this.chartPanel.getPopupMenu().remove(0);
        this.chartPanel.setMaximumDrawHeight(100000);
        this.chartPanel.setMaximumDrawWidth(100000);
        this.chartPanel.setMinimumDrawHeight(0);
        this.chartPanel.setMinimumDrawWidth(0);
        this.chartPanel.setRefreshBuffer(true);
        this.chartPanel.setMouseZoomable(true, false);
        this.chartPanel.setDoubleBuffered(true);
        this.chartPanel.addChartMouseListener(new ChartMouseListener(){

            public void chartMouseClicked(ChartMouseEvent e) {
                XYItemEntity entity = null;
                double days = 0.0;
                if (e.getEntity() instanceof XYItemEntity) {
                    entity = (XYItemEntity)e.getEntity();
                    if (entity.getDataset() == BixCompositeChartPanel.this.dataSeriesCollection) {
                        days = BixCompositeChartPanel.this.dataSeries.getDataItem(entity.getItem()).getX().doubleValue();
                    } else if (entity.getDataset() == BixCompositeChartPanel.this.eventSeriesCollection) {
                        days = BixCompositeChartPanel.this.eventSeriesCollection.getSeries(entity.getSeriesIndex()).getDataItem(entity.getItem()).getX().doubleValue();
                    } else {
                        return;
                    }
                    RecordSet recordSet = BixCompositeChartPanel.this.bixpp.getRecordSet();
                    int recordIndex = 0;
                    int i = 0;
                    while (i < recordSet.getRecordCount()) {
                        if (recordSet.getRecord(i).getDays() == days) {
                            recordIndex = i;
                            break;
                        }
                        if (i == recordSet.getRecordCount() - 1) {
                            return;
                        }
                        ++i;
                    }
                    BixCompositeChartPanel.this.fireBixChartShapeClicked(recordIndex);
                }
            }

            public void chartMouseMoved(ChartMouseEvent e) {
            }
        });
        this.setLayout(new BorderLayout());
        this.add(this.chartPanel);
        this.chartPanel.addMouseListener(new MouseAdapter(){

            public void mouseExited(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }
        });
    }

    public XYSeriesCollection getDataSeriesCollection() {
        return this.dataSeriesCollection;
    }

    public XYSeriesCollection getEventSeriesCollection() {
        return this.eventSeriesCollection;
    }

    public void setRange(double lower, double upper) {
        this.daxis.setRange(lower, upper);
    }

    public void addChartMouseListener(ChartMouseListener listener) {
        this.chartPanel.addChartMouseListener(listener);
    }

    public void bixppOpened(BixppOpenEvent e) {
        this.bixpp = e.getBixpp();
        this.setRange(0.0, this.bixpp.getRecordSet().getRecord(this.bixpp.getRecordSet().getRecordCount() - 1).getDays());
        this.eventSeriesCollection.removeAllSeries();
    }

    public void dataItemSelected(SelectDataItemEvent e) {
        this.raxis0.setLabel(e.getDataItems()[0].getUnit());
        this.dataSeriesCollection.removeAllSeries();
        this.dataSeries = new XYSeries(e.getDataItems()[0].getName());
        Record[] records = this.bixpp.getRecordSet().getRecord();
        double index = e.getDataItems()[0].getIndex();
        int i = 0;
        while (i < records.length) {
            Item[] items = records[i].getItem();
            int j = 0;
            while (j < items.length) {
                if (items[j].getIndex() == index) {
                    this.dataSeries.add(records[i].getDays(), items[j].getValue());
                    break;
                }
                ++j;
            }
            ++i;
        }
        this.dataSeriesCollection.addSeries(this.dataSeries);
    }

    public void eventItemSelected(SelectEventItemEvent e) {
        this.eventSeriesCollection.removeAllSeries();
        EventItem[] eventItems = e.getEventItems();
        int i = 0;
        while (i < eventItems.length) {
            double index = eventItems[i].getIndex();
            XYSeries eventSeries = new XYSeries(eventItems[i].getName());
            int j = 0;
            while (j < this.bixpp.getRecordSet().getRecordCount()) {
                Record record = this.bixpp.getRecordSet().getRecord(j);
                int k = 0;
                while (k < record.getItemCount()) {
                    if (record.getItem(k).getIndex() == index) {
                        eventSeries.add(record.getDays(), eventItems.length - i);
                        break;
                    }
                    ++k;
                }
                ++j;
            }
            this.eventSeriesCollection.addSeries(eventSeries);
            ++i;
        }
    }

    public StandardXYItemRenderer getEventRenderer() {
        return this.eventRenderer;
    }

    public void recordIndexChanged(ChangeDateEvent e) {
        this.dataPlot.clearDomainMarkers();
        this.eventPlot.clearDomainMarkers();
        this.marker = new ValueMarker(this.bixpp.getRecordSet().getRecord(e.getRecordIndex()).getDays());
        this.marker.setLabelAnchor(RectangleAnchor.RIGHT);
        this.marker.setLabelTextAnchor(TextAnchor.TOP_LEFT);
        this.marker.setPaint(Color.RED);
        this.dataPlot.addDomainMarker(this.marker);
        this.eventPlot.addDomainMarker(this.marker);
    }

    public void addBixChartMouseListener(BixChartMouseListener listener) {
        this.listeners.addElement(listener);
    }

    public void removeBixChartMouseListener(BixChartMouseListener listener) {
        this.listeners.removeElement(listener);
    }

    public void fireBixChartShapeClicked(int recordIndex) {
        BixChartMouseEvent e = new BixChartMouseEvent(this, recordIndex);
        Enumeration enumeration = ((Vector)this.listeners.clone()).elements();
        while (enumeration.hasMoreElements()) {
            ((BixChartMouseListener)enumeration.nextElement()).chartShapeClicked(e);
        }
    }
}

