/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.u_tokai.fb.w3.common.swing;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.FileCacheImageInputStream;
import javax.imageio.stream.ImageInputStream;
import javax.swing.JPanel;
import jp.ac.u_tokai.fb.w3.bixpp.schema.ver20.BIXpp;
import jp.ac.u_tokai.fb.w3.bixpp.schema.ver20.ImageItem;
import jp.ac.u_tokai.fb.w3.bixpp.schema.ver20.Record;
import jp.ac.u_tokai.fb.w3.bixpp.schema.ver20.RecordingDefinition;
import jp.ac.u_tokai.fb.w3.common.swing.SamplingRateSelectable;
import jp.ac.u_tokai.fb.w3.common.swing.event.BixppOpenEvent;
import jp.ac.u_tokai.fb.w3.common.swing.event.BixppOpenListener;
import jp.ac.u_tokai.fb.w3.common.swing.event.ChangeDateEvent;
import jp.ac.u_tokai.fb.w3.common.swing.event.ChangeDateListener;
import jp.ac.u_tokai.fb.w3.common.swing.event.SelectImageItemEvent;
import jp.ac.u_tokai.fb.w3.common.swing.event.SelectImageItemListener;
import jp.ac.u_tokai.fb.w3.common.swing.event.SelectSamplingRateEvent;
import jp.ac.u_tokai.fb.w3.common.swing.event.SelectSamplingRateListener;

public class ImagePanel
extends JPanel
implements SelectImageItemListener,
BixppOpenListener,
ChangeDateListener,
SelectSamplingRateListener,
SamplingRateSelectable {
    private Vector listeners = new Vector();
    private ImageItem imageItem = null;
    private int imageItemIndex;
    private int imageIndex = 0;
    private URI path = null;
    private BIXpp bixpp = null;
    private Dimension baseSize = new Dimension(160, 120);
    private boolean autoResize = false;
    private URL url = null;
    private volatile int samplingRate = 1;
    private boolean resizeFlag = false;
    private Image bufferedImage = null;
    private File userDir = new File(System.getProperty("user.dir"));
    private String suffix = "";
    private Iterator readers = null;
    private ImageInputStream stream = null;
    private ImageReader reader = null;
    private Dimension dimension = new Dimension(0, 0);
    private Vector imageUrls = new Vector();

    void initialize() {
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.bufferedImage != null) {
            g.drawImage(this.bufferedImage, 0, 0, this);
        }
    }

    public void setImage(BufferedImage bi) {
        if (this.resizeFlag) {
            if (bi.getWidth() > this.getWidth() || bi.getHeight() > this.getHeight()) {
                this.bufferedImage = bi.getScaledInstance(this.getWidth(), -1, 2);
            } else {
                this.bufferedImage.flush();
                this.bufferedImage = bi;
            }
        } else {
            this.setSize(new Dimension(bi.getWidth(), bi.getHeight()));
            this.setPreferredSize(new Dimension(bi.getWidth(), bi.getHeight()));
            this.bufferedImage = bi;
        }
    }

    public synchronized void setImage(URL url) {
        this.clearImage();
        if (url != null) {
            this.url = url;
            String s = this.getSuffix(url.getFile());
            if (!this.suffix.equals(s)) {
                this.readers = ImageIO.getImageReadersBySuffix(s);
                if (this.readers.hasNext()) {
                    this.reader = (ImageReader)this.readers.next();
                }
                this.suffix = s;
            }
            if (this.reader != null) {
                try {
                    int samplingRateTemp;
                    this.stream = new FileCacheImageInputStream(url.openStream(), this.userDir);
                    this.reader.setInput(this.stream);
                    if (this.autoResize && this.samplingRate != (samplingRateTemp = this.getAutoSamplingRate(this.reader))) {
                        this.samplingRate = samplingRateTemp;
                        this.fireSelectSamplingRateEvent(this.samplingRate);
                    }
                    if (this.samplingRate == 1) {
                        this.bufferedImage = this.reader.read(0);
                    } else {
                        ImageReadParam param = this.reader.getDefaultReadParam();
                        param.setSourceSubsampling(this.samplingRate, this.samplingRate, 0, 0);
                        this.bufferedImage = this.reader.read(0, param);
                    }
                    this.stream.close();
                    this.setSizeIfImageSizeIsDifferent(this.bufferedImage.getWidth(this), this.bufferedImage.getHeight(this));
                }
                catch (IOException ex) {}
            }
        } else {
            this.setSizeIfImageSizeIsDifferent(1, 1);
        }
        this.repaint();
    }

    public void setSamplingRate(int rate) {
        if (rate == this.samplingRate) {
            return;
        }
        this.samplingRate = rate > 0 ? rate : 1;
        if (this.url != null) {
            this.setImage(this.url);
        }
    }

    public void setResizeFlag(boolean b) {
        this.resizeFlag = b;
    }

    public void clearImage() {
        if (this.bufferedImage != null) {
            this.bufferedImage.flush();
        }
        this.bufferedImage = null;
        this.url = null;
    }

    protected String getSuffix(String filename) {
        int i = filename.lastIndexOf(46);
        if (i > 0 && i < filename.length() - 1) {
            return filename.substring(i + 1).toLowerCase();
        }
        return "";
    }

    public void setAutoResize(boolean autoResizeFlag) {
        this.autoResize = autoResizeFlag;
    }

    public void SetAutoResizeBaseSize(Dimension size) {
        if (size.width > 0 && size.height > 0) {
            this.baseSize = size;
            if (this.url != null & this.autoResize) {
                this.setImage(this.url);
            }
        }
    }

    public void SetAutoResizeBaseSize(int width, int height) {
        this.SetAutoResizeBaseSize(new Dimension(width, height));
    }

    public void imageItemSelected(SelectImageItemEvent e) {
        this.setImageItem(e.getImageItems()[0]);
    }

    public void bixppOpened(BixppOpenEvent e) {
        this.bixpp = e.getBixpp();
        this.path = e.getPath();
    }

    public void recordIndexChanged(ChangeDateEvent e) {
        this.setRecordIndex(e.getRecordIndex());
    }

    public void setRecordIndex(int index) {
        this.imageIndex = index;
        this.setImage((URL)this.imageUrls.get(index));
    }

    public void setImageItemIndex(int index) {
        if (this.bixpp != null) {
            this.setImageItem(this.bixpp.getRecordingDefinition().getImageItem(index));
        }
    }

    public void setImageItem(ImageItem imageItem) {
        this.imageItem = imageItem;
        RecordingDefinition recordingDefinition = this.bixpp.getRecordingDefinition();
        int i = 0;
        while (i < recordingDefinition.getImageItemCount()) {
            if (recordingDefinition.getImageItem(i) == imageItem) {
                this.imageItemIndex = i;
                break;
            }
            ++i;
        }
        this.imageUrls.removeAllElements();
        this.imageUrls.setSize(this.bixpp.getRecordSet().getRecordCount());
        double index = imageItem.getIndex();
        int i2 = 0;
        while (i2 < this.bixpp.getRecordSet().getRecordCount()) {
            Record record = this.bixpp.getRecordSet().getRecord(i2);
            int j = 0;
            while (j < record.getItemCount()) {
                if (record.getItem(j).getIndex() == index) {
                    try {
                        try {
                            this.imageUrls.setElementAt(this.path.resolve(record.getItem(j).getImage().getLink().getURI()).toURL(), i2);
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                        }
                    }
                    catch (Throwable throwable) {}
                    break;
                }
                ++j;
            }
            ++i2;
        }
        this.setRecordIndex(this.imageIndex);
    }

    public ImageItem getImageItem() {
        return this.imageItem;
    }

    public int getSamplingRate() {
        return this.samplingRate;
    }

    public int getImageItemIndex() {
        return this.imageItemIndex;
    }

    public void samplingRateSelected(SelectSamplingRateEvent e) {
        this.setSamplingRate(e.getSamplingRate());
    }

    public void addSelectSamplingRateListener(SelectSamplingRateListener listener) {
        this.listeners.addElement(listener);
    }

    public void removeSelectSamplingRateListener(SelectSamplingRateListener listener) {
        this.listeners.removeElement(listener);
    }

    public void fireSelectSamplingRateEvent(int samplingRate) {
        SelectSamplingRateEvent e = new SelectSamplingRateEvent(this, samplingRate);
        Enumeration enumeration = ((Vector)this.listeners.clone()).elements();
        while (enumeration.hasMoreElements()) {
            ((SelectSamplingRateListener)enumeration.nextElement()).samplingRateSelected(e);
        }
    }

    public boolean isAutoResize() {
        return this.autoResize;
    }

    public URL getUrl() {
        return this.url;
    }

    private void setSizeIfImageSizeIsDifferent(int width, int height) {
        if (this.dimension.getHeight() != (double)height || this.dimension.getWidth() != (double)width) {
            this.dimension.setSize(width, height);
            this.setPreferredSize(this.dimension);
            this.setSize(this.dimension);
        }
    }

    private int getAutoSamplingRate(ImageReader reader) {
        try {
            int width = reader.getWidth(0);
            int height = reader.getHeight(0);
            int samplingRateTemp = 1;
            while (this.baseSize.getWidth() < (double)(width / samplingRateTemp)) {
                ++samplingRateTemp;
            }
            while (this.baseSize.getHeight() < (double)(height / samplingRateTemp)) {
                ++samplingRateTemp;
            }
            return samplingRateTemp;
        }
        catch (IOException e) {
            return 1;
        }
    }
}

