/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.u_tokai.fb.w3.common.swing;

import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JList;
import jp.ac.u_tokai.fb.w3.common.swing.CheckBoxListCellRenderer;
import jp.ac.u_tokai.fb.w3.common.swing.CheckBoxListModel;
import jp.ac.u_tokai.fb.w3.common.swing.event.CheckBoxListSelectionEvent;
import jp.ac.u_tokai.fb.w3.common.swing.event.CheckBoxListSelectionListener;

public class CheckBoxList
extends JList {
    private Vector checkBoxListSelectionListeners = new Vector();
    private CheckBoxListModel ivjCheckBoxListModel = null;
    private CheckBoxListCellRenderer checkBoxListCellRenderer = null;

    public CheckBoxList() {
        this.initialize();
    }

    private void initialize() {
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                Point point = e.getPoint();
                int index = CheckBoxList.this.locationToIndex(point);
                if (index > -1 && index < CheckBoxList.this.getModel().getSize() && (e.getModifiers() & 0x10) != 0) {
                    CheckBoxList.this.setSelectedCheckBox(index, !CheckBoxList.this.isSelectedCheckBoxAt(index));
                }
            }
        });
        this.setCellRenderer(this.getCheckBoxListCellRenderer());
        this.setModel(this.getIvjCheckBoxListModel());
        this.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent e) {
                int keyCode = e.getKeyCode();
                int[] indices = CheckBoxList.this.getSelectedIndices();
                if (keyCode == 32 || keyCode == 10 || indices.length > 0) {
                    int i = 0;
                    while (i < indices.length) {
                        CheckBoxList.this.setSelectedCheckBox(indices[i], !CheckBoxList.this.isSelectedCheckBoxAt(indices[i]));
                        ++i;
                    }
                }
            }
        });
    }

    private CheckBoxListModel getIvjCheckBoxListModel() {
        if (this.ivjCheckBoxListModel == null) {
            this.ivjCheckBoxListModel = new CheckBoxListModel();
        }
        return this.ivjCheckBoxListModel;
    }

    private CheckBoxListCellRenderer getCheckBoxListCellRenderer() {
        if (this.checkBoxListCellRenderer == null) {
            this.checkBoxListCellRenderer = new CheckBoxListCellRenderer();
        }
        return this.checkBoxListCellRenderer;
    }

    public void setSelectedCheckBox(int index, boolean selected) {
        CheckBoxListModel model = (CheckBoxListModel)this.getModel();
        model.setSelectedAt(index, selected);
        this.fireCheckBoxListSelectionEvent();
        this.repaint();
    }

    public boolean isSelectedCheckBoxAt(int index) {
        return ((CheckBoxListModel)this.getModel()).isSelectedAt(index);
    }

    public void addCheckBoxListSelectionListener(CheckBoxListSelectionListener listener) {
        this.checkBoxListSelectionListeners.addElement(listener);
    }

    public void removeCheckBoxListSelectionListener(CheckBoxListSelectionListener listener) {
        this.checkBoxListSelectionListeners.removeElement(listener);
    }

    private void fireCheckBoxListSelectionEvent() {
        CheckBoxListSelectionEvent checkBoxListSelectionEvent = new CheckBoxListSelectionEvent(this, this.getSelectedCheckBoxIndices());
        Enumeration enumeration = ((Vector)this.checkBoxListSelectionListeners.clone()).elements();
        while (enumeration.hasMoreElements()) {
            ((CheckBoxListSelectionListener)enumeration.nextElement()).valueChanged(checkBoxListSelectionEvent);
        }
    }

    public int[] getSelectedCheckBoxIndices() {
        CheckBoxListModel model = (CheckBoxListModel)this.getModel();
        int[] indicesTemp = new int[model.getSize()];
        int count = 0;
        int i = 0;
        while (i < indicesTemp.length) {
            if (model.isSelectedAt(i)) {
                indicesTemp[count++] = i;
            }
            ++i;
        }
        int[] indices = new int[count];
        System.arraycopy(indicesTemp, 0, indices, 0, count);
        return indices;
    }

    public void clearCheckBox() {
        ((CheckBoxListModel)this.getModel()).clearCheckBox();
        this.fireCheckBoxListSelectionEvent();
        this.repaint();
    }
}

