/*
 * 쐬: 2004/06/02
 *
 */
package common.swing;

import java.awt.event.*;
import java.util.*;

import javax.swing.*;

import jp.ac.u_tokai.fb.w3.bixpp.*;

import common.swing.event.*;

/**
 * @author Shiozawa
 *
 */
public class ImageItemComboBox
	extends JComboBox
	implements BixppOpenListener, ItemListener {

	private ImageItemComboBoxModel model = null;
	private Vector listeners = null;

	public ImageItemComboBox() {
		model = new ImageItemComboBoxModel();
		listeners = new Vector();
		this.setModel(model);
		this.addItemListener(this);
	}

	/* ( Javadoc)
	 * @see common.swing.BixppOpenListener#bixppOpened(common.swing.BixppOpenEvent)
	 */
	public void bixppOpened(BixppOpenEvent e) {
		model.bixppOpened(e);
	}

	public void addChooseImageListener(ChooseImageItemListener listener) {
		listeners.addElement(listener);
	}

	public void removeChooseImageListener(ChooseImageItemListener listener) {
		listeners.removeElement(listener);
	}

	public void fireChooseImage(ChooseImageItemEvent e) {
		Vector listeners_ = (Vector) listeners.clone();
		Enumeration enum = listeners_.elements();
		while (enum.hasMoreElements()) {
			ChooseImageItemListener listener = (ChooseImageItemListener) enum.nextElement();
			listener.imageChosen(e);
		}
	}

	/* ( Javadoc)
	 * @see java.awt.event.ItemListener#itemStateChanged(java.awt.event.ItemEvent)
	 */
	public void itemStateChanged(ItemEvent e) {
		ChooseImageItemEvent event =
			new ChooseImageItemEvent(this, getSelectedImageItem());
		fireChooseImage(event);
	}
	
	public ImageItem getSelectedImageItem() {
		return model.getImageItemAt(this.getSelectedIndex());
	}
}
