/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.BixImagePanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URL;
import java.util.GregorianCalendar;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JSlider;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jp.ac.u_tokai.fb.w3.bixpp.schema.ver20.BIXpp;
import jp.ac.u_tokai.fb.w3.bixpp.schema.ver20.ImageItem;
import jp.ac.u_tokai.fb.w3.bixpp.schema.ver20.Record;
import jp.ac.u_tokai.fb.w3.bixpp.schema.ver20.RecordSet;
import jp.ac.u_tokai.fb.w3.common.swing.BixppSliderLabelTable;
import jp.ac.u_tokai.fb.w3.common.swing.ImageControllPanel;
import jp.ac.u_tokai.fb.w3.common.swing.ImageItemListModel;
import jp.ac.u_tokai.fb.w3.common.swing.ImagePanel;
import jp.ac.u_tokai.fb.w3.common.swing.SamplingRateComboBox;
import jp.ac.u_tokai.fb.w3.common.swing.event.BixppOpenEvent;
import jp.ac.u_tokai.fb.w3.common.swing.event.BixppOpenListener;
import jp.ac.u_tokai.fb.w3.common.swing.event.ImageControllEvent;
import jp.ac.u_tokai.fb.w3.common.swing.event.ImageControllListener;

public class BixImageExecutor
implements ListSelectionListener,
ImageControllListener,
ChangeListener,
ActionListener,
BixppOpenListener {
    private JComboBox chooseSamplingRateComboBox;
    private BixppSliderLabelTable labelTable;
    private URI path;
    private int maxDays = 0;
    private ImageItem[] imageItems = null;
    private ImageControllPanel imageControllPanel;
    private JSlider slider;
    private JList list;
    private ImagePanel imagePanel;
    private File userDir = new File(System.getProperty("user.dir"));
    private GregorianCalendar calendar = new GregorianCalendar();
    private volatile int imageCnt;
    private Vector imageUrls;
    private BixImagePanel bixImagePanel;
    private BIXpp bixpp;
    private BufferedImage bi;
    private Timer timer;
    private int interval = 100;
    private ImageItemListModel bixppImageListModel;

    public BixImageExecutor(BixImagePanel bixImagePanel, ImagePanel panel, JList list, JSlider slider, ImageControllPanel imageControllPanel, JComboBox chooseSamplingRateComboBox) {
        this.bixImagePanel = bixImagePanel;
        this.imagePanel = panel;
        this.list = list;
        this.slider = slider;
        this.imageControllPanel = imageControllPanel;
        this.chooseSamplingRateComboBox = chooseSamplingRateComboBox;
        ((SamplingRateComboBox)chooseSamplingRateComboBox).addSelectSamplingRateListener(this.imagePanel);
        list.addListSelectionListener(this);
        this.bixppImageListModel = new ImageItemListModel();
        list.setModel(this.bixppImageListModel);
        imageControllPanel.addImageControllListener(this);
        slider.addChangeListener(this);
        imageControllPanel.setDelay(this.interval);
        this.labelTable = new BixppSliderLabelTable();
        this.timer = new Timer(this.interval, this);
        this.imageUrls = new Vector();
    }

    public void valueChanged(ListSelectionEvent eve) {
        if (eve.getValueIsAdjusting()) {
            return;
        }
        RecordSet recordSet = this.bixpp.getRecordSet();
        double maxDaysDouble = recordSet.getRecord(recordSet.getRecordCount() - 1).getDays();
        BigDecimal bigDecimal = new BigDecimal(maxDaysDouble);
        this.maxDays = bigDecimal.setScale(1, 0).intValue();
        this.imageUrls.clear();
        this.imageUrls.setSize(recordSet.getRecordCount());
        if (this.imageItems.length > 0 && this.list.getSelectedIndex() >= 0) {
            double index = this.imageItems[this.list.getSelectedIndex()].getIndex();
            int j = 0;
            while (j < recordSet.getRecordCount()) {
                Record record = recordSet.getRecord(j);
                int k = 0;
                while (k < record.getItemCount()) {
                    if (index == record.getItem(k).getIndex()) {
                        try {
                            this.imageUrls.setElementAt(this.path.resolve(record.getItem(k).getImage().getLink().getURI()).toURL(), j);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        break;
                    }
                    ++k;
                }
                ++j;
            }
        }
        if (this.imageCnt > this.imageUrls.size() - 1) {
            this.imageCnt = 0;
        }
        this.bixImagePanel.setSliderSpan(0, this.imageUrls.size() - 1);
        this.changeImage();
    }

    private synchronized void changeImage() {
        if (this.imageUrls.size() <= 0) {
            return;
        }
        URL url = (URL)this.imageUrls.get(this.imageCnt);
        if (url != null) {
            this.imagePanel.setImage(url);
        } else {
            this.imagePanel.clearImage();
        }
        String s = url != null ? url.toString() : "";
        int days = (int)Math.floor(this.bixpp.getRecordSet().getRecord(this.imageCnt).getDays());
        this.calendar.setTime(this.bixpp.getStart().toDate());
        this.calendar.add(5, days);
        this.bixImagePanel.setInformation(s, String.valueOf(this.calendar.get(1)) + "\u5e74" + (this.calendar.get(2) + 1) + "\u6708" + this.calendar.get(5) + "\u65e5", days + "\u65e5");
        this.slider.setValue(this.imageCnt);
        this.bixImagePanel.repaint();
    }

    public void playButtonPressed(ImageControllEvent e) {
        this.timer.start();
    }

    public void stopButtonPressed(ImageControllEvent e) {
        this.timer.stop();
        this.imageCnt = 0;
        this.changeImage();
    }

    public void pauseButtonPressed(ImageControllEvent e) {
        this.timer.stop();
    }

    public void backButtonPressed(ImageControllEvent e) {
        this.backImage();
    }

    public void nextButtonPressed(ImageControllEvent e) {
        this.nextImage();
    }

    public void delayChanged(ImageControllEvent e) {
        this.interval = e.getDelay();
        this.timer.setDelay(this.interval);
    }

    public void stateChanged(ChangeEvent arg0) {
        int value = ((JSlider)arg0.getSource()).getValue();
        if (this.imageCnt != value) {
            this.imageCnt = value;
            this.changeImage();
        }
    }

    public void actionPerformed(ActionEvent arg0) {
        if (this.imageCnt < this.imageUrls.size() - 1) {
            ++this.imageCnt;
            this.changeImage();
        } else {
            this.timer.stop();
            this.imageCnt = 0;
            this.changeImage();
        }
    }

    private void nextImage() {
        if (this.imageCnt < this.imageUrls.size() - 1) {
            ++this.imageCnt;
            this.changeImage();
        }
    }

    private void backImage() {
        if (this.imageCnt > 0) {
            --this.imageCnt;
            this.changeImage();
        }
    }

    public void bixppOpened(BixppOpenEvent e) {
        this.bixpp = e.getBixpp();
        this.path = e.getPath();
        this.imageItems = this.bixpp.getRecordingDefinition().getImageItem();
        this.bixppImageListModel.bixppOpened(e);
        this.labelTable.createLabel(this.bixpp);
        this.slider.repaint();
        this.list.setSelectedIndex(0);
    }
}

