/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.u_tokai.fb.w3.common.swing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import jp.ac.u_tokai.fb.w3.common.swing.SamplingRateSelectable;
import jp.ac.u_tokai.fb.w3.common.swing.event.SelectSamplingRateEvent;
import jp.ac.u_tokai.fb.w3.common.swing.event.SelectSamplingRateListener;

public class SamplingRateComboBox
extends JComboBox
implements SelectSamplingRateListener,
SamplingRateSelectable {
    protected int samplingRate = -1;
    private Vector listeners = new Vector();
    private String[] scale = new String[]{"1 / 1", "1 / 2", "1 / 3", "1 / 4", "1 / 5", "1 / 6"};

    public SamplingRateComboBox() {
        this.setModel(new DefaultComboBoxModel<String>(this.scale));
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int index = ((JComboBox)e.getSource()).getSelectedIndex();
                if (index >= 0 && index < SamplingRateComboBox.this.scale.length && index + 1 != SamplingRateComboBox.this.samplingRate) {
                    SamplingRateComboBox.this.fireSelectSamplingRateEvent(index + 1);
                }
            }
        });
    }

    public void addSelectSamplingRateListener(SelectSamplingRateListener listener) {
        this.listeners.addElement(listener);
    }

    public void removeSelectSamplingRateListener(SelectSamplingRateListener listener) {
        this.listeners.removeElement(listener);
    }

    public void fireSelectSamplingRateEvent(int samplingRate) {
        this.samplingRate = samplingRate;
        SelectSamplingRateEvent e = new SelectSamplingRateEvent(this, samplingRate);
        Enumeration enumeration = ((Vector)this.listeners.clone()).elements();
        while (enumeration.hasMoreElements()) {
            ((SelectSamplingRateListener)enumeration.nextElement()).samplingRateSelected(e);
        }
    }

    public void samplingRateSelected(SelectSamplingRateEvent e) {
        int index = e.getSamplingRate() - 1;
        if (index >= 0 && index < this.scale.length && e.getSamplingRate() != this.samplingRate) {
            this.setSelectedIndex(index);
        }
    }
}

