/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.bixpp.DataItem;
import common.swing.BixPanel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.util.Vector;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.ItemLabelAnchor;
import org.jfree.chart.renderer.StandardXYItemRenderer;
import org.jfree.data.XYSeries;
import org.jfree.data.XYSeriesCollection;
import org.jfree.ui.TextAnchor;

public class BixEnvironPanel
extends BixPanel {
    private JList list;
    private Vector dataItems;
    private XYSeries series;
    private XYSeriesCollection collection;
    private JFreeChart chart;
    private ValueAxis domainAxis;
    private ValueAxis rangeAxis;

    public BixEnvironPanel() {
        GridBagLayout gb = new GridBagLayout();
        this.setLayout(gb);
        this.dataItems = new Vector();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.gridheight = 0;
        gbc.anchor = 18;
        gbc.gridwidth = 0;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(10, 10, 10, 10);
        this.list = new JList();
        this.list.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                BixEnvironPanel.this.series.clear();
                if (BixEnvironPanel.this.dataItems.size() > 0 && BixEnvironPanel.this.list.getSelectedIndex() >= 0) {
                    DataItem item = (DataItem)BixEnvironPanel.this.dataItems.get(BixEnvironPanel.this.list.getSelectedIndex());
                    BixEnvironPanel.this.chart.setTitle(item.toString());
                    BixEnvironPanel.this.rangeAxis.setLabel(item.getUnit());
                    int i = 0;
                    while (i < BixEnvironPanel.this.bixpp.getRecordSize()) {
                        int j = 0;
                        while (j < BixEnvironPanel.this.bixpp.getRecord(i).size()) {
                            if (BixEnvironPanel.this.bixpp.getRecord(i).getItem(j).getIndex() == item.getIndex()) {
                                BixEnvironPanel.this.series.add((double)BixEnvironPanel.this.bixpp.getRecord(i).getDays(), BixEnvironPanel.this.bixpp.getRecord(i).getItem(j).getValue());
                                break;
                            }
                            ++j;
                        }
                        ++i;
                    }
                }
            }
        });
        JScrollPane scroll = new JScrollPane(this.list);
        scroll.setPreferredSize(new Dimension(200, -1));
        scroll.setMinimumSize(new Dimension(100, 100));
        this.series = new XYSeries("");
        XYSeriesCollection data = new XYSeriesCollection(this.series);
        this.chart = ChartFactory.createXYLineChart("", "\u751f\u7523\u7d4c\u904e\u65e5\u6570", "", data, PlotOrientation.VERTICAL, false, true, false);
        this.chart.setBackgroundPaint(Color.WHITE);
        this.chart.setBorderVisible(true);
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        this.chart.setRenderingHints(hints);
        XYPlot plot = (XYPlot)this.chart.getPlot();
        plot.setDomainGridlinesVisible(false);
        plot.setRangeGridlinesVisible(false);
        plot.setInsets(new Insets(30, 30, 30, 30));
        StandardXYItemRenderer renderer = (StandardXYItemRenderer)plot.getRenderer();
        renderer.setPlotShapes(true);
        renderer.setSeriesPaint(0, Color.BLUE);
        renderer.setItemLabelsVisible(true);
        renderer.setBaseItemLabelsVisible(new Boolean(true));
        renderer.setSeriesItemLabelsVisible(1, new Boolean(true));
        renderer.setItemLabelTextAnchor(TextAnchor.BOTTOM_CENTER);
        renderer.setItemLabelAnchor(ItemLabelAnchor.OUTSIDE12);
        this.domainAxis = plot.getDomainAxis();
        this.domainAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        this.rangeAxis = plot.getRangeAxis();
        this.rangeAxis.setAutoRange(true);
        this.rangeAxis.setVisible(true);
        NumberAxis axis = (NumberAxis)this.rangeAxis;
        axis.setAutoRangeIncludesZero(false);
        ChartPanel chartPanel = new ChartPanel(this.chart);
        chartPanel.setPreferredSize(new Dimension(500, 600));
        chartPanel.setMinimumSize(new Dimension(300, 300));
        chartPanel.setPopupMenu(null);
        JSplitPane splitPane = new JSplitPane();
        splitPane.setOneTouchExpandable(true);
        splitPane.setLeftComponent(chartPanel);
        splitPane.setRightComponent(scroll);
        splitPane.setResizeWeight(1.0);
        gb.setConstraints(splitPane, gbc);
        this.add(splitPane);
    }

    public void parse() {
        this.dataItems.clear();
        int i = 0;
        while (i < this.bixpp.getRecordingDefinitionSize()) {
            if (this.bixpp.getRecordItem(i).getKind().equals("DataItem")) {
                this.dataItems.add(this.bixpp.getRecordItem(i));
            }
            ++i;
        }
        this.domainAxis.setRange(0.0, this.bixpp.getLastRecord().getDays() + 1);
        this.list.setListData(this.dataItems);
        this.list.setSelectedIndex(0);
    }
}

