/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Iterator;
import java.util.Locale;
import org.jfree.chart.axis.AxisSpace;
import org.jfree.chart.axis.MarkerAxisBand;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.Tick;
import org.jfree.chart.axis.TickUnit;
import org.jfree.chart.axis.TickUnitSource;
import org.jfree.chart.axis.TickUnits;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.event.AxisChangeEvent;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.ValueAxisPlot;
import org.jfree.data.Range;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RefineryUtilities;
import org.jfree.util.ObjectUtils;

public class NumberAxis
extends ValueAxis
implements Cloneable,
Serializable {
    public static final boolean DEFAULT_AUTO_RANGE_INCLUDES_ZERO = true;
    public static final boolean DEFAULT_AUTO_RANGE_STICKY_ZERO = true;
    public static final NumberTickUnit DEFAULT_TICK_UNIT = new NumberTickUnit(1.0, new DecimalFormat("0"));
    public static final boolean DEFAULT_VERTICAL_TICK_LABELS = false;
    private boolean autoRangeIncludesZero = true;
    private boolean autoRangeStickyZero = true;
    private NumberTickUnit tickUnit = DEFAULT_TICK_UNIT;
    private NumberFormat numberFormatOverride = null;
    private MarkerAxisBand markerBand = null;

    public NumberAxis() {
        this(null);
    }

    public NumberAxis(String string) {
        super(string, NumberAxis.createStandardTickUnits());
    }

    public boolean autoRangeIncludesZero() {
        return this.autoRangeIncludesZero;
    }

    public void setAutoRangeIncludesZero(boolean bl) {
        if (this.autoRangeIncludesZero != bl) {
            this.autoRangeIncludesZero = bl;
            if (this.isAutoRange()) {
                this.autoAdjustRange();
            }
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public boolean autoRangeStickyZero() {
        return this.autoRangeStickyZero;
    }

    public void setAutoRangeStickyZero(boolean bl) {
        if (this.autoRangeStickyZero != bl) {
            this.autoRangeStickyZero = bl;
            if (this.isAutoRange()) {
                this.autoAdjustRange();
            }
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public NumberTickUnit getTickUnit() {
        return this.tickUnit;
    }

    public void setTickUnit(NumberTickUnit numberTickUnit) {
        this.setTickUnit(numberTickUnit, true, true);
    }

    public void setTickUnit(NumberTickUnit numberTickUnit, boolean bl, boolean bl2) {
        this.tickUnit = numberTickUnit;
        if (bl2) {
            this.setAutoTickUnitSelection(false, false);
        }
        if (bl) {
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public NumberFormat getNumberFormatOverride() {
        return this.numberFormatOverride;
    }

    public void setNumberFormatOverride(NumberFormat numberFormat) {
        this.numberFormatOverride = numberFormat;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public MarkerAxisBand getMarkerBand() {
        return this.markerBand;
    }

    public void setMarkerBand(MarkerAxisBand markerAxisBand) {
        this.markerBand = markerAxisBand;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    protected boolean isCompatiblePlot(Plot plot) {
        return plot instanceof ValueAxisPlot;
    }

    public void configure() {
        if (this.isAutoRange()) {
            this.autoAdjustRange();
        }
    }

    protected void autoAdjustRange() {
        Plot plot = this.getPlot();
        if (plot == null) {
            return;
        }
        if (plot instanceof ValueAxisPlot) {
            ValueAxisPlot valueAxisPlot = (ValueAxisPlot)((Object)plot);
            Range range = valueAxisPlot.getDataRange(this);
            if (range == null) {
                range = new Range(0.0, 1.0);
            }
            double d = range.getUpperBound();
            double d2 = range.getLowerBound();
            double d3 = d - d2;
            double d4 = this.getFixedAutoRange();
            if (d4 > 0.0) {
                d2 = d - d4;
            } else {
                double d5 = this.getAutoRangeMinimumSize();
                if (d3 < d5) {
                    double d6 = (d5 - d3) / 2.0;
                    d += d6;
                    d2 -= d6;
                }
                if (this.autoRangeIncludesZero()) {
                    if (this.autoRangeStickyZero()) {
                        d = d <= 0.0 ? 0.0 : (d += this.getUpperMargin() * d3);
                        d2 = d2 >= 0.0 ? 0.0 : (d2 -= this.getLowerMargin() * d3);
                    } else {
                        d = Math.max(0.0, d + this.getUpperMargin() * d3);
                        d2 = Math.min(0.0, d2 - this.getLowerMargin() * d3);
                    }
                } else if (this.autoRangeStickyZero()) {
                    d = d <= 0.0 ? Math.min(0.0, d + this.getUpperMargin() * d3) : (d += this.getUpperMargin() * d3);
                    d2 = d2 >= 0.0 ? Math.max(0.0, d2 - this.getLowerMargin() * d3) : (d2 -= this.getLowerMargin() * d3);
                } else {
                    d += this.getUpperMargin() * d3;
                    d2 -= this.getLowerMargin() * d3;
                }
            }
            this.setRange(new Range(d2, d), false, false);
        }
    }

    public double translateValueToJava2D(double d, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        Range range = this.getRange();
        double d2 = range.getLowerBound();
        double d3 = range.getUpperBound();
        double d4 = 0.0;
        double d5 = 0.0;
        if (RectangleEdge.isTopOrBottom(rectangleEdge)) {
            d4 = rectangle2D.getX();
            d5 = rectangle2D.getMaxX();
        } else if (RectangleEdge.isLeftOrRight(rectangleEdge)) {
            d5 = rectangle2D.getMinY();
            d4 = rectangle2D.getMaxY();
        }
        if (this.isInverted()) {
            return d5 - (d - d2) / (d3 - d2) * (d5 - d4);
        }
        return d4 + (d - d2) / (d3 - d2) * (d5 - d4);
    }

    public double translateJava2DtoValue(float f, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        Range range = this.getRange();
        double d = range.getLowerBound();
        double d2 = range.getUpperBound();
        double d3 = 0.0;
        double d4 = 0.0;
        if (RectangleEdge.isTopOrBottom(rectangleEdge)) {
            d3 = rectangle2D.getX();
            d4 = rectangle2D.getMaxX();
        } else if (RectangleEdge.isLeftOrRight(rectangleEdge)) {
            d3 = rectangle2D.getMaxY();
            d4 = rectangle2D.getY();
        }
        if (this.isInverted()) {
            return d2 - ((double)f - d3) / (d4 - d3) * (d2 - d);
        }
        return d + ((double)f - d3) / (d4 - d3) * (d2 - d);
    }

    public double calculateLowestVisibleTickValue() {
        double d = this.getTickUnit().getSize();
        double d2 = Math.ceil(this.getRange().getLowerBound() / d);
        return d2 * d;
    }

    public double calculateHighestVisibleTickValue() {
        double d = this.getTickUnit().getSize();
        double d2 = Math.floor(this.getRange().getUpperBound() / d);
        return d2 * d;
    }

    public int calculateVisibleTickCount() {
        double d = this.getTickUnit().getSize();
        Range range = this.getRange();
        return (int)(Math.floor(range.getUpperBound() / d) - Math.ceil(range.getLowerBound() / d) + 1.0);
    }

    public AxisSpace reserveSpace(Graphics2D graphics2D, Plot plot, Rectangle2D rectangle2D, RectangleEdge rectangleEdge, AxisSpace axisSpace) {
        if (axisSpace == null) {
            axisSpace = new AxisSpace();
        }
        this.reservedForAxisLabel = 0.0;
        this.reservedForTickLabels = 0.0;
        if (!this.isVisible()) {
            return axisSpace;
        }
        double d = this.getFixedDimension();
        if (d > 0.0) {
            axisSpace.ensureAtLeast(d, rectangleEdge);
        }
        double d2 = 0.0;
        double d3 = 0.0;
        if (this.isTickLabelsVisible()) {
            graphics2D.setFont(this.getTickLabelFont());
            this.refreshTicks(graphics2D, 0.0, rectangle2D, rectangle2D, rectangleEdge);
            Insets insets = this.getTickLabelInsets();
            if (RectangleEdge.isTopOrBottom(rectangleEdge)) {
                d2 = insets.top + insets.bottom;
                this.reservedForTickLabels = d2 += this.getMaxTickLabelHeight(graphics2D, rectangle2D, this.isVerticalTickLabels());
            } else if (RectangleEdge.isLeftOrRight(rectangleEdge)) {
                d3 = insets.left + insets.right;
                this.reservedForTickLabels = d3 += this.getMaxTickLabelWidth(graphics2D, rectangle2D);
            }
        }
        double d4 = 0.0;
        if (this.markerBand != null) {
            d4 = this.markerBand.getHeight(graphics2D);
        }
        Rectangle2D rectangle2D2 = this.getLabelEnclosure(graphics2D, rectangleEdge);
        double d5 = 0.0;
        double d6 = 0.0;
        if (RectangleEdge.isTopOrBottom(rectangleEdge)) {
            this.reservedForAxisLabel = d5 = rectangle2D2.getHeight();
            axisSpace.add(d5 + d2 + d4, rectangleEdge);
        } else if (RectangleEdge.isLeftOrRight(rectangleEdge)) {
            this.reservedForAxisLabel = d6 = rectangle2D2.getWidth();
            axisSpace.add(d6 + d3, rectangleEdge);
        }
        return axisSpace;
    }

    public double draw(Graphics2D graphics2D, double d, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleEdge rectangleEdge) {
        if (!this.isVisible()) {
            this.refreshTicks(graphics2D, d, rectangle2D, rectangle2D2, rectangleEdge);
            return 0.0;
        }
        double d2 = this.drawTickMarksAndLabels(graphics2D, d, rectangle2D, rectangle2D2, rectangleEdge);
        if (rectangleEdge == RectangleEdge.TOP || rectangleEdge == RectangleEdge.LEFT) {
            d -= d2;
        } else if (rectangleEdge == RectangleEdge.BOTTOM || rectangleEdge == RectangleEdge.RIGHT) {
            d += d2;
        }
        double d3 = this.drawLabel(this.getLabel(), graphics2D, d, rectangle2D, rectangle2D2, rectangleEdge);
        return d2 + d3;
    }

    protected double drawTickMarksAndLabels(Graphics2D graphics2D, double d, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleEdge rectangleEdge) {
        if (this.isAxisLineVisible()) {
            this.drawAxisLine(graphics2D, d, rectangle2D2, rectangleEdge);
        }
        double d2 = this.getTickMarkOutsideLength();
        double d3 = this.getTickMarkInsideLength();
        this.refreshTicks(graphics2D, d, rectangle2D, rectangle2D2, rectangleEdge);
        graphics2D.setFont(this.getTickLabelFont());
        Iterator iterator = this.getTicks().iterator();
        while (iterator.hasNext()) {
            Tick tick = (Tick)iterator.next();
            float f = (float)this.translateValueToJava2D(tick.getNumericalValue(), rectangle2D2, rectangleEdge);
            if (this.isTickLabelsVisible()) {
                graphics2D.setPaint(this.getTickLabelPaint());
                if (this.isVerticalTickLabels()) {
                    RefineryUtilities.drawRotatedString(tick.getText(), graphics2D, tick.getX(), tick.getY(), -1.5707963267948966);
                } else {
                    graphics2D.drawString(tick.getText(), tick.getX(), tick.getY());
                }
            }
            if (!this.isTickMarksVisible()) continue;
            Line2D.Double double_ = null;
            graphics2D.setStroke(this.getTickMarkStroke());
            graphics2D.setPaint(this.getTickMarkPaint());
            if (rectangleEdge == RectangleEdge.LEFT) {
                double_ = new Line2D.Double(d - d2, f, d + d3, f);
            } else if (rectangleEdge == RectangleEdge.RIGHT) {
                double_ = new Line2D.Double(d + d2, f, d - d3, f);
            } else if (rectangleEdge == RectangleEdge.TOP) {
                double_ = new Line2D.Double(f, d - d2, f, d + d3);
            } else if (rectangleEdge == RectangleEdge.BOTTOM) {
                double_ = new Line2D.Double(f, d + d2, f, d - d3);
            }
            graphics2D.draw(double_);
        }
        return this.reservedForTickLabels;
    }

    public static TickUnitSource createStandardTickUnits() {
        TickUnits tickUnits = new TickUnits();
        tickUnits.add(new NumberTickUnit(1.0E-7, new DecimalFormat("0.0000000")));
        tickUnits.add(new NumberTickUnit(1.0E-6, new DecimalFormat("0.000000")));
        tickUnits.add(new NumberTickUnit(1.0E-5, new DecimalFormat("0.00000")));
        tickUnits.add(new NumberTickUnit(1.0E-4, new DecimalFormat("0.0000")));
        tickUnits.add(new NumberTickUnit(0.001, new DecimalFormat("0.000")));
        tickUnits.add(new NumberTickUnit(0.01, new DecimalFormat("0.00")));
        tickUnits.add(new NumberTickUnit(0.1, new DecimalFormat("0.0")));
        tickUnits.add(new NumberTickUnit(1.0, new DecimalFormat("0")));
        tickUnits.add(new NumberTickUnit(10.0, new DecimalFormat("0")));
        tickUnits.add(new NumberTickUnit(100.0, new DecimalFormat("0")));
        tickUnits.add(new NumberTickUnit(1000.0, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(10000.0, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(100000.0, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(1000000.0, new DecimalFormat("#,###,##0")));
        tickUnits.add(new NumberTickUnit(1.0E7, new DecimalFormat("#,###,##0")));
        tickUnits.add(new NumberTickUnit(1.0E8, new DecimalFormat("#,###,##0")));
        tickUnits.add(new NumberTickUnit(1.0E9, new DecimalFormat("#,###,###,##0")));
        tickUnits.add(new NumberTickUnit(1.0E10, new DecimalFormat("#,###,###,##0")));
        tickUnits.add(new NumberTickUnit(1.0E11, new DecimalFormat("#,###,###,##0")));
        tickUnits.add(new NumberTickUnit(2.5E-7, new DecimalFormat("0.00000000")));
        tickUnits.add(new NumberTickUnit(2.5E-6, new DecimalFormat("0.0000000")));
        tickUnits.add(new NumberTickUnit(2.5E-5, new DecimalFormat("0.000000")));
        tickUnits.add(new NumberTickUnit(2.5E-4, new DecimalFormat("0.00000")));
        tickUnits.add(new NumberTickUnit(0.0025, new DecimalFormat("0.0000")));
        tickUnits.add(new NumberTickUnit(0.025, new DecimalFormat("0.000")));
        tickUnits.add(new NumberTickUnit(0.25, new DecimalFormat("0.00")));
        tickUnits.add(new NumberTickUnit(2.5, new DecimalFormat("0.0")));
        tickUnits.add(new NumberTickUnit(25.0, new DecimalFormat("0")));
        tickUnits.add(new NumberTickUnit(250.0, new DecimalFormat("0")));
        tickUnits.add(new NumberTickUnit(2500.0, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(25000.0, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(250000.0, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(2500000.0, new DecimalFormat("#,###,##0")));
        tickUnits.add(new NumberTickUnit(2.5E7, new DecimalFormat("#,###,##0")));
        tickUnits.add(new NumberTickUnit(2.5E8, new DecimalFormat("#,###,##0")));
        tickUnits.add(new NumberTickUnit(2.5E9, new DecimalFormat("#,###,###,##0")));
        tickUnits.add(new NumberTickUnit(2.5E10, new DecimalFormat("#,###,###,##0")));
        tickUnits.add(new NumberTickUnit(2.5E11, new DecimalFormat("#,###,###,##0")));
        tickUnits.add(new NumberTickUnit(5.0E-7, new DecimalFormat("0.0000000")));
        tickUnits.add(new NumberTickUnit(5.0E-6, new DecimalFormat("0.000000")));
        tickUnits.add(new NumberTickUnit(5.0E-5, new DecimalFormat("0.00000")));
        tickUnits.add(new NumberTickUnit(5.0E-4, new DecimalFormat("0.0000")));
        tickUnits.add(new NumberTickUnit(0.005, new DecimalFormat("0.000")));
        tickUnits.add(new NumberTickUnit(0.05, new DecimalFormat("0.00")));
        tickUnits.add(new NumberTickUnit(0.5, new DecimalFormat("0.0")));
        tickUnits.add(new NumberTickUnit(5.0, new DecimalFormat("0")));
        tickUnits.add(new NumberTickUnit(50.0, new DecimalFormat("0")));
        tickUnits.add(new NumberTickUnit(500.0, new DecimalFormat("0")));
        tickUnits.add(new NumberTickUnit(5000.0, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(50000.0, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(500000.0, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(5000000.0, new DecimalFormat("#,###,##0")));
        tickUnits.add(new NumberTickUnit(5.0E7, new DecimalFormat("#,###,##0")));
        tickUnits.add(new NumberTickUnit(5.0E8, new DecimalFormat("#,###,##0")));
        tickUnits.add(new NumberTickUnit(5.0E9, new DecimalFormat("#,###,###,##0")));
        tickUnits.add(new NumberTickUnit(5.0E10, new DecimalFormat("#,###,###,##0")));
        tickUnits.add(new NumberTickUnit(5.0E11, new DecimalFormat("#,###,###,##0")));
        return tickUnits;
    }

    public static TickUnitSource createIntegerTickUnits() {
        TickUnits tickUnits = new TickUnits();
        tickUnits.add(new NumberTickUnit(1.0, new DecimalFormat("0")));
        tickUnits.add(new NumberTickUnit(2.0, new DecimalFormat("0")));
        tickUnits.add(new NumberTickUnit(5.0, new DecimalFormat("0")));
        tickUnits.add(new NumberTickUnit(10.0, new DecimalFormat("0")));
        tickUnits.add(new NumberTickUnit(20.0, new DecimalFormat("0")));
        tickUnits.add(new NumberTickUnit(50.0, new DecimalFormat("0")));
        tickUnits.add(new NumberTickUnit(100.0, new DecimalFormat("0")));
        tickUnits.add(new NumberTickUnit(200.0, new DecimalFormat("0")));
        tickUnits.add(new NumberTickUnit(500.0, new DecimalFormat("0")));
        tickUnits.add(new NumberTickUnit(1000.0, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(2000.0, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(5000.0, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(10000.0, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(20000.0, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(50000.0, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(100000.0, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(200000.0, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(500000.0, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(1000000.0, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(2000000.0, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(5000000.0, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(1.0E7, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(2.0E7, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(5.0E7, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(1.0E8, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(2.0E8, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(5.0E8, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(1.0E9, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(2.0E9, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(5.0E9, new DecimalFormat("#,##0")));
        tickUnits.add(new NumberTickUnit(1.0E10, new DecimalFormat("#,##0")));
        return tickUnits;
    }

    public static TickUnitSource createStandardTickUnits(Locale locale) {
        TickUnits tickUnits = new TickUnits();
        NumberFormat numberFormat = NumberFormat.getNumberInstance(locale);
        tickUnits.add(new NumberTickUnit(1.0E-7, numberFormat));
        tickUnits.add(new NumberTickUnit(1.0E-6, numberFormat));
        tickUnits.add(new NumberTickUnit(1.0E-5, numberFormat));
        tickUnits.add(new NumberTickUnit(1.0E-4, numberFormat));
        tickUnits.add(new NumberTickUnit(0.001, numberFormat));
        tickUnits.add(new NumberTickUnit(0.01, numberFormat));
        tickUnits.add(new NumberTickUnit(0.1, numberFormat));
        tickUnits.add(new NumberTickUnit(1.0, numberFormat));
        tickUnits.add(new NumberTickUnit(10.0, numberFormat));
        tickUnits.add(new NumberTickUnit(100.0, numberFormat));
        tickUnits.add(new NumberTickUnit(1000.0, numberFormat));
        tickUnits.add(new NumberTickUnit(10000.0, numberFormat));
        tickUnits.add(new NumberTickUnit(100000.0, numberFormat));
        tickUnits.add(new NumberTickUnit(1000000.0, numberFormat));
        tickUnits.add(new NumberTickUnit(1.0E7, numberFormat));
        tickUnits.add(new NumberTickUnit(1.0E8, numberFormat));
        tickUnits.add(new NumberTickUnit(1.0E9, numberFormat));
        tickUnits.add(new NumberTickUnit(1.0E10, numberFormat));
        tickUnits.add(new NumberTickUnit(2.5E-7, numberFormat));
        tickUnits.add(new NumberTickUnit(2.5E-6, numberFormat));
        tickUnits.add(new NumberTickUnit(2.5E-5, numberFormat));
        tickUnits.add(new NumberTickUnit(2.5E-4, numberFormat));
        tickUnits.add(new NumberTickUnit(0.0025, numberFormat));
        tickUnits.add(new NumberTickUnit(0.025, numberFormat));
        tickUnits.add(new NumberTickUnit(0.25, numberFormat));
        tickUnits.add(new NumberTickUnit(2.5, numberFormat));
        tickUnits.add(new NumberTickUnit(25.0, numberFormat));
        tickUnits.add(new NumberTickUnit(250.0, numberFormat));
        tickUnits.add(new NumberTickUnit(2500.0, numberFormat));
        tickUnits.add(new NumberTickUnit(25000.0, numberFormat));
        tickUnits.add(new NumberTickUnit(250000.0, numberFormat));
        tickUnits.add(new NumberTickUnit(2500000.0, numberFormat));
        tickUnits.add(new NumberTickUnit(2.5E7, numberFormat));
        tickUnits.add(new NumberTickUnit(2.5E8, numberFormat));
        tickUnits.add(new NumberTickUnit(2.5E9, numberFormat));
        tickUnits.add(new NumberTickUnit(2.5E10, numberFormat));
        tickUnits.add(new NumberTickUnit(5.0E-7, numberFormat));
        tickUnits.add(new NumberTickUnit(5.0E-6, numberFormat));
        tickUnits.add(new NumberTickUnit(5.0E-5, numberFormat));
        tickUnits.add(new NumberTickUnit(5.0E-4, numberFormat));
        tickUnits.add(new NumberTickUnit(0.005, numberFormat));
        tickUnits.add(new NumberTickUnit(0.05, numberFormat));
        tickUnits.add(new NumberTickUnit(0.5, numberFormat));
        tickUnits.add(new NumberTickUnit(5.0, numberFormat));
        tickUnits.add(new NumberTickUnit(50.0, numberFormat));
        tickUnits.add(new NumberTickUnit(500.0, numberFormat));
        tickUnits.add(new NumberTickUnit(5000.0, numberFormat));
        tickUnits.add(new NumberTickUnit(50000.0, numberFormat));
        tickUnits.add(new NumberTickUnit(500000.0, numberFormat));
        tickUnits.add(new NumberTickUnit(5000000.0, numberFormat));
        tickUnits.add(new NumberTickUnit(5.0E7, numberFormat));
        tickUnits.add(new NumberTickUnit(5.0E8, numberFormat));
        tickUnits.add(new NumberTickUnit(5.0E9, numberFormat));
        tickUnits.add(new NumberTickUnit(5.0E10, numberFormat));
        return tickUnits;
    }

    public static TickUnitSource createIntegerTickUnits(Locale locale) {
        TickUnits tickUnits = new TickUnits();
        NumberFormat numberFormat = NumberFormat.getNumberInstance(locale);
        tickUnits.add(new NumberTickUnit(1.0, numberFormat));
        tickUnits.add(new NumberTickUnit(2.0, numberFormat));
        tickUnits.add(new NumberTickUnit(5.0, numberFormat));
        tickUnits.add(new NumberTickUnit(10.0, numberFormat));
        tickUnits.add(new NumberTickUnit(20.0, numberFormat));
        tickUnits.add(new NumberTickUnit(50.0, numberFormat));
        tickUnits.add(new NumberTickUnit(100.0, numberFormat));
        tickUnits.add(new NumberTickUnit(200.0, numberFormat));
        tickUnits.add(new NumberTickUnit(500.0, numberFormat));
        tickUnits.add(new NumberTickUnit(1000.0, numberFormat));
        tickUnits.add(new NumberTickUnit(2000.0, numberFormat));
        tickUnits.add(new NumberTickUnit(5000.0, numberFormat));
        tickUnits.add(new NumberTickUnit(10000.0, numberFormat));
        tickUnits.add(new NumberTickUnit(20000.0, numberFormat));
        tickUnits.add(new NumberTickUnit(50000.0, numberFormat));
        tickUnits.add(new NumberTickUnit(100000.0, numberFormat));
        tickUnits.add(new NumberTickUnit(200000.0, numberFormat));
        tickUnits.add(new NumberTickUnit(500000.0, numberFormat));
        tickUnits.add(new NumberTickUnit(1000000.0, numberFormat));
        tickUnits.add(new NumberTickUnit(2000000.0, numberFormat));
        tickUnits.add(new NumberTickUnit(5000000.0, numberFormat));
        tickUnits.add(new NumberTickUnit(1.0E7, numberFormat));
        tickUnits.add(new NumberTickUnit(2.0E7, numberFormat));
        tickUnits.add(new NumberTickUnit(5.0E7, numberFormat));
        tickUnits.add(new NumberTickUnit(1.0E8, numberFormat));
        tickUnits.add(new NumberTickUnit(2.0E8, numberFormat));
        tickUnits.add(new NumberTickUnit(5.0E8, numberFormat));
        tickUnits.add(new NumberTickUnit(1.0E9, numberFormat));
        tickUnits.add(new NumberTickUnit(2.0E9, numberFormat));
        tickUnits.add(new NumberTickUnit(5.0E9, numberFormat));
        tickUnits.add(new NumberTickUnit(1.0E10, numberFormat));
        return tickUnits;
    }

    protected double getMaxTickLabelHeight(Graphics2D graphics2D, Rectangle2D rectangle2D, boolean bl) {
        Font font = this.getTickLabelFont();
        graphics2D.setFont(font);
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        double d = 0.0;
        if (bl) {
            Iterator iterator = this.getTicks().iterator();
            while (iterator.hasNext()) {
                Tick tick = (Tick)iterator.next();
                Rectangle2D rectangle2D2 = font.getStringBounds(tick.getText(), fontRenderContext);
                if (!(rectangle2D2.getWidth() > d)) continue;
                d = rectangle2D2.getWidth();
            }
        } else {
            LineMetrics lineMetrics = font.getLineMetrics("Sample", fontRenderContext);
            d = lineMetrics.getHeight();
        }
        return d;
    }

    protected double estimateMaximumTickLabelHeight(Graphics2D graphics2D) {
        Insets insets = this.getTickLabelInsets();
        double d = insets.top + insets.bottom;
        Font font = this.getTickLabelFont();
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        return d += (double)font.getLineMetrics("123", fontRenderContext).getHeight();
    }

    protected double estimateMaximumTickLabelWidth(Graphics2D graphics2D, TickUnit tickUnit) {
        Insets insets = this.getTickLabelInsets();
        double d = insets.left + insets.right;
        Font font = this.getTickLabelFont();
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        if (this.isVerticalTickLabels()) {
            d += font.getStringBounds("0", fontRenderContext).getHeight();
        } else {
            Range range = this.getRange();
            double d2 = range.getLowerBound();
            double d3 = range.getUpperBound();
            String string = tickUnit.valueToString(d2);
            String string2 = tickUnit.valueToString(d3);
            double d4 = font.getStringBounds(string, fontRenderContext).getWidth();
            double d5 = font.getStringBounds(string2, fontRenderContext).getWidth();
            d += Math.max(d4, d5);
        }
        return d;
    }

    protected void selectAutoTickUnit(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleEdge rectangleEdge) {
        if (RectangleEdge.isTopOrBottom(rectangleEdge)) {
            this.selectHorizontalAutoTickUnit(graphics2D, rectangle2D, rectangle2D2, rectangleEdge);
        } else if (RectangleEdge.isLeftOrRight(rectangleEdge)) {
            this.selectVerticalAutoTickUnit(graphics2D, rectangle2D, rectangle2D2, rectangleEdge);
        }
    }

    protected void selectHorizontalAutoTickUnit(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleEdge rectangleEdge) {
        double d = this.translateValueToJava2D(0.0, rectangle2D2, rectangleEdge);
        double d2 = this.estimateMaximumTickLabelWidth(graphics2D, this.getTickUnit());
        TickUnitSource tickUnitSource = this.getStandardTickUnits();
        TickUnit tickUnit = tickUnitSource.getCeilingTickUnit(this.getTickUnit());
        double d3 = this.translateValueToJava2D(tickUnit.getSize(), rectangle2D2, rectangleEdge);
        double d4 = Math.abs(d3 - d);
        double d5 = d2 / d4 * tickUnit.getSize();
        NumberTickUnit numberTickUnit = (NumberTickUnit)tickUnitSource.getCeilingTickUnit(d5);
        double d6 = this.translateValueToJava2D(numberTickUnit.getSize(), rectangle2D2, rectangleEdge);
        double d7 = Math.abs(d6 - d);
        d2 = this.estimateMaximumTickLabelWidth(graphics2D, numberTickUnit);
        if (d2 > d7) {
            numberTickUnit = (NumberTickUnit)tickUnitSource.getLargerTickUnit(numberTickUnit);
        }
        this.setTickUnit(numberTickUnit, false, false);
    }

    protected void selectVerticalAutoTickUnit(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleEdge rectangleEdge) {
        double d = this.translateValueToJava2D(0.0, rectangle2D2, rectangleEdge);
        double d2 = this.estimateMaximumTickLabelHeight(graphics2D);
        TickUnitSource tickUnitSource = this.getStandardTickUnits();
        TickUnit tickUnit = tickUnitSource.getCeilingTickUnit(this.getTickUnit());
        double d3 = this.translateValueToJava2D(tickUnit.getSize(), rectangle2D2, rectangleEdge);
        double d4 = Math.abs(d3 - d);
        double d5 = d2 / d4 * tickUnit.getSize();
        NumberTickUnit numberTickUnit = (NumberTickUnit)tickUnitSource.getCeilingTickUnit(d5);
        double d6 = this.translateValueToJava2D(numberTickUnit.getSize(), rectangle2D2, rectangleEdge);
        double d7 = Math.abs(d6 - d);
        d2 = this.estimateMaximumTickLabelHeight(graphics2D);
        if (d2 > d7) {
            numberTickUnit = (NumberTickUnit)tickUnitSource.getLargerTickUnit(numberTickUnit);
        }
        this.setTickUnit(numberTickUnit, false, false);
    }

    public void refreshTicks(Graphics2D graphics2D, double d, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleEdge rectangleEdge) {
        if (RectangleEdge.isTopOrBottom(rectangleEdge)) {
            this.refreshHorizontalTicks(graphics2D, d, rectangle2D, rectangle2D2, rectangleEdge);
        } else if (RectangleEdge.isLeftOrRight(rectangleEdge)) {
            this.refreshVerticalTicks(graphics2D, d, rectangle2D, rectangle2D2, rectangleEdge);
        }
    }

    protected void refreshHorizontalTicks(Graphics2D graphics2D, double d, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleEdge rectangleEdge) {
        this.getTicks().clear();
        Font font = this.getTickLabelFont();
        graphics2D.setFont(font);
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        if (this.isAutoTickUnitSelection()) {
            this.selectAutoTickUnit(graphics2D, rectangle2D, rectangle2D2, rectangleEdge);
        }
        double d2 = this.getTickUnit().getSize();
        int n = this.calculateVisibleTickCount();
        double d3 = this.calculateLowestVisibleTickValue();
        if (n <= 500) {
            int n2 = 0;
            while (n2 < n) {
                double d4 = d3 + (double)n2 * d2;
                double d5 = this.translateValueToJava2D(d4, rectangle2D2, rectangleEdge);
                NumberFormat numberFormat = this.getNumberFormatOverride();
                String string = numberFormat != null ? numberFormat.format(d4) : this.getTickUnit().valueToString(d4);
                Rectangle2D rectangle2D3 = font.getStringBounds(string, fontRenderContext);
                LineMetrics lineMetrics = font.getLineMetrics(string, fontRenderContext);
                float f = 0.0f;
                float f2 = 0.0f;
                Insets insets = this.getTickLabelInsets();
                if (this.isVerticalTickLabels()) {
                    f = (float)(d5 + rectangle2D3.getHeight() / 2.0);
                    f2 = rectangleEdge == RectangleEdge.TOP ? (float)(d - (double)insets.bottom - rectangle2D3.getWidth()) : (float)(d + (double)insets.top + rectangle2D3.getWidth());
                } else {
                    f = (float)(d5 - rectangle2D3.getWidth() / 2.0);
                    f2 = rectangleEdge == RectangleEdge.TOP ? (float)(d - (double)insets.bottom - (double)lineMetrics.getLeading() - (double)lineMetrics.getDescent()) : (float)(d + (double)insets.top + rectangle2D3.getHeight());
                }
                Tick tick = new Tick(new Double(d4), string, f, f2);
                this.getTicks().add(tick);
                ++n2;
            }
        }
    }

    protected void refreshVerticalTicks(Graphics2D graphics2D, double d, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleEdge rectangleEdge) {
        this.getTicks().clear();
        Font font = this.getTickLabelFont();
        graphics2D.setFont(font);
        if (this.isAutoTickUnitSelection()) {
            this.selectAutoTickUnit(graphics2D, rectangle2D, rectangle2D2, rectangleEdge);
        }
        double d2 = this.getTickUnit().getSize();
        int n = this.calculateVisibleTickCount();
        double d3 = this.calculateLowestVisibleTickValue();
        if (n <= 500) {
            int n2 = 0;
            while (n2 < n) {
                double d4 = d3 + (double)n2 * d2;
                double d5 = this.translateValueToJava2D(d4, rectangle2D2, rectangleEdge);
                NumberFormat numberFormat = this.getNumberFormatOverride();
                String string = numberFormat != null ? numberFormat.format(d4) : this.getTickUnit().valueToString(d4);
                FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
                Rectangle2D rectangle2D3 = font.getStringBounds(string, fontRenderContext);
                LineMetrics lineMetrics = font.getLineMetrics(string, fontRenderContext);
                float f = rectangleEdge == RectangleEdge.LEFT ? (float)(d - rectangle2D3.getWidth() - (double)this.getTickLabelInsets().right) : (float)(d + (double)this.getTickLabelInsets().left);
                float f2 = (float)(d5 + (double)(lineMetrics.getAscent() / 2.0f));
                Tick tick = new Tick(new Double(d4), string, f, f2);
                this.getTicks().add(tick);
                ++n2;
            }
        }
    }

    public Object clone() throws CloneNotSupportedException {
        NumberAxis numberAxis = (NumberAxis)super.clone();
        if (this.numberFormatOverride != null) {
            numberAxis.numberFormatOverride = (NumberFormat)this.numberFormatOverride.clone();
        }
        return numberAxis;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof NumberAxis && super.equals(object)) {
            NumberAxis numberAxis = (NumberAxis)object;
            boolean bl = this.autoRangeIncludesZero == numberAxis.autoRangeIncludesZero;
            boolean bl2 = this.autoRangeStickyZero == numberAxis.autoRangeStickyZero;
            boolean bl3 = ObjectUtils.equal(this.tickUnit, numberAxis.tickUnit);
            boolean bl4 = ObjectUtils.equal(this.numberFormatOverride, numberAxis.numberFormatOverride);
            return bl && bl2 && bl3 && bl4;
        }
        return false;
    }
}

