/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot;

import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.axis.AxisSpace;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.event.PlotChangeEvent;
import org.jfree.chart.event.PlotChangeListener;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.XYItemRenderer;
import org.jfree.data.Range;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.ObjectUtils;
import org.jfree.util.PublicCloneable;

public class CombinedDomainXYPlot
extends XYPlot
implements Cloneable,
PublicCloneable,
Serializable,
PlotChangeListener {
    private List subplots = new ArrayList();
    private int totalWeight = 0;
    private double gap = 5.0;
    private transient Rectangle2D[] subplotAreas;

    public CombinedDomainXYPlot() {
        this(new NumberAxis());
    }

    public CombinedDomainXYPlot(ValueAxis valueAxis) {
        super(null, valueAxis, null, null);
    }

    public String getPlotType() {
        return "Combined_Domain_XYPlot";
    }

    public void setOrientation(PlotOrientation plotOrientation) {
        super.setOrientation(plotOrientation);
        Iterator iterator = this.subplots.iterator();
        while (iterator.hasNext()) {
            XYPlot xYPlot = (XYPlot)iterator.next();
            xYPlot.setOrientation(plotOrientation);
        }
    }

    public Range getDataRange(ValueAxis valueAxis) {
        Range range = null;
        if (this.subplots != null) {
            Iterator iterator = this.subplots.iterator();
            while (iterator.hasNext()) {
                XYPlot xYPlot = (XYPlot)iterator.next();
                range = Range.combine(range, xYPlot.getDataRange(valueAxis));
            }
        }
        return range;
    }

    public double getGap() {
        return this.gap;
    }

    public void setGap(double d) {
        this.gap = d;
    }

    public void add(XYPlot xYPlot) {
        this.add(xYPlot, 1);
    }

    public void add(XYPlot xYPlot, int n) {
        if (n <= 0) {
            String string = "SharedDomainXYPlot.add(...): weight must be positive.";
            throw new IllegalArgumentException(string);
        }
        xYPlot.setParent(this);
        xYPlot.setWeight(n);
        xYPlot.setInsets(new Insets(0, 0, 0, 0));
        xYPlot.setDomainAxis(null);
        xYPlot.addChangeListener(this);
        this.subplots.add(xYPlot);
        this.totalWeight += n;
        ValueAxis valueAxis = this.getDomainAxis();
        if (valueAxis != null) {
            valueAxis.configure();
        }
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void remove(XYPlot xYPlot) {
        this.subplots.remove(xYPlot);
        xYPlot.setParent(null);
        xYPlot.removeChangeListener(this);
        this.totalWeight -= xYPlot.getWeight();
        ValueAxis valueAxis = this.getDomainAxis();
        if (valueAxis != null) {
            valueAxis.configure();
        }
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public List getSubplots() {
        return Collections.unmodifiableList(this.subplots);
    }

    protected AxisSpace calculateAxisSpace(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        Cloneable cloneable;
        AxisSpace axisSpace = new AxisSpace();
        PlotOrientation plotOrientation = this.getOrientation();
        AxisSpace axisSpace2 = this.getFixedDomainAxisSpace();
        if (axisSpace2 != null) {
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                axisSpace.setLeft(axisSpace2.getLeft());
                axisSpace.setRight(axisSpace2.getRight());
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                axisSpace.setTop(axisSpace2.getTop());
                axisSpace.setBottom(axisSpace2.getBottom());
            }
        } else {
            cloneable = this.getDomainAxis();
            RectangleEdge rectangleEdge = Plot.resolveDomainAxisLocation(this.getDomainAxisLocation(), plotOrientation);
            if (cloneable != null) {
                axisSpace = ((Axis)cloneable).reserveSpace(graphics2D, this, rectangle2D, rectangleEdge, axisSpace);
            }
        }
        cloneable = axisSpace.shrink(rectangle2D, null);
        int n = this.subplots.size();
        this.subplotAreas = new Rectangle2D[n];
        double d = ((RectangularShape)cloneable).getX();
        double d2 = ((RectangularShape)cloneable).getY();
        double d3 = 0.0;
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            d3 = ((RectangularShape)cloneable).getWidth() - this.gap * (double)(n - 1);
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            d3 = ((RectangularShape)cloneable).getHeight() - this.gap * (double)(n - 1);
        }
        int n2 = 0;
        while (n2 < n) {
            XYPlot xYPlot = (XYPlot)this.subplots.get(n2);
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                double d4 = d3 * (double)xYPlot.getWeight() / (double)this.totalWeight;
                this.subplotAreas[n2] = new Rectangle2D.Double(d, d2, d4, ((RectangularShape)cloneable).getHeight());
                d = d + d4 + this.gap;
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                double d5 = d3 * (double)xYPlot.getWeight() / (double)this.totalWeight;
                this.subplotAreas[n2] = new Rectangle2D.Double(d, d2, ((RectangularShape)cloneable).getWidth(), d5);
                d2 = d2 + d5 + this.gap;
            }
            AxisSpace axisSpace3 = xYPlot.calculateRangeAxisSpace(graphics2D, this.subplotAreas[n2], null);
            axisSpace.ensureAtLeast(axisSpace3);
            ++n2;
        }
        return axisSpace;
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo) {
        Object object;
        Cloneable cloneable;
        Insets insets;
        if (plotRenderingInfo != null) {
            plotRenderingInfo.setPlotArea(rectangle2D);
        }
        if ((insets = this.getInsets()) != null) {
            rectangle2D.setRect(rectangle2D.getX() + (double)insets.left, rectangle2D.getY() + (double)insets.top, rectangle2D.getWidth() - (double)insets.left - (double)insets.right, rectangle2D.getHeight() - (double)insets.top - (double)insets.bottom);
        }
        PlotOrientation plotOrientation = this.getOrientation();
        AxisSpace axisSpace = this.calculateAxisSpace(graphics2D, rectangle2D);
        Rectangle2D rectangle2D2 = axisSpace.shrink(rectangle2D, null);
        this.setFixedRangeAxisSpaceForSubplots(axisSpace);
        int n = 0;
        while (n < this.subplots.size()) {
            cloneable = (XYPlot)this.subplots.get(n);
            object = null;
            if (plotRenderingInfo != null) {
                object = new PlotRenderingInfo(plotRenderingInfo.getOwner());
                plotRenderingInfo.addSubplotInfo((PlotRenderingInfo)object);
            }
            ((XYPlot)cloneable).draw(graphics2D, this.subplotAreas[n], (PlotRenderingInfo)object);
            ++n;
        }
        if (plotRenderingInfo != null) {
            plotRenderingInfo.setDataArea(rectangle2D2);
        }
        cloneable = this.getDomainAxis();
        object = this.getDomainAxisEdge();
        double d = RectangleEdge.coordinate(rectangle2D2, (RectangleEdge)object);
        ((Axis)cloneable).draw(graphics2D, d, rectangle2D, rectangle2D2, (RectangleEdge)object);
    }

    public LegendItemCollection getLegendItems() {
        LegendItemCollection legendItemCollection = new LegendItemCollection();
        if (this.subplots != null) {
            Iterator iterator = this.subplots.iterator();
            while (iterator.hasNext()) {
                XYPlot xYPlot = (XYPlot)iterator.next();
                LegendItemCollection legendItemCollection2 = xYPlot.getLegendItems();
                legendItemCollection.addAll(legendItemCollection2);
            }
        }
        return legendItemCollection;
    }

    public void zoom(double d) {
    }

    public void setRenderer(XYItemRenderer xYItemRenderer) {
        super.setRenderer(xYItemRenderer);
        Iterator iterator = this.subplots.iterator();
        while (iterator.hasNext()) {
            XYPlot xYPlot = (XYPlot)iterator.next();
            xYPlot.setRenderer(xYItemRenderer);
        }
    }

    protected void setFixedRangeAxisSpaceForSubplots(AxisSpace axisSpace) {
        Iterator iterator = this.subplots.iterator();
        while (iterator.hasNext()) {
            XYPlot xYPlot = (XYPlot)iterator.next();
            xYPlot.setFixedRangeAxisSpace(axisSpace);
        }
    }

    public void handleClick(int n, int n2, PlotRenderingInfo plotRenderingInfo) {
        Rectangle2D rectangle2D = plotRenderingInfo.getDataArea();
        if (rectangle2D.contains(n, n2)) {
            int n3 = 0;
            while (n3 < this.subplots.size()) {
                XYPlot xYPlot = (XYPlot)this.subplots.get(n3);
                PlotRenderingInfo plotRenderingInfo2 = plotRenderingInfo.getSubplotInfo(n3);
                xYPlot.handleClick(n, n2, plotRenderingInfo2);
                ++n3;
            }
        }
    }

    public void plotChanged(PlotChangeEvent plotChangeEvent) {
        this.notifyListeners(plotChangeEvent);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof CombinedDomainXYPlot) {
            CombinedDomainXYPlot combinedDomainXYPlot = (CombinedDomainXYPlot)object;
            if (super.equals(object)) {
                boolean bl = ObjectUtils.equal(this.subplots, combinedDomainXYPlot.subplots);
                boolean bl2 = this.totalWeight == combinedDomainXYPlot.totalWeight;
                boolean bl3 = this.gap == combinedDomainXYPlot.gap;
                return bl && bl2 && bl3;
            }
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        Cloneable cloneable;
        CombinedDomainXYPlot combinedDomainXYPlot = (CombinedDomainXYPlot)super.clone();
        combinedDomainXYPlot.subplots = ObjectUtils.clone(this.subplots);
        Iterator iterator = combinedDomainXYPlot.subplots.iterator();
        while (iterator.hasNext()) {
            cloneable = (Plot)iterator.next();
            ((Plot)cloneable).setParent(combinedDomainXYPlot);
        }
        cloneable = combinedDomainXYPlot.getDomainAxis();
        if (cloneable != null) {
            ((Axis)cloneable).configure();
        }
        return combinedDomainXYPlot;
    }
}

