/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.renderer.AbstractCategoryItemRenderer;
import org.jfree.chart.renderer.Outlier;
import org.jfree.chart.renderer.OutlierList;
import org.jfree.chart.renderer.OutlierListCollection;
import org.jfree.data.CategoryDataset;
import org.jfree.data.statistics.BoxAndWhiskerCategoryDataset;
import org.jfree.data.statistics.DefaultBoxAndWhiskerCategoryDataset;
import org.jfree.ui.RectangleEdge;

public class BoxAndWhiskerRenderer
extends AbstractCategoryItemRenderer {
    private Paint artifactPaint = Color.black;
    private double boxWidth = 0.0;
    private double itemMargin = 0.2;

    public Paint getArtifactPaint() {
        return this.artifactPaint;
    }

    public void setArtifactPaint(Paint paint) {
        this.artifactPaint = paint;
    }

    public double getBoxWidth() {
        return this.boxWidth;
    }

    public void setBoxWidth(double d) {
        this.boxWidth = d;
    }

    public double getItemMargin() {
        return this.itemMargin;
    }

    public void setItemMargin(double d) {
        this.itemMargin = d;
    }

    public void initialise(Graphics2D graphics2D, Rectangle2D rectangle2D, CategoryPlot categoryPlot, Integer n, PlotRenderingInfo plotRenderingInfo) {
        super.initialise(graphics2D, rectangle2D, categoryPlot, n, plotRenderingInfo);
        ValueAxis valueAxis = this.getRangeAxis(categoryPlot, n);
        CategoryAxis categoryAxis = this.getDomainAxis(categoryPlot, n);
        CategoryDataset categoryDataset = this.getDataset(categoryPlot, n);
        if (categoryDataset != null) {
            int n2 = categoryDataset.getColumnCount();
            int n3 = categoryDataset.getRowCount();
            double d = 0.0;
            PlotOrientation plotOrientation = categoryPlot.getOrientation();
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                d = rectangle2D.getHeight();
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                d = rectangle2D.getWidth();
            }
            double d2 = 0.0;
            double d3 = 0.0;
            if (n2 > 1) {
                d2 = categoryAxis.getCategoryMargin();
            }
            if (n3 > 1) {
                d3 = this.getItemMargin();
            }
            double d4 = d * (1.0 - categoryAxis.getLowerMargin() - categoryAxis.getUpperMargin() - d2 - d3);
            if (n3 * n2 > 0) {
                this.setBoxWidth(d4 / (double)(categoryDataset.getColumnCount() * categoryDataset.getRowCount()));
            } else {
                this.setBoxWidth(d4);
            }
        }
    }

    public void drawItem(Graphics2D graphics2D, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, int n2) {
        if (!(categoryDataset instanceof BoxAndWhiskerCategoryDataset)) {
            throw new IllegalArgumentException("BoxAndWhiskerRenderer.drawItem() : the data should be of type BoxAndWhiskerCategoryDataset only.");
        }
        PlotOrientation plotOrientation = categoryPlot.getOrientation();
        if (plotOrientation != PlotOrientation.HORIZONTAL && plotOrientation == PlotOrientation.VERTICAL) {
            this.drawVerticalItem(graphics2D, rectangle2D, categoryPlot, categoryAxis, valueAxis, categoryDataset, n, n2);
        }
    }

    public void drawVerticalItem(Graphics2D graphics2D, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, int n2) {
        Object object;
        Serializable serializable;
        Cloneable cloneable;
        double d;
        double d2;
        double d3;
        double d4;
        DefaultBoxAndWhiskerCategoryDataset defaultBoxAndWhiskerCategoryDataset = (DefaultBoxAndWhiskerCategoryDataset)categoryDataset;
        double d5 = categoryAxis.getCategoryStart(n2, this.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge());
        int n3 = this.getRowCount();
        int n4 = this.getColumnCount();
        if (n3 > 1) {
            d4 = rectangle2D.getWidth() * this.getItemMargin() / (double)(n4 * (n3 - 1));
            d5 += (double)n * (this.getBoxWidth() + d4);
        } else {
            d5 += (double)n * this.getBoxWidth();
        }
        d4 = 0.0;
        Paint paint = this.getItemPaint(n, n2);
        if (paint != null) {
            graphics2D.setPaint(paint);
        }
        Stroke stroke = this.getItemStroke(n, n2);
        graphics2D.setStroke(stroke);
        double d6 = 0.0;
        RectangleEdge rectangleEdge = categoryPlot.getRangeAxisEdge();
        Number number = defaultBoxAndWhiskerCategoryDataset.getQ1Value(n, n2);
        Number number2 = defaultBoxAndWhiskerCategoryDataset.getQ3Value(n, n2);
        Number number3 = defaultBoxAndWhiskerCategoryDataset.getMaxRegularValue(n, n2);
        Number number4 = defaultBoxAndWhiskerCategoryDataset.getMinRegularValue(n, n2);
        if (number != null && number2 != null && number3 != null && number4 != null) {
            double d7 = valueAxis.translateValueToJava2D(number.doubleValue(), rectangle2D, rectangleEdge);
            d3 = valueAxis.translateValueToJava2D(number2.doubleValue(), rectangle2D, rectangleEdge);
            d2 = valueAxis.translateValueToJava2D(number3.doubleValue(), rectangle2D, rectangleEdge);
            d = valueAxis.translateValueToJava2D(number4.doubleValue(), rectangle2D, rectangleEdge);
            if (d2 < d7 && d2 < d3) {
                graphics2D.draw(new Line2D.Double(d5 + this.boxWidth / 2.0, d2, d5 + this.boxWidth / 2.0, Math.max(d7, d3)));
                graphics2D.draw(new Line2D.Double(d5, d2, d5 + this.boxWidth, d2));
            }
            if (d > d7 && d > d3) {
                graphics2D.draw(new Line2D.Double(d5 + this.boxWidth / 2.0, d, d5 + this.boxWidth / 2.0, Math.min(d7, d3)));
                graphics2D.draw(new Line2D.Double(d5, d, d5 + this.boxWidth, d));
            }
            cloneable = new Rectangle2D.Double(d5, Math.min(d7, d3), this.boxWidth, Math.abs(d7 - d3));
            graphics2D.fill((Shape)((Object)cloneable));
            graphics2D.draw((Shape)((Object)cloneable));
        }
        graphics2D.setPaint(this.artifactPaint);
        Number number5 = defaultBoxAndWhiskerCategoryDataset.getMeanValue(n, n2);
        if (number5 != null) {
            d4 = valueAxis.translateValueToJava2D(number5.doubleValue(), rectangle2D, rectangleEdge);
            d6 = this.boxWidth / 4.0;
            serializable = new Ellipse2D.Double(d5 + d6, d4 - d6, d6 * 2.0, d6 * 2.0);
            graphics2D.fill((Shape)((Object)serializable));
            graphics2D.draw((Shape)((Object)serializable));
        }
        if ((serializable = defaultBoxAndWhiskerCategoryDataset.getMedianValue(n, n2)) != null) {
            d3 = valueAxis.translateValueToJava2D(serializable.doubleValue(), rectangle2D, rectangleEdge);
            graphics2D.draw(new Line2D.Double(d5, d3, d5 + this.boxWidth, d3));
        }
        d3 = valueAxis.translateValueToJava2D(valueAxis.getUpperBound(), rectangle2D, rectangleEdge) + d6;
        d2 = valueAxis.translateValueToJava2D(valueAxis.getLowerBound(), rectangle2D, rectangleEdge) - d6;
        graphics2D.setPaint(paint);
        d = this.boxWidth / 3.0;
        cloneable = new ArrayList();
        OutlierListCollection outlierListCollection = new OutlierListCollection();
        List list = defaultBoxAndWhiskerCategoryDataset.getOutliers(n, n2);
        int n5 = 0;
        while (n5 < list.size()) {
            double d8;
            double d9 = ((Number)list.get(n5)).doubleValue();
            if (d9 > defaultBoxAndWhiskerCategoryDataset.getMaxOutlier(n, n2).doubleValue()) {
                outlierListCollection.setHighFarOut(true);
            } else if (d9 < defaultBoxAndWhiskerCategoryDataset.getMinOutlier(n, n2).doubleValue()) {
                outlierListCollection.setLowFarOut(true);
            } else if (d9 > defaultBoxAndWhiskerCategoryDataset.getMaxRegularValue(n, n2).doubleValue()) {
                d8 = valueAxis.translateValueToJava2D(d9, rectangle2D, rectangleEdge);
                cloneable.add(new Outlier(d5 + this.boxWidth / 2.0, d8, d));
            } else if (d9 < defaultBoxAndWhiskerCategoryDataset.getMinRegularValue(n, n2).doubleValue()) {
                d8 = valueAxis.translateValueToJava2D(d9, rectangle2D, rectangleEdge);
                cloneable.add(new Outlier(d5 + this.boxWidth / 2.0, d8, d));
            }
            Collections.sort((ArrayList)cloneable);
            ++n5;
        }
        Iterator iterator = cloneable.iterator();
        while (iterator.hasNext()) {
            object = (Outlier)iterator.next();
            outlierListCollection.add((Outlier)object);
        }
        object = outlierListCollection.iterator();
        while (object.hasNext()) {
            OutlierList outlierList = (OutlierList)object.next();
            Outlier outlier = outlierList.getAveragedOutlier();
            Point2D point2D = outlier.getPoint();
            if (outlierList.isMultiple()) {
                this.drawMultipleEllipse(point2D, this.boxWidth, d, graphics2D);
                continue;
            }
            this.drawEllipse(point2D, d, graphics2D);
        }
        if (outlierListCollection.isHighFarOut()) {
            this.drawHighFarOut(d6 / 2.0, graphics2D, d5 + this.boxWidth / 2.0, d3);
        }
        if (outlierListCollection.isLowFarOut()) {
            this.drawLowFarOut(d6 / 2.0, graphics2D, d5 + this.boxWidth / 2.0, d2);
        }
    }

    private void drawEllipse(Point2D point2D, double d, Graphics2D graphics2D) {
        Ellipse2D.Double double_ = new Ellipse2D.Double(point2D.getX() + d / 2.0, point2D.getY(), d, d);
        graphics2D.draw(double_);
    }

    private void drawMultipleEllipse(Point2D point2D, double d, double d2, Graphics2D graphics2D) {
        Ellipse2D.Double double_ = new Ellipse2D.Double(point2D.getX() - d / 2.0 + d2, point2D.getY(), d2, d2);
        Ellipse2D.Double double_2 = new Ellipse2D.Double(point2D.getX() + d / 2.0, point2D.getY(), d2, d2);
        graphics2D.draw(double_);
        graphics2D.draw(double_2);
    }

    private void drawHighFarOut(double d, Graphics2D graphics2D, double d2, double d3) {
        double d4 = d * 2.0;
        graphics2D.draw(new Line2D.Double(d2 - d4, d3 + d4, d2 + d4, d3 + d4));
        graphics2D.draw(new Line2D.Double(d2 - d4, d3 + d4, d2, d3));
        graphics2D.draw(new Line2D.Double(d2 + d4, d3 + d4, d2, d3));
    }

    private void drawLowFarOut(double d, Graphics2D graphics2D, double d2, double d3) {
        double d4 = d * 2.0;
        graphics2D.draw(new Line2D.Double(d2 - d4, d3 - d4, d2 + d4, d3 - d4));
        graphics2D.draw(new Line2D.Double(d2 - d4, d3 - d4, d2, d3));
        graphics2D.draw(new Line2D.Double(d2 + d4, d3 - d4, d2, d3));
    }
}

