/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart;

import com.keypoint.PngEncoder;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Iterator;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.imagemap.OverLIBToolTipTagFragmentGenerator;
import org.jfree.chart.imagemap.StandardToolTipTagFragmentGenerator;
import org.jfree.chart.imagemap.StandardURLTagFragmentGenerator;
import org.jfree.chart.imagemap.ToolTipTagFragmentGenerator;
import org.jfree.chart.imagemap.URLTagFragmentGenerator;

public class ChartUtilities {
    private static final float DEFAULT_JPEG_QUALITY = 0.75f;
    private static final int DEFAULT_PNG_COMPRESSION = 9;

    private ChartUtilities() {
    }

    public static void writeChartAsPNG(OutputStream outputStream, JFreeChart jFreeChart, int n, int n2) throws IOException {
        ChartUtilities.writeChartAsPNG(outputStream, jFreeChart, n, n2, null, false, 9);
    }

    public static void writeChartAsPNG(OutputStream outputStream, JFreeChart jFreeChart, int n, int n2, boolean bl, int n3) throws IOException {
        ChartUtilities.writeChartAsPNG(outputStream, jFreeChart, n, n2, null, bl, n3);
    }

    public static void writeChartAsPNG(OutputStream outputStream, JFreeChart jFreeChart, int n, int n2, ChartRenderingInfo chartRenderingInfo) throws IOException {
        ChartUtilities.writeChartAsPNG(outputStream, jFreeChart, n, n2, chartRenderingInfo, false, 9);
    }

    public static void writeChartAsPNG(OutputStream outputStream, JFreeChart jFreeChart, int n, int n2, ChartRenderingInfo chartRenderingInfo, boolean bl, int n3) throws IOException {
        BufferedImage bufferedImage = jFreeChart.createBufferedImage(n, n2, chartRenderingInfo);
        ChartUtilities.writeBufferedImageAsPNG(outputStream, bufferedImage, bl, n3);
    }

    public static void writeScaledChartAsPNG(OutputStream outputStream, JFreeChart jFreeChart, int n, int n2, int n3, int n4) throws IOException {
        double d = n * n3;
        double d2 = n2 * n4;
        double d3 = n;
        double d4 = n2;
        boolean bl = false;
        if (n3 != 1 || n4 != 1) {
            bl = true;
        }
        double d5 = d / d3;
        double d6 = d2 / d4;
        BufferedImage bufferedImage = new BufferedImage((int)d, (int)d2, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        if (bl) {
            AffineTransform affineTransform = graphics2D.getTransform();
            graphics2D.transform(AffineTransform.getScaleInstance(d5, d6));
            jFreeChart.draw(graphics2D, new Rectangle2D.Double(0.0, 0.0, d3, d4), null);
            graphics2D.setTransform(affineTransform);
            graphics2D.dispose();
        } else {
            jFreeChart.draw(graphics2D, new Rectangle2D.Double(0.0, 0.0, d3, d4), null);
        }
        outputStream.write(ChartUtilities.encodeAsPNG(bufferedImage));
    }

    public static void saveChartAsPNG(File file, JFreeChart jFreeChart, int n, int n2) throws IOException {
        ChartUtilities.saveChartAsPNG(file, jFreeChart, n, n2, null);
    }

    public static void saveChartAsPNG(File file, JFreeChart jFreeChart, int n, int n2, ChartRenderingInfo chartRenderingInfo) throws IOException {
        ChartUtilities.saveChartAsPNG(file, jFreeChart, n, n2, chartRenderingInfo, false, 9);
    }

    public static void saveChartAsPNG(File file, JFreeChart jFreeChart, int n, int n2, ChartRenderingInfo chartRenderingInfo, boolean bl, int n3) throws IOException {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        ChartUtilities.writeChartAsPNG(bufferedOutputStream, jFreeChart, n, n2, chartRenderingInfo, bl, n3);
        ((OutputStream)bufferedOutputStream).close();
    }

    public static void writeChartAsJPEG(OutputStream outputStream, JFreeChart jFreeChart, int n, int n2) throws IOException {
        ChartUtilities.writeChartAsJPEG(outputStream, 0.75f, jFreeChart, n, n2, null);
    }

    public static void writeChartAsJPEG(OutputStream outputStream, float f, JFreeChart jFreeChart, int n, int n2) throws IOException {
        ChartUtilities.writeChartAsJPEG(outputStream, f, jFreeChart, n, n2, null);
    }

    public static void writeChartAsJPEG(OutputStream outputStream, JFreeChart jFreeChart, int n, int n2, ChartRenderingInfo chartRenderingInfo) throws IOException {
        ChartUtilities.writeChartAsJPEG(outputStream, 0.75f, jFreeChart, n, n2, chartRenderingInfo);
    }

    public static void writeChartAsJPEG(OutputStream outputStream, float f, JFreeChart jFreeChart, int n, int n2, ChartRenderingInfo chartRenderingInfo) throws IOException {
        BufferedImage bufferedImage = jFreeChart.createBufferedImage(n, n2, chartRenderingInfo);
        ChartUtilities.writeBufferedImageAsJPEG(outputStream, f, bufferedImage);
    }

    public static void saveChartAsJPEG(File file, JFreeChart jFreeChart, int n, int n2) throws IOException {
        ChartUtilities.saveChartAsJPEG(file, 0.75f, jFreeChart, n, n2, null);
    }

    public static void saveChartAsJPEG(File file, float f, JFreeChart jFreeChart, int n, int n2) throws IOException {
        ChartUtilities.saveChartAsJPEG(file, f, jFreeChart, n, n2, null);
    }

    public static void saveChartAsJPEG(File file, JFreeChart jFreeChart, int n, int n2, ChartRenderingInfo chartRenderingInfo) throws IOException {
        ChartUtilities.saveChartAsJPEG(file, 0.75f, jFreeChart, n, n2, chartRenderingInfo);
    }

    public static void saveChartAsJPEG(File file, float f, JFreeChart jFreeChart, int n, int n2, ChartRenderingInfo chartRenderingInfo) throws IOException {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        ChartUtilities.writeChartAsJPEG(bufferedOutputStream, f, jFreeChart, n, n2, chartRenderingInfo);
        ((OutputStream)bufferedOutputStream).close();
    }

    public static void writeBufferedImageAsJPEG(OutputStream outputStream, BufferedImage bufferedImage) throws IOException {
        ChartUtilities.writeBufferedImageAsJPEG(outputStream, 0.75f, bufferedImage);
    }

    public static void writeBufferedImageAsJPEG(OutputStream outputStream, float f, BufferedImage bufferedImage) throws IOException {
        JPEGImageEncoder jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)outputStream);
        JPEGEncodeParam jPEGEncodeParam = jPEGImageEncoder.getDefaultJPEGEncodeParam(bufferedImage);
        jPEGEncodeParam.setQuality(f, true);
        jPEGImageEncoder.encode(bufferedImage, jPEGEncodeParam);
    }

    public static void writeBufferedImageAsPNG(OutputStream outputStream, BufferedImage bufferedImage) throws IOException {
        outputStream.write(ChartUtilities.encodeAsPNG(bufferedImage));
    }

    public static void writeBufferedImageAsPNG(OutputStream outputStream, BufferedImage bufferedImage, boolean bl, int n) throws IOException {
        outputStream.write(ChartUtilities.encodeAsPNG(bufferedImage, bl, n));
    }

    public static byte[] encodeAsPNG(BufferedImage bufferedImage) {
        return ChartUtilities.encodeAsPNG(bufferedImage, false, 9);
    }

    public static byte[] encodeAsPNG(BufferedImage bufferedImage, boolean bl, int n) {
        PngEncoder pngEncoder = new PngEncoder(bufferedImage, bl, 0, n);
        return pngEncoder.pngEncode();
    }

    public static void writeImageMap(PrintWriter printWriter, String string, ChartRenderingInfo chartRenderingInfo) throws IOException {
        ChartUtilities.writeImageMap(printWriter, string, chartRenderingInfo, new StandardToolTipTagFragmentGenerator(), new StandardURLTagFragmentGenerator());
    }

    public static void writeImageMap(PrintWriter printWriter, String string, ChartRenderingInfo chartRenderingInfo, boolean bl) throws IOException {
        ToolTipTagFragmentGenerator toolTipTagFragmentGenerator = null;
        toolTipTagFragmentGenerator = bl ? new OverLIBToolTipTagFragmentGenerator() : new StandardToolTipTagFragmentGenerator();
        ChartUtilities.writeImageMap(printWriter, string, chartRenderingInfo, toolTipTagFragmentGenerator, new StandardURLTagFragmentGenerator());
    }

    public static void writeImageMap(PrintWriter printWriter, String string, ChartRenderingInfo chartRenderingInfo, ToolTipTagFragmentGenerator toolTipTagFragmentGenerator, URLTagFragmentGenerator uRLTagFragmentGenerator) throws IOException {
        printWriter.println("<MAP NAME=\"" + string + "\">");
        EntityCollection entityCollection = chartRenderingInfo.getEntityCollection();
        if (entityCollection != null) {
            Iterator iterator = entityCollection.iterator();
            while (iterator.hasNext()) {
                ChartEntity chartEntity = (ChartEntity)iterator.next();
                String string2 = chartEntity.getImageMapAreaTag(toolTipTagFragmentGenerator, uRLTagFragmentGenerator);
                if (string2.length() <= 0) continue;
                printWriter.println(string2);
            }
        }
        printWriter.println("</MAP>");
    }
}

