/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import org.jfree.chart.ChartColor;
import org.jfree.chart.plot.DrawingSupplier;
import org.jfree.io.SerialUtilities;
import org.jfree.util.PublicCloneable;

public class DefaultDrawingSupplier
implements DrawingSupplier,
Cloneable,
PublicCloneable,
Serializable {
    public static final Paint[] DEFAULT_PAINT_SEQUENCE = ChartColor.createDefaultPaintArray();
    public static final Paint[] DEFAULT_OUTLINE_PAINT_SEQUENCE = new Paint[]{Color.lightGray};
    public static final Stroke[] DEFAULT_STROKE_SEQUENCE = new Stroke[]{new BasicStroke(1.0f, 2, 2)};
    public static final Stroke[] DEFAULT_OUTLINE_STROKE_SEQUENCE = new Stroke[]{new BasicStroke(1.0f, 2, 2)};
    public static final Shape[] DEFAULT_SHAPE_SEQUENCE = DefaultDrawingSupplier.createStandardSeriesShapes();
    private transient Paint[] paintSequence;
    private int paintIndex;
    private transient Paint[] outlinePaintSequence;
    private int outlinePaintIndex;
    private transient Stroke[] strokeSequence;
    private int strokeIndex;
    private transient Stroke[] outlineStrokeSequence;
    private int outlineStrokeIndex;
    private transient Shape[] shapeSequence;
    private int shapeIndex;

    public DefaultDrawingSupplier() {
        this(DEFAULT_PAINT_SEQUENCE, DEFAULT_OUTLINE_PAINT_SEQUENCE, DEFAULT_STROKE_SEQUENCE, DEFAULT_OUTLINE_STROKE_SEQUENCE, DEFAULT_SHAPE_SEQUENCE);
    }

    public DefaultDrawingSupplier(Paint[] paintArray, Paint[] paintArray2, Stroke[] strokeArray, Stroke[] strokeArray2, Shape[] shapeArray) {
        this.paintSequence = paintArray;
        this.outlinePaintSequence = paintArray2;
        this.strokeSequence = strokeArray;
        this.outlineStrokeSequence = strokeArray2;
        this.shapeSequence = shapeArray;
    }

    public Paint getNextPaint() {
        Paint paint = this.paintSequence[this.paintIndex % this.paintSequence.length];
        ++this.paintIndex;
        return paint;
    }

    public Paint getNextOutlinePaint() {
        Paint paint = this.outlinePaintSequence[this.outlinePaintIndex % this.outlinePaintSequence.length];
        ++this.outlinePaintIndex;
        return paint;
    }

    public Stroke getNextStroke() {
        Stroke stroke = this.strokeSequence[this.strokeIndex % this.strokeSequence.length];
        ++this.strokeIndex;
        return stroke;
    }

    public Stroke getNextOutlineStroke() {
        Stroke stroke = this.outlineStrokeSequence[this.outlineStrokeIndex % this.outlineStrokeSequence.length];
        ++this.outlineStrokeIndex;
        return stroke;
    }

    public Shape getNextShape() {
        Shape shape = this.shapeSequence[this.shapeIndex % this.shapeSequence.length];
        ++this.shapeIndex;
        return shape;
    }

    public static Shape[] createStandardSeriesShapes() {
        Shape[] shapeArray = new Shape[10];
        double d = 6.0;
        double d2 = d / 2.0;
        int[] nArray = null;
        int[] nArray2 = null;
        shapeArray[0] = new Rectangle2D.Double(-d2, -d2, d, d);
        shapeArray[1] = new Ellipse2D.Double(-d2, -d2, d, d);
        nArray = DefaultDrawingSupplier.intArray(0.0, d2, -d2);
        nArray2 = DefaultDrawingSupplier.intArray(-d2, d2, d2);
        shapeArray[2] = new Polygon(nArray, nArray2, 3);
        nArray = DefaultDrawingSupplier.intArray(0.0, d2, 0.0, -d2);
        nArray2 = DefaultDrawingSupplier.intArray(-d2, 0.0, d2, 0.0);
        shapeArray[3] = new Polygon(nArray, nArray2, 4);
        shapeArray[4] = new Rectangle2D.Double(-d2, -d2 / 2.0, d, d / 2.0);
        nArray = DefaultDrawingSupplier.intArray(-d2, d2, 0.0);
        nArray2 = DefaultDrawingSupplier.intArray(-d2, -d2, d2);
        shapeArray[5] = new Polygon(nArray, nArray2, 3);
        shapeArray[6] = new Ellipse2D.Double(-d2, -d2 / 2.0, d, d / 2.0);
        nArray = DefaultDrawingSupplier.intArray(-d2, d2, -d2);
        nArray2 = DefaultDrawingSupplier.intArray(-d2, 0.0, d2);
        shapeArray[7] = new Polygon(nArray, nArray2, 3);
        shapeArray[8] = new Rectangle2D.Double(-d2 / 2.0, -d2, d / 2.0, d);
        nArray = DefaultDrawingSupplier.intArray(-d2, d2, d2);
        nArray2 = DefaultDrawingSupplier.intArray(0.0, -d2, d2);
        shapeArray[9] = new Polygon(nArray, nArray2, 3);
        return shapeArray;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof DefaultDrawingSupplier) {
            DefaultDrawingSupplier defaultDrawingSupplier = (DefaultDrawingSupplier)object;
            boolean bl = Arrays.equals(this.paintSequence, defaultDrawingSupplier.paintSequence);
            boolean bl2 = this.paintIndex == defaultDrawingSupplier.paintIndex;
            boolean bl3 = Arrays.equals(this.outlinePaintSequence, defaultDrawingSupplier.outlinePaintSequence);
            boolean bl4 = this.outlinePaintIndex == defaultDrawingSupplier.outlinePaintIndex;
            boolean bl5 = Arrays.equals(this.strokeSequence, defaultDrawingSupplier.strokeSequence);
            boolean bl6 = this.strokeIndex == defaultDrawingSupplier.strokeIndex;
            boolean bl7 = Arrays.equals(this.outlineStrokeSequence, defaultDrawingSupplier.outlineStrokeSequence);
            boolean bl8 = this.outlineStrokeIndex == defaultDrawingSupplier.outlineStrokeIndex;
            boolean bl9 = true;
            boolean bl10 = this.shapeIndex == defaultDrawingSupplier.shapeIndex;
            return bl && bl2 && bl3 && bl4 && bl5 && bl6 && bl7 && bl8 && bl9 && bl10;
        }
        return false;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        int n = this.paintSequence.length;
        objectOutputStream.writeInt(n);
        int n2 = 0;
        while (n2 < n) {
            SerialUtilities.writePaint(this.paintSequence[n2], objectOutputStream);
            ++n2;
        }
        int n3 = this.outlinePaintSequence.length;
        objectOutputStream.writeInt(n3);
        int n4 = 0;
        while (n4 < n3) {
            SerialUtilities.writePaint(this.outlinePaintSequence[n4], objectOutputStream);
            ++n4;
        }
        int n5 = this.strokeSequence.length;
        objectOutputStream.writeInt(n5);
        int n6 = 0;
        while (n6 < n5) {
            SerialUtilities.writeStroke(this.strokeSequence[n6], objectOutputStream);
            ++n6;
        }
        int n7 = this.outlineStrokeSequence.length;
        objectOutputStream.writeInt(n7);
        int n8 = 0;
        while (n8 < n7) {
            SerialUtilities.writeStroke(this.outlineStrokeSequence[n8], objectOutputStream);
            ++n8;
        }
        int n9 = this.shapeSequence.length;
        objectOutputStream.writeInt(n9);
        int n10 = 0;
        while (n10 < n9) {
            SerialUtilities.writeShape(this.shapeSequence[n10], objectOutputStream);
            ++n10;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.paintSequence = new Paint[n];
        int n2 = 0;
        while (n2 < n) {
            this.paintSequence[n2] = SerialUtilities.readPaint(objectInputStream);
            ++n2;
        }
        int n3 = objectInputStream.readInt();
        this.outlinePaintSequence = new Paint[n3];
        int n4 = 0;
        while (n4 < n3) {
            this.outlinePaintSequence[n4] = SerialUtilities.readPaint(objectInputStream);
            ++n4;
        }
        int n5 = objectInputStream.readInt();
        this.strokeSequence = new Stroke[n5];
        int n6 = 0;
        while (n6 < n5) {
            this.strokeSequence[n6] = SerialUtilities.readStroke(objectInputStream);
            ++n6;
        }
        int n7 = objectInputStream.readInt();
        this.outlineStrokeSequence = new Stroke[n7];
        int n8 = 0;
        while (n8 < n7) {
            this.outlineStrokeSequence[n8] = SerialUtilities.readStroke(objectInputStream);
            ++n8;
        }
        int n9 = objectInputStream.readInt();
        this.shapeSequence = new Shape[n9];
        int n10 = 0;
        while (n10 < n9) {
            this.shapeSequence[n10] = SerialUtilities.readShape(objectInputStream);
            ++n10;
        }
    }

    private static int[] intArray(double d, double d2, double d3) {
        return new int[]{(int)d, (int)d2, (int)d3};
    }

    private static int[] intArray(double d, double d2, double d3, double d4) {
        return new int[]{(int)d, (int)d2, (int)d3, (int)d4};
    }

    public Object clone() throws CloneNotSupportedException {
        DefaultDrawingSupplier defaultDrawingSupplier = (DefaultDrawingSupplier)super.clone();
        return defaultDrawingSupplier;
    }
}

