/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.jfree.util.ObjectUtils;

public class AbstractObjectList
implements Cloneable,
Serializable {
    public static final int DEFAULT_INITIAL_CAPACITY = 8;
    private transient Object[] objects;
    private int size = 0;

    protected AbstractObjectList() {
        this(8);
    }

    protected AbstractObjectList(int n) {
        this.objects = new Object[n];
    }

    protected Object get(int n) {
        Object object = null;
        if (n >= 0 && n < this.size) {
            object = this.objects[n];
        }
        return object;
    }

    protected void set(int n, Object object) {
        if (n < 0) {
            throw new IllegalArgumentException("ObjectList.set(...): index must be >= 0.");
        }
        if (n >= this.objects.length) {
            Object[] objectArray = new Object[n + 1];
            System.arraycopy(this.objects, 0, objectArray, 0, this.objects.length);
            this.objects = objectArray;
        }
        this.objects[n] = object;
        this.size = Math.max(this.size, n + 1);
    }

    public void clear() {
        this.objects = new Object[8];
        this.size = 0;
    }

    public int size() {
        return this.size;
    }

    protected int indexOf(Object object) {
        int n = 0;
        while (n < this.size) {
            if (this.objects[n] == object) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof AbstractObjectList) {
            AbstractObjectList abstractObjectList = (AbstractObjectList)object;
            if (this.size == abstractObjectList.size) {
                int n = 0;
                while (n < this.size) {
                    if (!ObjectUtils.equal(this.objects[n], abstractObjectList.objects[n])) {
                        return false;
                    }
                    ++n;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        AbstractObjectList abstractObjectList = (AbstractObjectList)super.clone();
        if (this.objects != null) {
            abstractObjectList.objects = (Object[])this.objects.clone();
        }
        return abstractObjectList;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        int n = this.size();
        objectOutputStream.writeInt(n);
        int n2 = 0;
        while (n2 < n) {
            Object object = this.get(n2);
            if (object != null && object instanceof Serializable) {
                objectOutputStream.writeInt(n2);
                objectOutputStream.writeObject(object);
            } else {
                objectOutputStream.writeInt(-1);
            }
            ++n2;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.objects = new Object[this.size];
        int n = objectInputStream.readInt();
        int n2 = 0;
        while (n2 < n) {
            int n3 = objectInputStream.readInt();
            if (n3 != -1) {
                this.set(n3, objectInputStream.readObject());
            }
            ++n2;
        }
    }
}

