/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml.factory.objects;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import org.jfree.util.Log;
import org.jfree.xml.factory.objects.AbstractObjectDescription;
import org.jfree.xml.factory.objects.ObjectDescription;
import org.jfree.xml.factory.objects.ObjectFactoryException;

public class ArrayObjectDescription
extends AbstractObjectDescription {
    static /* synthetic */ Class class$java$lang$Object;

    public ArrayObjectDescription(Class clazz) {
        super(clazz);
        if (!clazz.isArray()) {
            throw new IllegalArgumentException("Need an array class");
        }
    }

    public Object createObject() {
        try {
            Integer n = (Integer)this.getParameter("size");
            if (n == null) {
                Object object;
                ArrayList<Object> arrayList = new ArrayList<Object>();
                int n2 = 0;
                while (this.getParameterDefinition(String.valueOf(n2)) != null) {
                    object = this.getParameter(String.valueOf(n2));
                    if (object == null) break;
                    arrayList.add(object);
                    ++n2;
                }
                object = Array.newInstance(this.getObjectClass().getComponentType(), arrayList.size());
                int n3 = 0;
                while (n3 < arrayList.size()) {
                    Array.set(object, n3, arrayList.get(n3));
                    ++n3;
                }
                return object;
            }
            Object object = Array.newInstance(this.getObjectClass().getComponentType(), (int)n);
            int n4 = 0;
            while (n4 < n) {
                Array.set(object, n4, this.getParameter(String.valueOf(n4)));
                ++n4;
            }
            return object;
        }
        catch (Exception exception) {
            Log.warn("Unable to instantiate Object", exception);
            return null;
        }
    }

    public void setParameterFromObject(Object object) throws ObjectFactoryException {
        if (object == null) {
            throw new ObjectFactoryException("Given object is null.");
        }
        if (!object.getClass().isArray()) {
            throw new ObjectFactoryException("Given object is no array");
        }
        if (!this.getObjectClass().isAssignableFrom(object.getClass())) {
            throw new ObjectFactoryException("Given object is incompatible with base class");
        }
        int n = Array.getLength(object);
        this.setParameter("size", new Integer(n));
        int n2 = 0;
        while (n2 < n) {
            this.setParameter(String.valueOf(n2), Array.get(object, n2));
            ++n2;
        }
    }

    private int parseParameterName(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public Class getParameterDefinition(String string) {
        if (string.equals("size")) {
            return Integer.TYPE;
        }
        int n = this.parseParameterName(string);
        if (n < 0) {
            return null;
        }
        return class$java$lang$Object == null ? (class$java$lang$Object = ArrayObjectDescription.class$("java.lang.Object")) : class$java$lang$Object;
    }

    public Iterator getParameterNames() {
        Integer n = (Integer)this.getParameter("size");
        if (n == null) {
            return this.getDefinedParameterNames();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("size");
        int n2 = 0;
        while (n2 < n) {
            arrayList.add(String.valueOf(n2));
            ++n2;
        }
        return arrayList.iterator();
    }

    public ObjectDescription getInstance() {
        return new ArrayObjectDescription(this.getObjectClass());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

