/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.ImageData;
import common.PlayImageThread;
import common.bixpp.Record;
import common.bixpp.RecordItem;
import common.swing.BixPanel;
import common.swing.ImagePanel;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.GregorianCalendar;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class BixImagePanel
extends BixPanel {
    private BufferedImage bufferedImage;
    private int cnt;
    private int imageCnt;
    private int interval;
    private JLabel dayLabel;
    private JLabel dateLabel;
    private File file;
    private File[] files;
    private JTextField fileNameField;
    private Vector imageNames;
    private Vector imageUris;
    private ImagePanel imagePanel;
    private JList list;
    private JButton nextButton;
    private JButton backButton;
    private JButton rewindButton;
    private JButton playButton;
    private JButton stopButton;
    private boolean playFlag = false;
    private JScrollPane scroll1;
    private JSlider slider;
    private JSpinner spinner;
    private JSplitPane splitPane;
    private PlayImageThread thread;
    private GregorianCalendar calendar;
    static /* synthetic */ Class class$0;

    public BixImagePanel() {
        GridBagLayout gbLayout = new GridBagLayout();
        this.setLayout(gbLayout);
        this.interval = 200;
        this.thread = new PlayImageThread(this, 500L);
        this.imagePanel = new ImagePanel();
        JScrollPane scroll0 = new JScrollPane(this.imagePanel);
        scroll0.setPreferredSize(new Dimension(643, 483));
        scroll0.setMinimumSize(new Dimension(320, 240));
        this.imageUris = new Vector();
        this.imageNames = new Vector();
        this.list = new JList(this.imageNames);
        this.list.setSelectionMode(0);
        this.list.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                BixImagePanel.this.thread.stopRunning();
                BixImagePanel.this.imageUris.clear();
                if (BixImagePanel.this.imageNames.size() > 0 && BixImagePanel.this.list.getSelectedIndex() >= 0) {
                    int index = ((RecordItem)BixImagePanel.this.imageNames.get(BixImagePanel.this.list.getSelectedIndex())).getIndex();
                    int i = 0;
                    while (i < BixImagePanel.this.bixpp.getRecordSize()) {
                        Record record = BixImagePanel.this.bixpp.getRecord(i);
                        int j = 0;
                        while (j < BixImagePanel.this.bixpp.getRecord(i).size()) {
                            if (index == BixImagePanel.this.bixpp.getRecord(i).getItem(j).getIndex()) {
                                BixImagePanel.this.imageUris.add(new ImageData(record.getDays(), record.getItem(j).getUri()));
                            }
                            ++j;
                        }
                        ++i;
                    }
                }
                BixImagePanel.this.imageCnt = 0;
                BixImagePanel.this.slider.setMinimum(0);
                BixImagePanel.this.slider.setMaximum(BixImagePanel.this.imageUris.size() - 1);
                BixImagePanel.this.slider.setValue(BixImagePanel.this.imageCnt);
                BixImagePanel.this.changeImage();
            }
        });
        this.scroll1 = new JScrollPane(this.list);
        this.scroll1.setPreferredSize(new Dimension(200, -1));
        this.scroll1.setMinimumSize(new Dimension(100, 100));
        this.add(this.scroll1);
        this.splitPane = new JSplitPane();
        this.splitPane.setLeftComponent(scroll0);
        this.splitPane.setRightComponent(this.scroll1);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setResizeWeight(1.0);
        GridBagConstraints c0 = new GridBagConstraints();
        c0.fill = 1;
        c0.gridheight = 0;
        c0.anchor = 18;
        c0.gridwidth = 0;
        c0.gridheight = 1;
        c0.weightx = 1.0;
        c0.weighty = 1.0;
        c0.insets = new Insets(10, 10, 10, 10);
        gbLayout.setConstraints(this.splitPane, c0);
        this.add(this.splitPane);
        this.slider = new JSlider(0, 0, 0);
        this.slider.setSize(500, 50);
        this.slider.setLocation(10, 420);
        this.slider.setPaintTicks(true);
        this.slider.setSnapToTicks(true);
        this.slider.setMinorTickSpacing(1);
        this.slider.setMajorTickSpacing(10);
        this.slider.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent arg0) {
                BixImagePanel.this.imageCnt = BixImagePanel.this.slider.getValue();
                if (BixImagePanel.this.imageUris.size() != 0) {
                    BixImagePanel.this.changeImage();
                }
            }

            public void keyReleased(KeyEvent arg0) {
            }

            public void keyTyped(KeyEvent arg0) {
            }
        });
        this.slider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent arg0) {
                if (BixImagePanel.this.slider.getValueIsAdjusting()) {
                    BixImagePanel.this.imageCnt = BixImagePanel.this.slider.getValue();
                    if (BixImagePanel.this.imageUris.size() != 0) {
                        BixImagePanel.this.changeImage();
                    }
                }
            }
        });
        JToolBar tool0 = new JToolBar();
        tool0.setLayout(new GridBagLayout());
        GridBagConstraints c1 = new GridBagConstraints();
        c1.insets = new Insets(4, 4, 4, 4);
        c1.fill = 2;
        c1.weightx = 1.0;
        ((GridBagLayout)tool0.getLayout()).setConstraints(this.slider, c1);
        tool0.add(this.slider);
        tool0.setFloatable(false);
        tool0.setBorder(BorderFactory.createEtchedBorder());
        c1 = new GridBagConstraints();
        c1.fill = 2;
        c1.gridy = 1;
        c1.insets = new Insets(0, 10, 10, 10);
        gbLayout.setConstraints(tool0, c1);
        this.add(tool0);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("common.BixImagePanel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.rewindButton = new JButton(new ImageIcon(clazz.getResource("images/rewind.png")));
        this.rewindButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                BixImagePanel.this.imageCnt = 0;
                BixImagePanel.this.thread.stopRunning();
                BixImagePanel.this.changeImage();
            }
        });
        this.rewindButton.setToolTipText("\u505c\u6b62");
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("common.BixImagePanel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.backButton = new JButton(new ImageIcon(clazz2.getResource("images/back.png")));
        this.backButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                if (BixImagePanel.this.imageCnt > 0) {
                    BixImagePanel bixImagePanel = BixImagePanel.this;
                    bixImagePanel.imageCnt = bixImagePanel.imageCnt - 1;
                    BixImagePanel.this.changeImage();
                }
            }
        });
        this.backButton.setToolTipText("\u524d\u306e\u753b\u50cf");
        Class<?> clazz3 = class$0;
        if (clazz3 == null) {
            try {
                clazz3 = class$0 = Class.forName("common.BixImagePanel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.nextButton = new JButton(new ImageIcon(clazz3.getResource("images/next.png")));
        this.nextButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                if (BixImagePanel.this.imageCnt < BixImagePanel.this.imageUris.size() - 1) {
                    BixImagePanel bixImagePanel = BixImagePanel.this;
                    bixImagePanel.imageCnt = bixImagePanel.imageCnt + 1;
                    BixImagePanel.this.changeImage();
                }
            }
        });
        this.nextButton.setToolTipText("\u6b21\u306e\u753b\u50cf");
        Class<?> clazz4 = class$0;
        if (clazz4 == null) {
            try {
                clazz4 = class$0 = Class.forName("common.BixImagePanel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.playButton = new JButton(new ImageIcon(clazz4.getResource("images/play.png")));
        this.playButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                BixImagePanel.this.playImage();
            }
        });
        this.playButton.setToolTipText("\u9023\u7d9a\u518d\u751f");
        Class<?> clazz5 = class$0;
        if (clazz5 == null) {
            try {
                clazz5 = class$0 = Class.forName("common.BixImagePanel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.stopButton = new JButton(new ImageIcon(clazz5.getResource("images/stop.png")));
        this.stopButton.setSize(80, 30);
        this.stopButton.setLocation(380, 470);
        this.stopButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                BixImagePanel.this.thread.stopRunning();
            }
        });
        this.stopButton.setToolTipText("\u4e00\u6642\u505c\u6b62");
        this.spinner = new JSpinner(new SpinnerNumberModel(this.interval, 10, 1000, 10));
        this.spinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent arg0) {
                BixImagePanel.this.interval = (Integer)BixImagePanel.this.spinner.getValue();
                BixImagePanel.this.thread.setInterval(BixImagePanel.this.interval);
            }
        });
        JToolBar tool1 = new JToolBar();
        tool1.setBorder(BorderFactory.createEtchedBorder());
        tool1.setFloatable(false);
        tool1.setRollover(true);
        GridBagLayout gLayout = new GridBagLayout();
        tool1.setLayout(gLayout);
        GridBagConstraints c2 = new GridBagConstraints();
        c2.insets = new Insets(2, 2, 2, 2);
        c2.anchor = 17;
        gLayout.setConstraints(this.playButton, c2);
        gLayout.setConstraints(this.stopButton, c2);
        gLayout.setConstraints(this.rewindButton, c2);
        gLayout.setConstraints(this.backButton, c2);
        gLayout.setConstraints(this.nextButton, c2);
        gLayout.setConstraints(this.spinner, c2);
        tool1.add(this.playButton);
        tool1.add(this.stopButton);
        tool1.add(this.rewindButton);
        tool1.add(this.backButton);
        tool1.add(this.nextButton);
        tool1.add(this.spinner);
        c2 = new GridBagConstraints();
        c2.gridy = 2;
        c2.anchor = 17;
        c2.insets = new Insets(0, 10, 0, 10);
        gbLayout.setConstraints(tool1, c2);
        this.add(tool1);
        JPanel infoPanel = new JPanel();
        infoPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "\u753b\u50cf\u30c7\u30fc\u30bf"));
        GridBagLayout gbLayout1 = new GridBagLayout();
        infoPanel.setLayout(gbLayout1);
        this.fileNameField = new JTextField();
        this.fileNameField.setBorder(null);
        this.fileNameField.setEditable(false);
        this.dayLabel = new JLabel();
        this.dateLabel = new JLabel();
        JLabel label0 = new JLabel("File Name");
        JLabel label1 = new JLabel("\u751f\u7523\u7d4c\u904e\u65e5\u6570");
        JLabel label2 = new JLabel("\u65e5\u4ed8");
        GridBagConstraints cf0 = new GridBagConstraints();
        cf0.insets = new Insets(10, 10, 10, 10);
        cf0.anchor = 17;
        gbLayout1.setConstraints(label0, cf0);
        infoPanel.add(label0);
        cf0.gridy = 1;
        gbLayout1.setConstraints(label1, cf0);
        infoPanel.add(label1);
        cf0.gridy = 2;
        gbLayout1.setConstraints(label2, cf0);
        infoPanel.add(label2);
        cf0.gridx = 1;
        cf0.gridy = 0;
        cf0.fill = 2;
        cf0.weightx = 1.0;
        gbLayout1.setConstraints(this.fileNameField, cf0);
        infoPanel.add(this.fileNameField);
        cf0.gridy = 1;
        gbLayout1.setConstraints(this.dayLabel, cf0);
        infoPanel.add(this.dayLabel);
        cf0.gridy = 2;
        gbLayout1.setConstraints(this.dateLabel, cf0);
        infoPanel.add(this.dateLabel);
        this.calendar = new GregorianCalendar();
        GridBagConstraints c3 = new GridBagConstraints();
        c3.gridy = 3;
        c3.fill = 2;
        c3.insets = new Insets(5, 10, 10, 10);
        gbLayout.setConstraints(infoPanel, c3);
        this.add(infoPanel);
        this.repaint();
    }

    private void changeImage() {
        if (this.imageUris.size() <= 0) {
            return;
        }
        ImageData id = (ImageData)this.imageUris.get(this.imageCnt);
        try {
            this.imagePanel.setImage(ImageIO.read(id.getUri().toURL()));
            this.repaint();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            this.imagePanel.clearImage();
        }
        this.slider.setValue(this.imageCnt);
        this.fileNameField.setText(id.getUri().getPath());
        this.dayLabel.setText(String.valueOf(Integer.toString(id.getDay())) + "\u65e5");
        this.calendar.setTime(this.bixpp.getStartDate());
        this.calendar.add(5, id.getDay());
        this.dateLabel.setText(String.valueOf(this.calendar.get(1)) + "\u5e74" + (this.calendar.get(2) + 1) + "\u6708" + this.calendar.get(5) + "\u65e5");
        this.repaint();
    }

    public void nextImage() {
        if (this.imageCnt < this.imageUris.size() - 1) {
            ++this.imageCnt;
            this.changeImage();
        } else {
            this.thread.stopRunning();
            this.imageCnt = 0;
            this.changeImage();
        }
    }

    public void parse() {
        this.imageNames.clear();
        int i = 0;
        while (i < this.bixpp.getRecordingDefinitionSize()) {
            if (this.bixpp.getRecordItem(i).getKind().equals("ImageItem")) {
                this.imageNames.add(this.bixpp.getRecordItem(i));
            }
            ++i;
        }
        this.list.setListData(this.imageNames);
        this.list.setSelectedIndex(0);
    }

    private void playImage() {
        this.thread.stopRunning();
        this.thread = new PlayImageThread(this, this.interval);
        this.thread.start();
    }
}

