// Control sheild test program
// 2014.11.7 T.Hoshi
// ver. 1.0
// このプログラムは、入力端子に信号を与えると、
// 対応する出力に0.25秒ごとの点滅信号を出力するものです。
// これで基板のテストが可能です。
// また、入出力のサンプルプログラムやアプリケーション作成
// 時のライブラリとしても使用できます。

// 入出力ポートの定義
const int port[4] = { 5, 6, 7, 8 } ;
// ウオッチドッグタイマーのリセットポート
const int wdt = 9 ; // 0 = clear timer
// ディジタル出力値の一時記憶装置のトリガポート
const int ratch = 3 ; //  0->1 ratch
// ディジタル入力値のイネーブルポート
const int in_out = 2 ; // in = 1 out =0

int data[4] ; // 入出力値用変数
int i ; // ループ用変数

// ウオッチドッグタイマーのクリア(2秒以内に1回の実行が必要)
void clearWdt() {
  digitalWrite(wdt, LOW) ;
  delayMicroseconds(100) ;
  digitalWrite(wdt, HIGH) ;
}

// ディジタル値を出力する　d[0]-d[3]の値 0はOFF、1はON
void dout(int *d) {
  digitalWrite(in_out, LOW) ;
  for(i = 0; i < 4; i++) {
    pinMode(port[i], OUTPUT) ;
    digitalWrite(port[i], d[i]) ;
  }
  delayMicroseconds(1) ;
  digitalWrite(ratch, HIGH) ;
  delayMicroseconds(1) ; 
  digitalWrite(ratch, LOW) ;
  for(i = 0; i < 4; i++) {
    pinMode(port[i], INPUT) ;
  }
  digitalWrite(in_out, HIGH) ;
}

// ディジタル出力を全てOFFにする
void clearDout() {
  int d[4] = { 
    LOW, LOW, LOW, LOW        } 
  ;
  dout(d) ;
}

//　ディジタル入力値の読み込み　d[0]-d[3]に値を代入
void din(int *d) {
  digitalWrite(in_out, HIGH) ;
  delayMicroseconds(1) ;
  for(i = 0; i < 4; i++) {
    pinMode(port[i], INPUT) ;
    delayMicroseconds(1) ;
    d[i] = digitalRead(port[i]) ;
  }
}

// 初期化処理
void setup() {
  pinMode(wdt, OUTPUT) ;
  digitalWrite(wdt, HIGH) ; // ウオッチドッグクリア信号を初期値にする
  clearWdt() ;
  pinMode(in_out, OUTPUT) ;
  digitalWrite(in_out, HIGH) ; //　入力方向に
  clearDout() ; // CPU出力段をとりあえずゼロに電源投入時の誤動作防止
  pinMode(ratch, OUTPUT) ;
  digitalWrite(ratch, LOW) ; // 記録トリガをリセット
  clearDout() ; // 出力をリセット
}

// ディジタル入力がONのときに、それに対応する出力を
// 0.5秒周期でオンオフする
void loop() {
  din(data) ; // ディジタル入力値読み込み
  dout(data) ; // その値をディジタル出力する
  delay(250) ; // 0.25秒待つ
  clearDout() ; // 全てのディジタル出力をOFFにする
  delay(250) ; // 0.25秒待つ
  clearWdt() ; // ウオッチドッグタイマクリア
}





