package UECS.uecsandroidmonitor;

import UECS.uecsandroidmonitor.settei;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Bundle;
import android.preference.PreferenceManager;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.util.Log;
import android.util.Xml;
import android.view.Gravity;
import android.view.Menu;
import android.view.MenuItem;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.widget.Toast;

import java.io.StringReader;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.util.Timer;
import java.util.TimerTask;

import org.xmlpull.v1.XmlPullParser;

public class MainActivity extends Activity {


	 /** Called when the activity is first created. */
	DatagramSocket socket;
	DatagramPacket packet;
	String CCM, type, setteiroom, setteiregion, setteiorder, setteiscale;
	boolean allrecv, filterpass;
	XmlPullParser parser = Xml.newPullParser();
	int room, region, order, priority;
	int ataihantei = 0;
	Float atai;
	ConnectivityManager cm;
	//ݒ
	SharedPreferences sp;
	MenuItem setteimenu;
	
	final int INTERVAL_PERIOD = 100;//0.1bŌJԂ
	Timer timer = null;//^C}[錾

	@Override
	public void onResume() {
	        super.onResume();
	    	Log.e("udp", "onResume!!!");
	    	//netڑmF
	    	/*permission.ACCESS_NETWORK_STATE*/
	    	cm =(ConnectivityManager)getSystemService(CONNECTIVITY_SERVICE);
	    	NetworkInfo info =cm.getActiveNetworkInfo();
	    	if(info == null){
	    		//ItC
	    		Toast toast = Toast.makeText(this, "lbg[NɐڑĂ܂\n",Toast.LENGTH_LONG);
				toast.setGravity(Gravity.CENTER, 0, 0);
				toast.show();
	    	//if(info.isConnected()){//IC}
	    	}
	    	
	    	try{ //socket@packet
	    		byte buf[] = new byte[256];
	    		socket = new DatagramSocket(16520);
	    		socket.setSoTimeout(5000);//^CAEg(~bP)
	    		packet = new DatagramPacket(buf, buf.length);
	    		Log.e("udp", "socketopen!!!");
	    	}catch(Exception e){Log.e("udp", "socketerror!!!"+ e);}
	    	
	    	//ݒroom:region:order擾
			allrecv = sp.getBoolean("allrecvcheck_key", true);
	    	setteiroom =sp.getString("roomtext_key", "1");//key,Ȃ̒l
			setteiregion =sp.getString("regiontext_key", "1");//key,Ȃ̒l
			setteiorder =sp.getString("ordertext_key", "1");//key,Ȃ̒l
			setteiscale = sp.getString("scalelist_key", "1.0");//key,Ȃ̒l
			Log.e("uecs","allrecv:"+ allrecv);
			Log.e("uecs","room:"+ setteiroom);
			Log.e("uecs","region:"+ setteiregion);
			Log.e("uecs","order:"+ setteiorder);
			Log.e("uecs","scale:"+ setteiscale);
	    	
	    	setContentView(new DrawSurfaceView(this));	
	    	//ԂɂĎŏresumeĂ΂B̂߁Aʕ\RRōsȂĂ
	    	//receive/parseJn
	    	
	   }
	   
	public void onPause() {
	        super.onPause();
	        Log.e("udp", "onPause!!!");
	        if(timer != null){
	            timer.cancel();    
	          }
	       socket.close();
	           Log.e("udp","socket::"+ socket);
	    }
		
	public void receive(){//receive&XMLparser
			   try{
		      	socket.receive(packet);
		      	CCM = new String(packet.getData(), 0, packet.getLength(),"UTF-8");
		      	Log.e("udp", "CCM:" + CCM);
		      	Log.e("udp", "IPAhX:" + packet.getAddress());
			   
			 //xmlparser
		    	parser.setInput(new StringReader(CCM));
		      	
		      	int eventtype = parser.getEventType();//^O
		      	while(eventtype != XmlPullParser.END_DOCUMENT){
		      		switch(eventtype){
		      			case XmlPullParser.START_TAG://Jntag
		      				Log.e("udp", "startTAG:" + parser.getName());
		      				
		      				int count = parser.getAttributeCount();//tag̑̐
		      				for(int i=0; i<count; i++){//̐JԂ
		      						String name = parser.getAttributeName(i);	
		      						String value = parser.getAttributeValue(i);
		      							Log.e("udp", "name:" + name);
		      							Log.e("udp", "value:" + value);
		      						//type:room:region:order:priority̒lĂ
		      						if(name.equals("type")){type = value;  
		      											ataihantei =1;//textǂݍ݂on(ȂƃeLXgȂLXgŃoO)
		      											}
		      						if(name.equals("room")){room = Integer.parseInt(value);}
		      						if(name.equals("region")){region = Integer.parseInt(value);}
		      						if(name.equals("order")){order = Integer.parseInt(value);}
		      						if(name.equals("priority")){priority = Integer.parseInt(value);}
		      				}
		      				Log.e("udp", "room:" + room +"region:" + region + "order:" + order);
		      			break;
		      			case XmlPullParser.TEXT://^OԂtext
		      				
		      				if(allrecv == true || room == Integer.parseInt(setteiroom) &&
			      					region == Integer.parseInt(setteiregion) && 
			      					order == Integer.parseInt(setteiorder)){
		      					//SMor@room:regio:norderSv
		      					filterpass = true;
		      				}else{filterpass = false; atai = null;}
		      				
		      				if(ataihantei == 1 && filterpass == true){
		      					 atai = Float.parseFloat(parser.getText());//lĂ
		      					Log.e("udp", "atai:" + atai);
		      					Log.e("udp", "text:" + parser.getText());
		      					ataihantei = 0;
		      				}
		      			break;
		      			//case XmlPullParser.END_TAG:
		      			//	Log.e("udp", "endTAG:" + parser.getName());
		      			//	break;
		      			default:
		      			break;
		      		}
		      	eventtype = parser.next();//tag
		      	
		      	}//xmlparser
		      	
		      	}catch(Exception e2){
		      		Log.e("udp", "receive/parseerror!!!"+ e2);
		      		Log.e("udp", "timeout"+ e2);}
		      	
		   }

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_main);
        //ݒʂ̂
        sp = PreferenceManager.getDefaultSharedPreferences(this);
	}

	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		// Inflate the menu; this adds items to the action bar if it is present.
		getMenuInflater().inflate(R.menu.main, menu);
		// Inflate the menu; this adds items to the action bar if it is present.
		//menu쐬
		setteimenu =menu.add(0 ,0, 0, "ݒ");//groupID,itemID,menu\,O
 //   	MenuInflater inflater = getMenuInflater() ;
 //   	inflater.inflate(R.layout.activity_main, menu);
		return true;
	}
    @Override
    public boolean onOptionsItemSelected(MenuItem item){
    	//nemuI
    	switch(item.getItemId()){
    		case 0://setteimenu
    			startActivity(new Intent(this,settei.class));
        /*xml <activity android:name=".settei"/>*/
    	
 //   	case R.id.menu_settings:
 //   		startActivity(new Intent(this,settei.class));
 
    	//return true;
    			break;    		
    	}
    	return false;
	}

 // SurfaceView`悷NX
class DrawSurfaceView extends SurfaceView implements SurfaceHolder.Callback{
	Float temp = null, humid = null, housa = null, CO2 = null, ppf = null;
	int vlen ;
	Paint paint = null;
	Paint paint2 = null;

    public DrawSurfaceView(Context context) {
        super(context);
        // RXgN^BSurfaceView`ɗpR[obNo^.
        getHolder().addCallback(this);
        // `p̏
        paint = new Paint();
        paint.setAntiAlias(true);
        paint.setTextSize(30);
        paint.setStrokeWidth(18);//̑
        paint2 = new Paint();
        paint2.setAntiAlias(true);
        paint2.setTextSize(24);
        
    }

    @Override
    public void surfaceChanged(SurfaceHolder holder, int format, int width,
            int height) {
    }

    @Override
    public void surfaceCreated(SurfaceHolder holder) {
        // SurfaceViewɌĂяo郁\bhB
    	timer = new Timer();//^C}[ionPauseŁjxjƍėp͕sȂ̂΂x
    	timer.scheduleAtFixedRate(new TimerTask(){
    		@Override
    		public void run() {
    			
    			receive();
    			
    			if(type.equals("InAirTemp.mIC")){//type]̕l
    				temp = atai;
                }if(type.equals("InAirRIHumid.mIC")){//type]̕l
                	humid = atai;
                }if(type.equals("InAirSatDef.mIC")){//type]̕l
                  	housa = atai;
                }if(type.equals("InPPF.mIC")){//type]̕l
                	ppf = atai;
                }if(type.equals("CO2Conc.mIC")){//type]̕l
                	CO2 = atai;
                }
    			
    			//for HAYASHImodel!!
    			if(type.equals("InAirTemp")){//type]̕l
               	 temp = atai;
                }if(type.equals("InAirHumid")){//type]̕l
               	 humid = atai;
                }if(type.equals("InAirSatDef")){//type]̕l
               	 housa = atai;
                }if(type.equals("InPPF")){//type]̕l
                 ppf = atai;
                }if(type.equals("InAirCO2")){//type]̕l
                 CO2 = atai;
                }//hayashi//
    			 Canvas canvas = getHolder().lockCanvas();//
    			 //`̓RRŁBsurfaceCreatedŏĂ_B
    			 
       			 //{ǉ
                 Log.e("uecs","scale:"+ setteiscale);
                 canvas.scale(1.0f, 1.0f); //TCYZbg˂Ă
                 if(setteiscale.equals("1.5")){
                	 canvas.scale(1.5f, 1.5f); // TCY1.5{
                 }if(setteiscale.equals("2.0")){
                	 canvas.scale(2.0f, 2.0f); // TCY2{
                 }if(setteiscale.equals("2.5")){
                	 canvas.scale(2.5f, 2.5f); // TCY2.5{
                 }if(setteiscale.equals("3.0")){
                	 canvas.scale(3.0f, 3.0f); // TCY3{
                 }if(setteiscale.equals("3.5")){
                	 canvas.scale(3.5f, 3.5f); // TCY3.5{
                 }

                 if (canvas != null)
                 {
                	 canvas.drawColor(Color.BLACK);//hԂ
                	
                	 paint.setColor(Color.WHITE);//
                	 canvas.drawText("O", 0, 370, paint);
                	 canvas.drawLine(60, 290, 60, 55, paint);
                	 canvas.drawLine(235, 290, 235, 55, paint);
                	 
                	 canvas.drawText("ʎq", 0, 410, paint);
                	 canvas.drawText("CO2Zx", 0, 450, paint);
                	 
                	 if(temp != null){canvas.drawText(Float.toString(temp), 25, 340, paint);}
                     else{canvas.drawText("--", 25, 340, paint); }
                     if(humid != null){canvas.drawText(Float.toString(humid), 200, 340, paint);}
                     else{canvas.drawText("--", 200, 340, paint);}
                      if(housa != null){
                    	  vlen = Float.toString(housa).length() ;
                    	  canvas.drawText(Float.toString(housa), 240-vlen*17, 370, paint);}
                     else{canvas.drawText("--", 125, 370, paint);}
                      if(ppf != null){
                    	  vlen = Float.toString(ppf).length() ;
                    	  canvas.drawText(Float.toString(ppf), 240-vlen*17, 410, paint);}
                     else{canvas.drawText("--", 125, 410, paint);} 
                      if( CO2!= null){
                       	  vlen = Float.toString(CO2).length() ;
                     	  canvas.drawText(Float.toString(CO2), 240-vlen*17, 450, paint);}
                     else{canvas.drawText("--", 135, 450, paint);}

                     
                	 paint.setColor(Color.RED);//Ԃ
                     canvas.drawText("x", 10, 30, paint);//uxv(0,35)̈ʒuɏ
                     canvas.drawCircle(60, 290, 24, paint);//xv
                     if(temp != null){
                     canvas.drawLine(60, 290, 60, 255-(4*temp), paint);//̂ߏIy-5
                     }
                     
                     paint.setColor(Color.BLUE);//
                     canvas.drawText("Ύx", 180, 30, paint);//uΎxv(175,35)̈ʒuɏ
                     canvas.drawCircle(235, 290, 24, paint);//xv
                     if(humid != null){
                     canvas.drawLine(235, 290, 235, 255-(2*humid), paint);
                     }
                  
                     paint2.setColor(Color.WHITE);//ŒPʏ
                     canvas.drawText("", 100, 340, paint2);
                     canvas.drawText("%", 275, 340, paint2);
                     canvas.drawText("g/kg'", 250, 370, paint2);
                     
                     canvas.drawText("mol", 250, 410, paint2);
                     canvas.drawText("ppm", 250, 450, paint2);
                     
                     //ڐ[[[[[
                     canvas.drawText("----0", 60, 260, paint2);
                     canvas.drawText("---10", 60, 220, paint2);
                     canvas.drawText("---20", 60, 180, paint2);
                     canvas.drawText("---30", 60, 140, paint2);
                     canvas.drawText("---40", 60, 100, paint2);
                     canvas.drawText("---50", 60, 60, paint2);
                     
                     canvas.drawText("----0", 235, 260, paint2);
                     canvas.drawText("---20", 235, 220, paint2);
                     canvas.drawText("---40", 235, 180, paint2);
                     canvas.drawText("---60", 235, 140, paint2);
                     canvas.drawText("---80", 235, 100, paint2);
                     canvas.drawText("--100", 235, 60, paint2);
                     
                     //YCCMȂ
                     if(temp == null && humid == null && housa == null && 
                    	ppf == null && CO2 == null){
                    	 canvas.drawColor(Color.BLACK);
                    	 paint.setColor(Color.WHITE);
                    	 canvas.drawText("YCCM", 10, 30, paint);
                    	 canvas.drawText("M܂B", 10, 60, paint);
               
                     }
                     
                     getHolder().unlockCanvasAndPost(canvas);//
                 } 
    			
    		}      
	      }, 0, INTERVAL_PERIOD);

    }

    @Override
    public void surfaceDestroyed(SurfaceHolder holder) {
    }
    
}

}
