/*
 * Decompiled with CFR 0.152.
 */
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import uecs1_00_E10_03.CCMDATA;

public class CCMDATASendTime
extends CCMDATA {
    public DecimalFormat df;
    public Calendar cal = GregorianCalendar.getInstance();
    public InetAddress address;
    public String ver = "1.00-E10";
    public String ip;
    private String name;
    private StringBuffer sendBuffer;
    private String footer = "</DATA></UECS>";
    private int sendBufferBaseLength;

    private void init() {
        this.df = new DecimalFormat();
        this.df.applyLocalizedPattern("#.###");
        try {
            this.address = InetAddress.getByName("255.255.255.255");
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        this.sendBuffer = new StringBuffer(256);
        this.setSendBuffer();
    }

    public CCMDATASendTime() {
        try {
            this.ip = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            this.ip = "127.0.0.1";
        }
        this.init();
    }

    public CCMDATASendTime(int room, int region, int order, int priority, String type, String name) {
        super(room, region, order, priority, type);
        this.name = name;
        this.init();
    }

    public void setAttribute(int room, int region, int order, int priority, String type) {
        this.room = room;
        this.region = region;
        this.order = order;
        this.priority = priority;
        this.type = type;
        this.setSendBuffer();
    }

    public boolean setAttribute(String room, String region, String order, String priority, String type) {
        int _room = this.room;
        int _region = this.region;
        int _order = this.order;
        int _priority = this.priority;
        boolean isSuccess = true;
        try {
            this.room = Integer.parseInt(room);
            this.region = Integer.parseInt(region);
            this.order = Integer.parseInt(order);
            this.priority = Integer.parseInt(priority);
            this.type = type;
            this.setSendBuffer();
        }
        catch (Exception e) {
            this.room = _room;
            this.order = _order;
            this.priority = _priority;
            this.region = _region;
            isSuccess = false;
        }
        return isSuccess;
    }

    public void setRoom(int _room) {
        this.room = _room;
        this.setSendBuffer();
    }

    public void setRegion(int _region) {
        this.region = _region;
        this.setSendBuffer();
    }

    public void setOrder(int _order) {
        this.order = _order;
        this.setSendBuffer();
    }

    public void setPriority(int _priority) {
        this.priority = _priority;
        this.setSendBuffer();
    }

    public void setType(String _type) {
        this.type = _type;
        this.setSendBuffer();
    }

    public String getStirngCCM() {
        this.sendBuffer.delete(this.sendBufferBaseLength, this.sendBuffer.length());
        this.sendBuffer.append(this.df.format(this.value));
        this.sendBuffer.append("</DATA><IP>" + this.ip + "</IP></UECS>");
        return this.sendBuffer.toString();
    }

    private void setSendBuffer() {
        this.sendBuffer.delete(0, this.sendBuffer.length());
        this.sendBuffer.append("<?xml version=\"1.0\"?><UECS " + this.ver + "><DATA type=\"" + this.type + "\" room=\"" + Integer.toString(this.room) + "\" region=\"" + Integer.toString(this.region) + "\" order=\"" + Integer.toString(this.order) + "\" priority=\"" + Integer.toString(this.priority) + "\">");
        this.sendBufferBaseLength = this.sendBuffer.length();
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }
}

