/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Stroke;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.CombinedRangeXYPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.dial.DialBackground;
import org.jfree.chart.plot.dial.DialCap;
import org.jfree.chart.plot.dial.DialFrame;
import org.jfree.chart.plot.dial.DialLayer;
import org.jfree.chart.plot.dial.DialPlot;
import org.jfree.chart.plot.dial.DialPointer;
import org.jfree.chart.plot.dial.DialScale;
import org.jfree.chart.plot.dial.DialTextAnnotation;
import org.jfree.chart.plot.dial.DialValueIndicator;
import org.jfree.chart.plot.dial.StandardDialFrame;
import org.jfree.chart.plot.dial.StandardDialScale;
import org.jfree.data.general.DefaultValueDataset;
import org.jfree.data.general.ValueDataset;

public class GraphDial {
    JFreeChart chart1;
    JFreeChart chart2;
    DialPlot dp;
    DialPlot dp2;
    CombinedRangeXYPlot mainplot;
    DefaultValueDataset dataset1;
    DefaultValueDataset dataset2;
    DefaultValueDataset dataset3;
    DefaultValueDataset dataset4;
    String title;
    String filename;

    public GraphDial(String _title, String _filename) {
        this.title = _title;
        this.filename = _filename;
        this.dataset1 = new DefaultValueDataset(0.0);
        this.dataset2 = new DefaultValueDataset(0.0);
        this.dp = new DialPlot();
        this.dp.setDataset(0, (ValueDataset)this.dataset1);
        this.dp.setDataset(1, (ValueDataset)this.dataset2);
        this.dp.setBackground((DialLayer)new DialBackground((Paint)Color.black));
        StandardDialFrame dialFrame = new StandardDialFrame();
        dialFrame.setBackgroundPaint((Paint)Color.lightGray);
        dialFrame.setStroke((Stroke)new BasicStroke(1.0f));
        this.dp.setDialFrame((DialFrame)dialFrame);
        DialCap cap = new DialCap();
        cap.setFillPaint((Paint)Color.DARK_GRAY);
        this.dp.setCap((DialLayer)cap);
        StandardDialScale temperatureScale = new StandardDialScale(0.0, 40.0, 240.0, -300.0, 10.0, 10);
        temperatureScale.setMinorTickPaint((Paint)Color.white);
        temperatureScale.setMajorTickPaint((Paint)Color.blue);
        temperatureScale.setTickLabelFont(new Font(null, 1, 15));
        temperatureScale.setTickLabelPaint((Paint)Color.white);
        temperatureScale.setTickLabelFormatter((NumberFormat)new DecimalFormat("#.#"));
        temperatureScale.setTickRadius(0.9);
        temperatureScale.setTickLabelOffset(0.15);
        this.dp.addScale(0, (DialScale)temperatureScale);
        this.dp.mapDatasetToScale(0, 0);
        DialPointer.Pin temperaturePointer = new DialPointer.Pin(0);
        temperaturePointer.setDatasetIndex(0);
        temperaturePointer.setPaint((Paint)Color.white);
        temperaturePointer.setRadius(0.85);
        this.dp.addPointer((DialPointer)temperaturePointer);
        DialTextAnnotation temperatureText = new DialTextAnnotation("Temperature");
        temperatureText.setFont(new Font(null, 1, 12));
        temperatureText.setPaint((Paint)Color.white);
        temperatureText.setRadius(0.7);
        this.dp.addLayer((DialLayer)temperatureText);
        DialValueIndicator temperatureIndicator = new DialValueIndicator(0);
        temperatureIndicator.setFont(new Font(null, 1, 14));
        temperatureIndicator.setNumberFormat((NumberFormat)new DecimalFormat("#.#"));
        temperatureIndicator.setRadius(0.85);
        temperatureIndicator.setPaint((Paint)Color.white);
        temperatureIndicator.setOutlinePaint((Paint)new Color(0, true));
        temperatureIndicator.setBackgroundPaint((Paint)new Color(0, true));
        this.dp.addLayer((DialLayer)temperatureIndicator);
        StandardDialScale humidityScale = new StandardDialScale(0.0, 100.0, 240.0, -300.0, 10.0, 10);
        humidityScale.setMajorTickPaint((Paint)Color.green);
        humidityScale.setMinorTickPaint((Paint)Color.green);
        humidityScale.setTickLabelFont(new Font(null, 1, 10));
        humidityScale.setTickLabelPaint((Paint)Color.green);
        humidityScale.setTickLabelFormatter((NumberFormat)new DecimalFormat("#.#"));
        humidityScale.setTickRadius(0.6);
        humidityScale.setTickLabelOffset(0.15);
        this.dp.addScale(1, (DialScale)humidityScale);
        this.dp.mapDatasetToScale(1, 1);
        DialPointer.Pin humidityPointer = new DialPointer.Pin(1);
        humidityPointer.setDatasetIndex(1);
        humidityPointer.setPaint((Paint)Color.green);
        humidityPointer.setRadius(0.55);
        this.dp.addPointer((DialPointer)humidityPointer);
        DialTextAnnotation humidityText = new DialTextAnnotation("RH");
        humidityText.setFont(new Font(null, 1, 12));
        humidityText.setPaint((Paint)Color.green);
        humidityText.setRadius(0.4);
        this.dp.addLayer((DialLayer)humidityText);
        DialValueIndicator humidityIndicator = new DialValueIndicator(1);
        humidityIndicator.setFont(new Font(null, 1, 14));
        humidityIndicator.setNumberFormat((NumberFormat)new DecimalFormat("#.#"));
        humidityIndicator.setRadius(0.55);
        humidityIndicator.setPaint((Paint)Color.green);
        humidityIndicator.setOutlinePaint((Paint)new Color(0, true));
        humidityIndicator.setBackgroundPaint((Paint)new Color(0, true));
        this.dp.addLayer((DialLayer)humidityIndicator);
        this.dialgraph2();
    }

    private void dialgraph2() {
        this.dp2 = new DialPlot();
        this.dataset3 = new DefaultValueDataset(0.0);
        this.dataset4 = new DefaultValueDataset(0.0);
        this.dp2.setDataset(0, (ValueDataset)this.dataset3);
        this.dp2.setDataset(1, (ValueDataset)this.dataset4);
        this.dp2.setBackground((DialLayer)new DialBackground((Paint)Color.black));
        StandardDialFrame dialFrame2 = new StandardDialFrame();
        dialFrame2.setBackgroundPaint((Paint)Color.lightGray);
        dialFrame2.setStroke((Stroke)new BasicStroke(1.0f));
        this.dp2.setDialFrame((DialFrame)dialFrame2);
        DialCap cap = new DialCap();
        cap.setFillPaint((Paint)Color.DARK_GRAY);
        this.dp2.setCap((DialLayer)cap);
        StandardDialScale vapDifScale = new StandardDialScale(0.0, 2.0, 240.0, -300.0, 0.1, 10);
        vapDifScale.setMinorTickPaint((Paint)Color.yellow);
        vapDifScale.setMajorTickPaint((Paint)Color.blue);
        vapDifScale.setTickLabelFont(new Font(null, 1, 12));
        vapDifScale.setTickLabelPaint((Paint)Color.yellow);
        vapDifScale.setTickLabelFormatter((NumberFormat)new DecimalFormat("#.##"));
        vapDifScale.setTickRadius(0.9);
        vapDifScale.setTickLabelOffset(0.15);
        this.dp2.addScale(0, (DialScale)vapDifScale);
        this.dp2.mapDatasetToScale(0, 0);
        DialPointer.Pin vapDifPointer = new DialPointer.Pin(0);
        vapDifPointer.setDatasetIndex(0);
        vapDifPointer.setPaint((Paint)Color.yellow);
        vapDifPointer.setRadius(0.85);
        this.dp2.addPointer((DialPointer)vapDifPointer);
        DialTextAnnotation vapDifText = new DialTextAnnotation("VaporDeficit");
        vapDifText.setFont(new Font(null, 1, 12));
        vapDifText.setPaint((Paint)Color.yellow);
        vapDifText.setRadius(0.7);
        this.dp2.addLayer((DialLayer)vapDifText);
        DialValueIndicator vapDifIndicator = new DialValueIndicator(0);
        vapDifIndicator.setFont(new Font(null, 1, 15));
        vapDifIndicator.setNumberFormat((NumberFormat)new DecimalFormat("#.##kPa"));
        vapDifIndicator.setRadius(0.85);
        vapDifIndicator.setPaint((Paint)Color.yellow);
        vapDifIndicator.setOutlinePaint((Paint)new Color(0, true));
        vapDifIndicator.setBackgroundPaint((Paint)new Color(0, true));
        this.dp2.addLayer((DialLayer)vapDifIndicator);
        StandardDialScale enthaScale = new StandardDialScale(30.0, 130.0, 240.0, -300.0, 10.0, 10);
        enthaScale.setMajorTickPaint((Paint)Color.pink);
        enthaScale.setMinorTickPaint((Paint)Color.pink);
        enthaScale.setTickLabelFont(new Font(null, 1, 10));
        enthaScale.setTickLabelPaint((Paint)Color.pink);
        enthaScale.setTickLabelFormatter((NumberFormat)new DecimalFormat("#"));
        enthaScale.setTickRadius(0.5);
        enthaScale.setTickLabelOffset(0.15);
        this.dp2.addScale(1, (DialScale)enthaScale);
        this.dp2.mapDatasetToScale(1, 1);
        DialPointer.Pin enthaPointer = new DialPointer.Pin(1);
        enthaPointer.setDatasetIndex(1);
        enthaPointer.setPaint((Paint)Color.pink);
        enthaPointer.setRadius(0.55);
        this.dp2.addPointer((DialPointer)enthaPointer);
        DialTextAnnotation enthaText = new DialTextAnnotation("Enthalpy");
        enthaText.setFont(new Font(null, 1, 12));
        enthaText.setPaint((Paint)Color.pink);
        enthaText.setRadius(0.4);
        this.dp2.addLayer((DialLayer)enthaText);
        DialValueIndicator enthaIndicator = new DialValueIndicator(1);
        enthaIndicator.setFont(new Font(null, 1, 14));
        enthaIndicator.setNumberFormat((NumberFormat)new DecimalFormat("#kJ/kg"));
        enthaIndicator.setRadius(0.55);
        enthaIndicator.setPaint((Paint)Color.pink);
        enthaIndicator.setOutlinePaint((Paint)new Color(0, true));
        enthaIndicator.setBackgroundPaint((Paint)new Color(0, true));
        this.dp2.addLayer((DialLayer)enthaIndicator);
    }

    public void setValue(double temperature, double rh) {
        this.dataset1.setValue((Number)temperature);
        this.dataset2.setValue((Number)rh);
        this.dp.setDataset(0, (ValueDataset)this.dataset1);
        this.dp.setDataset(1, (ValueDataset)this.dataset2);
        double satV = 6.1078 * Math.exp(17.2693882 * temperature / (temperature + 237.3));
        double vDif = satV * (100.0 - rh) / 1000.0;
        double vp = satV * rh / 1000.0;
        double aHumid = 6.22 * vp / (1013.25 - vp * 10.0);
        double entha = 1.005 * temperature + (2501.0 + 1.846 * temperature) * aHumid;
        this.dataset3.setValue((Number)vDif);
        this.dataset4.setValue((Number)entha);
        this.dp2.setDataset(0, (ValueDataset)this.dataset3);
        this.dp2.setDataset(1, (ValueDataset)this.dataset4);
        this.saveGraph();
    }

    private void saveGraph() {
        this.chart1 = new JFreeChart(String.valueOf(this.title) + "(1)", (Plot)this.dp);
        this.chart2 = new JFreeChart(String.valueOf(this.title) + "(2)", (Plot)this.dp2);
        try {
            ChartUtilities.saveChartAsPNG((File)new File(String.valueOf(this.filename) + "1.png"), (JFreeChart)this.chart1, (int)300, (int)300);
            ChartUtilities.saveChartAsPNG((File)new File(String.valueOf(this.filename) + "2.png"), (JFreeChart)this.chart2, (int)300, (int)300);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        String title = "title";
        GraphDial gd = new GraphDial(title, "kita");
        gd.setValue(23.5, 68.4);
    }
}

