/*
 * Decompiled with CFR 0.152.
 */
import java.awt.EventQueue;
import java.awt.HeadlessException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;

public class JTextAreaStdOut
extends JTextArea {
    private TextAreaOutputStream out;
    private final int MAX_LINES = 100;

    public JTextAreaStdOut() throws HeadlessException {
        this.setEditable(false);
        this.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                final Document doc = JTextAreaStdOut.this.getDocument();
                final Element root = doc.getDefaultRootElement();
                if (root.getElementCount() <= 100) {
                    return;
                }
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        this.removeLines(doc, root);
                    }
                });
                JTextAreaStdOut.this.setCaretPosition(doc.getLength());
            }

            private void removeLines(Document doc, Element root) {
                Element fl = root.getElement(0);
                try {
                    doc.remove(0, fl.getEndOffset());
                }
                catch (BadLocationException ble) {
                    ble.printStackTrace();
                }
            }
        });
        this.out = new TextAreaOutputStream(this);
        this.setToSystemOut();
        this.setToSystemErr();
    }

    public void setToSystemOut() {
        System.setOut(new PrintStream(this.getOut()));
    }

    public void setToSystemErr() {
        System.setErr(new PrintStream(this.getOut()));
    }

    public TextAreaOutputStream getOut() {
        return this.out;
    }

    public void flush() {
        this.append(this.out.toString());
        this.out.reset();
    }

    class TextAreaOutputStream
    extends ByteArrayOutputStream {
        private JTextAreaStdOut textarea;

        public TextAreaOutputStream(JTextAreaStdOut _textarea) {
            this.textarea = _textarea;
        }

        @Override
        public synchronized void write(byte[] b, int off, int len) {
            super.write(b, off, len);
            this.textarea.flush();
        }

        @Override
        public synchronized void write(int b) {
            super.write(b);
            this.textarea.flush();
        }

        @Override
        public void write(byte[] b) throws IOException {
            super.write(b);
            this.textarea.flush();
        }
    }
}

