/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ReadSendFile {
    SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    SimpleDateFormat sdf2 = new SimpleDateFormat("HH:mm:ss");
    DecimalFormat df = new DecimalFormat("#.###");
    ArrayList<CCMDATASendTime> oneTimeList = new ArrayList();
    ArrayList<CCMDATASendTime> routineList = new ArrayList();
    DocumentBuilder db;
    XPath xpath;
    File sendFile;
    Document doc;

    ReadSendFile(String file) {
        try {
            this.db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            this.xpath = XPathFactory.newInstance().newXPath();
            this.sendFile = new File(file);
            this.parseSendFile();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
    }

    public void parseSendFile() {
        block7: {
            if (this.sendFile.exists()) {
                UECSLoga_E10_201101.appendTextWithDate("\u9001\u4fe1\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u304c\u898b\u3064\u304b\u308a\u307e\u3057\u305f\uff0e");
                try {
                    this.doc = this.db.parse(this.sendFile);
                    XPathExpression expression = this.xpath.compile("ROOT/SEND_ONE_TIME");
                    if (this.parseSendOneTime((NodeList)expression.evaluate(this.doc, XPathConstants.NODESET))) {
                        this.appendUECSLoga("\u9001\u4fe1\uff08\u4e00\u56de\uff09\u306e\u89e3\u6790\u306f\u6b63\u5e38\u306b\u7d42\u4e86\u3057\u307e\u3057\u305f\uff0e");
                    } else {
                        this.appendUECSLoga("\u9001\u4fe1\uff08\u4e00\u56de\uff09\u306e\u89e3\u6790\u306b\u5931\u6557\u3057\u307e\u3057\u305f\uff0e");
                    }
                    expression = this.xpath.compile("ROOT/SEND_ROUTINE");
                    if (this.parseSendRoutine((NodeList)expression.evaluate(this.doc, XPathConstants.NODESET))) {
                        this.appendUECSLoga("\u9001\u4fe1\uff08\u30eb\u30fc\u30c1\u30f3\uff09\u306e\u89e3\u6790\u306f\u6b63\u5e38\u306b\u7d42\u4e86\u3057\u307e\u3057\u305f\uff0e");
                        break block7;
                    }
                    this.appendUECSLoga("\u9001\u4fe1\uff08\u30eb\u30fc\u30c1\u30f3\uff09\u306e\u89e3\u6790\u306b\u5931\u6557\u3057\u307e\u3057\u305f\uff0e");
                }
                catch (Exception exception) {}
            } else {
                UECSLoga_E10_201101.appendTextWithDate("\u9001\u4fe1\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f\uff0e\u30b9\u30b1\u30b8\u30e5\u30fc\u30eb\u9001\u4fe1\u306f\u884c\u3044\u307e\u305b\u3093\uff0e");
            }
        }
    }

    private boolean parseSendRoutine(NodeList nodelist) {
        boolean success = true;
        XPathExpression _expression = null;
        try {
            _expression = this.xpath.compile("./DATA");
        }
        catch (XPathExpressionException e1) {
            e1.printStackTrace();
        }
        int i = 0;
        while (i < nodelist.getLength()) {
            Calendar calendar = GregorianCalendar.getInstance();
            calendar.setLenient(false);
            try {
                calendar.set(11, Integer.parseInt(this.xpath.evaluate("@hour", (Element)nodelist.item(i))));
                calendar.set(12, Integer.parseInt(this.xpath.evaluate("@minute", (Element)nodelist.item(i))));
                calendar.set(13, 0);
                if (_expression != null) {
                    if (this.parseData((NodeList)_expression.evaluate(nodelist.item(i), XPathConstants.NODESET), calendar, this.routineList, this.sdf2)) {
                        this.appendUECSLoga("\u9001\u4fe1\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u4e2d\uff08\u6bce\u65e5\u5b9a\u6642\u9001\u4fe1\uff09" + this.sdf2.format(calendar.getTime()) + "\u306e\u89e3\u6790\u306f\u6b63\u5e38\u306b\u7d42\u4e86\u3057\u307e\u3057\u305f\uff0e");
                    } else {
                        this.appendUECSLoga("\u9001\u4fe1\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u4e2d\uff08\u6bce\u65e5\u5b9a\u6642\u9001\u4fe1\uff09" + this.sdf2.format(calendar.getTime()) + "\u306e\u89e3\u6790\u306b\u5931\u6557\u3057\u307e\u3057\u305f\uff0e");
                        success = false;
                    }
                } else {
                    success = false;
                    this.appendUECSLoga("\u9001\u4fe1\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u4e2d\uff08\u6bce\u65e5\u5b9a\u6642\u9001\u4fe1\uff09DATA\u30bf\u30b0" + Integer.toString(i + 1) + "\u756a\u76ee\u306e\u8a2d\u5b9a\u3067\u69cb\u6587\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\uff0e");
                }
            }
            catch (NumberFormatException e) {
                this.appendUECSLoga("\u9001\u4fe1\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u4e2d\uff08\u6bce\u65e5\u5b9a\u6642\u9001\u4fe1\uff09DATA\u30bf\u30b0" + Integer.toString(i + 1) + "\u756a\u76ee\u306e\u8a2d\u5b9a\u306b\u8aa4\u308a\u304c\u3042\u308a\u307e\u3059\uff0e");
                success = false;
            }
            catch (IllegalArgumentException e) {
                this.appendUECSLoga("\u9001\u4fe1\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u4e2d\uff08\u6bce\u65e5\u5b9a\u6642\u9001\u4fe1\uff09DATA\u30bf\u30b0" + Integer.toString(i + 1) + "\u756a\u76ee\u306e\u65e5\u4ed8\u306e\u8a2d\u5b9a\u306b\u8aa4\u308a\u304c\u3042\u308a\u307e\u3059\uff0e");
                success = false;
            }
            catch (XPathExpressionException e) {
                this.appendUECSLoga("\u9001\u4fe1\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u4e2d\uff08\u6bce\u65e5\u5b9a\u6642\u9001\u4fe1\uff09DATA\u30bf\u30b0" + Integer.toString(i + 1) + "\u756a\u76ee\u306e\u8a2d\u5b9a\u306b\u8aa4\u308a\u304c\u3042\u308a\u307e\u3059\uff0e");
                success = false;
            }
            ++i;
        }
        return success;
    }

    private boolean parseSendOneTime(NodeList nodelist) {
        boolean success = true;
        XPathExpression _expression = null;
        try {
            _expression = this.xpath.compile("./DATA");
        }
        catch (XPathExpressionException e1) {
            e1.printStackTrace();
        }
        Calendar nowCal = GregorianCalendar.getInstance();
        int i = 0;
        while (i < nodelist.getLength()) {
            Calendar calendar = GregorianCalendar.getInstance();
            calendar.setLenient(false);
            try {
                calendar.set(Integer.parseInt(this.xpath.evaluate("@year", (Element)nodelist.item(i))), Integer.parseInt(this.xpath.evaluate("@month", (Element)nodelist.item(i))) - 1, Integer.parseInt(this.xpath.evaluate("@day", (Element)nodelist.item(i))), Integer.parseInt(this.xpath.evaluate("@hour", (Element)nodelist.item(i))), Integer.parseInt(this.xpath.evaluate("@minute", (Element)nodelist.item(i))), 0);
                if (calendar.getTimeInMillis() > nowCal.getTimeInMillis()) {
                    if (_expression != null) {
                        if (this.parseData((NodeList)_expression.evaluate(nodelist.item(i), XPathConstants.NODESET), calendar, this.oneTimeList, this.sdf)) {
                            this.appendUECSLoga("\u9001\u4fe1\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u4e2d\uff081\u56de\u9001\u4fe1\uff09" + this.sdf.format(calendar.getTime()) + "\u306e\u89e3\u6790\u306f\u6b63\u5e38\u306b\u7d42\u4e86\u3057\u307e\u3057\u305f\uff0e");
                        } else {
                            this.appendUECSLoga("\u9001\u4fe1\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u4e2d\uff081\u56de\u9001\u4fe1\uff09" + this.sdf.format(calendar.getTime()) + "\u306e\u89e3\u6790\u306b\u5931\u6557\u3057\u307e\u3057\u305f\uff0e");
                            success = false;
                        }
                    } else {
                        success = false;
                        this.appendUECSLoga("\u9001\u4fe1\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u4e2d\uff081\u56de\u9001\u4fe1\uff09DATA\u30bf\u30b0" + Integer.toString(i + 1) + "\u756a\u76ee\u306e\u8a2d\u5b9a\u3067\u69cb\u6587\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\uff0e");
                    }
                } else {
                    success = true;
                    this.appendUECSLoga("\u9001\u4fe1\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u4e2d\uff081\u56de\u9001\u4fe1\uff09DATA\u30bf\u30b0" + Integer.toString(i + 1) + "\u756a\u76ee\u306e\u65e5\u4ed8\u304c\u904e\u53bb\u3092\u6307\u3057\u3066\u3044\u307e\u3059\u3002\u9001\u4fe1\u306f\u884c\u308f\u308c\u307e\u305b\u3093\u3002");
                }
            }
            catch (NumberFormatException e) {
                this.appendUECSLoga("\u9001\u4fe1\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u4e2d\uff081\u56de\u9001\u4fe1\uff09DATA\u30bf\u30b0" + Integer.toString(i + 1) + "\u756a\u76ee\u306e\u8a2d\u5b9a\u306b\u8aa4\u308a\u304c\u3042\u308a\u307e\u3059\uff0e");
                success = false;
            }
            catch (IllegalArgumentException e) {
                this.appendUECSLoga("\u9001\u4fe1\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u4e2d\uff081\u56de\u9001\u4fe1\uff09DATA\u30bf\u30b0" + Integer.toString(i + 1) + "\u756a\u76ee\u306e\u65e5\u4ed8\u306e\u8a2d\u5b9a\u306b\u8aa4\u308a\u304c\u3042\u308a\u307e\u3059\uff0e");
                success = false;
            }
            catch (XPathExpressionException e) {
                this.appendUECSLoga("\u9001\u4fe1\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u4e2d\uff081\u56de\u9001\u4fe1\uff09DATA\u30bf\u30b0" + Integer.toString(i + 1) + "\u756a\u76ee\u306e\u8a2d\u5b9a\u306b\u8aa4\u308a\u304c\u3042\u308a\u307e\u3059\uff0e");
                success = false;
            }
            ++i;
        }
        return success;
    }

    private boolean parseData(NodeList nodelist, Calendar calendar, ArrayList<CCMDATASendTime> list, SimpleDateFormat sd) {
        boolean success = true;
        int room = 0;
        int region = 0;
        int order = 0;
        int priority = 29;
        double value = 0.0;
        String type = "";
        String name = "";
        try {
            int i = 0;
            while (i < nodelist.getLength()) {
                name = this.xpath.evaluate("@name", (Element)nodelist.item(i));
                type = this.xpath.evaluate("@type", (Element)nodelist.item(i));
                room = Integer.parseInt(this.xpath.evaluate("@room", (Element)nodelist.item(i)));
                region = Integer.parseInt(this.xpath.evaluate("@region", (Element)nodelist.item(i)));
                order = Integer.parseInt(this.xpath.evaluate("@order", (Element)nodelist.item(i)));
                priority = Integer.parseInt(this.xpath.evaluate("@priority", (Element)nodelist.item(i)));
                value = Double.parseDouble(this.xpath.evaluate("./text()", (Element)nodelist.item(i)));
                CCMDATASendTime ccm = new CCMDATASendTime(room, region, order, priority, type, name);
                ccm.value = value;
                ccm.cal.setTimeInMillis(calendar.getTimeInMillis());
                this.appendUECSLoga("\u9001\u4fe1\u4e88\u7d04\u3057\u307e\u3057\u305f <DATA type=\"" + type + "\" room=\"" + Integer.toString(room) + "\" region=\"" + Integer.toString(region) + "\" order=\"" + Integer.toString(order) + "\" priority=" + Integer.toString(priority) + "\">" + this.df.format(value) + "</DATA> (\u9001\u4fe1\u65e5\u6642:" + sd.format(calendar.getTime()) + ")");
                list.add(ccm);
                ++i;
            }
        }
        catch (XPathExpressionException e) {
            this.appendUECSLoga("\u9001\u4fe1\u767b\u9332CCM\u306e\u89e3\u6790\u4e2d\u306b\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u306e\u8a18\u8f09\u65b9\u6cd5\u306e\u554f\u984c\u304c\u898b\u3064\u304b\u308a\u307e\u3057\u305f\uff0e");
            success = false;
        }
        catch (NumberFormatException e) {
            this.appendUECSLoga("\u9001\u4fe1\u767b\u9332CCM\u306e\u89e3\u6790\u4e2d\u306b\u6570\u5b57\u304c\u8981\u6c42\u3055\u308c\u3066\u3044\u308b\u7b87\u6240\u306b\u4e0d\u9069\u5207\u306a\u8a18\u8f09\u304c\u898b\u3064\u304b\u308a\u307e\u3057\u305f\uff0e");
            success = false;
        }
        catch (Exception e) {
            this.appendUECSLoga("\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u306e\u9001\u4fe1\u767b\u9332CCM\u306e\u89e3\u6790\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\uff0e");
            success = false;
        }
        return success;
    }

    private void appendUECSLoga(String str) {
        UECSLoga_E10_201101.appendTextWithDate(str);
    }
}

