/*
 * Decompiled with CFR 0.152.
 */
package uecs1_00_E10_03;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Timer;
import java.util.TimerTask;
import uecs1_00_E10_03.CCMDATARecE10;
import uecs1_00_E10_03.CCMDATASendE10;
import uecs1_00_E10_03.UserMap;

public class UECS_Manager {
    public boolean recsuccess;
    public boolean sendsuccess;
    private DatagramSocket socket = null;
    private DatagramPacket recPacket;
    private DatagramPacket sendPacket = null;
    private char[] tempchar = new char[256];
    private Timer timer;
    private TaskTimer taskTimer;
    private CCMDATARecE10 tempdata;
    private CCMDATARecE10 temprecdata;
    private StringBuffer strbuf;
    private final String space = " ";
    private final String kai_n = "\n";
    private final String kai_r = "\r";
    public long timer_interval_ms = 10000L;
    public UserMap myData = new UserMap();

    public UECS_Manager() throws SocketException {
        this.recPacket = new DatagramPacket(new byte[256], 256);
        try {
            this.sendPacket = new DatagramPacket(new byte[256], 256, InetAddress.getByName("255.255.255.255"), 16520);
        }
        catch (UnknownHostException e1) {
            e1.printStackTrace();
        }
        this.socket = new DatagramSocket(16520);
        this.socket.setSoTimeout(1000);
        this.timer = new Timer();
        this.taskTimer = new TaskTimer();
        this.tempdata = new CCMDATARecE10();
        this.temprecdata = new CCMDATARecE10();
        this.strbuf = new StringBuffer(512);
    }

    public final void intervalTimerStart() {
        Calendar cal = GregorianCalendar.getInstance();
        cal.add(13, 2);
        cal.set(14, 0);
        this.timer.scheduleAtFixedRate((TimerTask)this.taskTimer, cal.getTime(), this.timer_interval_ms);
    }

    public void task() {
    }

    public final void run() {
        while (true) {
            try {
                this.socket.receive(this.recPacket);
                this.recsuccess = true;
            }
            catch (SocketTimeoutException socketTimeoutException) {
            }
            catch (IOException e) {
                this.recsuccess = false;
            }
            int strsize = this.strbuf.length();
            int i = 0;
            while (i < 256) {
                this.tempchar[i] = (char)this.recPacket.getData()[i];
                ++i;
            }
            this.strbuf.append(this.tempchar);
            this.strbuf.delete(0, strsize);
            if (this.parseRecDATA(this.strbuf, this.tempdata)) {
                this.tempdata.address = this.recPacket.getAddress();
                if (this.myData.recCCM.containsValue(this.tempdata)) {
                    this.myData.recCCM.get((Object)this.myData.recCCMKey.get((Object)this.tempdata)).lastrec = this.tempdata.lastrec;
                    this.myData.recCCM.get((Object)this.myData.recCCMKey.get((Object)this.tempdata)).value = this.tempdata.value;
                    this.myData.recCCM.get((Object)this.myData.recCCMKey.get((Object)this.tempdata)).address = this.tempdata.address;
                    this.myData.recCCM.get((Object)this.myData.recCCMKey.get((Object)this.tempdata)).ip = this.tempdata.ip;
                    this.myData.recCCM.get((Object)this.myData.recCCMKey.get((Object)this.tempdata)).ver = this.tempdata.ver;
                } else {
                    boolean match = false;
                    for (CCMDATARecE10 this.temprecdata : this.myData.unKnownCCM) {
                        if (!this.temprecdata.equals(this.tempdata)) continue;
                        this.temprecdata.value = this.tempdata.value;
                        this.temprecdata.lastrec = this.tempdata.lastrec;
                        this.temprecdata.address = this.tempdata.address;
                        this.temprecdata.ip = this.tempdata.ip;
                        this.temprecdata.ver = this.tempdata.ver;
                        match = true;
                    }
                    if (!match) {
                        CCMDATARecE10 newrec = new CCMDATARecE10(this.tempdata.room, this.tempdata.region, this.tempdata.order, this.tempdata.priority, this.tempdata.type);
                        newrec.value = this.tempdata.value;
                        newrec.lastrec = this.tempdata.lastrec;
                        newrec.address = this.tempdata.address;
                        newrec.ip = this.tempdata.ip;
                        newrec.ver = this.tempdata.ver;
                        this.myData.unKnownCCM.add(newrec);
                    }
                }
            }
            this.everyRecPacketTask();
            if (!this.taskTimer.flagtask) continue;
            this.pretreatment();
            this.task();
            this.taskTimer.flagtask = false;
        }
    }

    public void everyRecPacketTask() {
    }

    public boolean parseRecDATA(StringBuffer tempStr, CCMDATARecE10 tempccm) {
        boolean noVersion = false;
        boolean isSuccess = true;
        int FIRST_CCM_INDEX = 24;
        int VER_CCM_INDEX = 30;
        int room = 0;
        int region = 0;
        int order = 0;
        int priority = 0;
        double value = 0.0;
        String type = "";
        String ver = "";
        String ip = "";
        try {
            int temp;
            while ((temp = tempStr.indexOf(" ")) >= 0) {
                tempStr.deleteCharAt(temp);
            }
            while ((temp = tempStr.indexOf("\n")) >= 0) {
                tempStr.deleteCharAt(temp);
            }
            while ((temp = tempStr.indexOf("\r")) >= 0) {
                tempStr.deleteCharAt(temp);
            }
            if (tempStr.indexOf("<?xmlversion=\"1.0\"?><UECS") == 0) {
                int last = tempStr.indexOf(">", 24);
                if (last == 25) {
                    noVersion = true;
                } else {
                    int verIndex = tempStr.indexOf("ver=\"", 24);
                    int verLastIndex = tempStr.indexOf("\"", 30);
                    if (verIndex == 25 && verLastIndex < last) {
                        ver = tempStr.substring(30, verLastIndex);
                    } else {
                        isSuccess = false;
                    }
                }
            } else {
                isSuccess = false;
            }
            int dataIndex = tempStr.indexOf("<DATA");
            int dataLastIndex = tempStr.indexOf("</DATA>");
            if (isSuccess && dataIndex > 0 && dataLastIndex > dataIndex) {
                temp = tempStr.indexOf("room=\"");
                if (temp > dataIndex && dataLastIndex > temp) {
                    room = Integer.parseInt(tempStr.substring(temp + 6, tempStr.indexOf("\"", temp + 6)));
                } else if (temp == -1) {
                    room = 0;
                } else {
                    isSuccess = false;
                }
                temp = tempStr.indexOf("type=\"");
                if (isSuccess && temp > dataIndex && dataLastIndex > temp) {
                    type = tempStr.substring(temp + 6, tempStr.indexOf("\"", temp + 6));
                } else {
                    isSuccess = false;
                }
                temp = tempStr.indexOf("region=\"");
                if (isSuccess && temp > dataIndex && dataLastIndex > temp) {
                    region = Integer.parseInt(tempStr.substring(temp + 8, tempStr.indexOf("\"", temp + 8)));
                } else if (temp == -1) {
                    region = 0;
                } else {
                    isSuccess = false;
                }
                temp = tempStr.indexOf("order=\"");
                if (isSuccess && temp > dataIndex && dataLastIndex > temp) {
                    order = Integer.parseInt(tempStr.substring(temp + 7, tempStr.indexOf("\"", temp + 7)));
                } else if (temp == -1) {
                    order = 0;
                } else {
                    isSuccess = false;
                }
                temp = tempStr.indexOf("priority=\"");
                if (isSuccess && temp > dataIndex && dataLastIndex > temp) {
                    priority = Integer.parseInt(tempStr.substring(temp + 10, tempStr.indexOf("\"", temp + 10)));
                } else if (temp == -1) {
                    priority = 0;
                } else {
                    isSuccess = false;
                }
                if (isSuccess) {
                    int dataTagLastIndex = tempStr.indexOf(">", dataIndex);
                    value = Double.parseDouble(tempStr.substring(dataTagLastIndex + 1, dataLastIndex));
                } else {
                    isSuccess = false;
                }
            } else {
                isSuccess = false;
            }
            if (noVersion) {
                tempccm.ip = "none";
                tempccm.setAttribute(room, region, order, priority, type);
                tempccm.ver = ver;
                tempccm.value = value;
                tempccm.lastrec = System.currentTimeMillis();
            } else if (isSuccess) {
                int ipIndex = tempStr.indexOf("<IP>");
                int ipLastIndex = tempStr.indexOf("</IP>");
                ip = ipIndex > 0 && ipLastIndex > ipIndex ? tempStr.substring(ipIndex + 4, ipLastIndex) : "none";
                tempccm.ip = ip;
                tempccm.setAttribute(room, region, order, priority, type);
                tempccm.ver = ver;
                tempccm.value = value;
                tempccm.lastrec = System.currentTimeMillis();
            } else {
                isSuccess = false;
            }
        }
        catch (Exception e) {
            isSuccess = false;
        }
        return isSuccess;
    }

    private void makePacket(CCMDATASendE10 cds, DatagramPacket packet) {
        packet.setData(cds.getStirngCCM().getBytes());
        packet.setAddress(cds.address);
    }

    private void pretreatment() {
        long nowtime = System.currentTimeMillis();
        for (String temprec : this.myData.recCCM.keySet()) {
            this.myData.recCCM.get((Object)temprec).validity = nowtime - this.myData.recCCM.get((Object)temprec).valid_mSec < this.myData.recCCM.get((Object)temprec).lastrec;
        }
        for (CCMDATARecE10 this.temprecdata : this.myData.unKnownCCM) {
            this.temprecdata.validity = nowtime - this.temprecdata.valid_mSec < this.temprecdata.lastrec;
        }
    }

    public final void sendPacket() throws IOException {
        for (String temprec : this.myData.sendCCM.keySet()) {
            if (this.myData.sendCCM.get((Object)temprec).isSend) {
                this.makePacket(this.myData.sendCCM.get(temprec), this.sendPacket);
                this.socket.send(this.sendPacket);
            }
            this.myData.sendCCM.get((Object)temprec).isSend = false;
        }
    }

    private class TaskTimer
    extends TimerTask {
        boolean flagtask = false;

        private TaskTimer() {
        }

        public void run() {
            this.flagtask = true;
        }
    }
}

