/*
 UECS tiny inside climate measurement node for Arduino
 Programmed By Takehiko Hoshi 
 created
 2011.10.13 v.1
 some modifications
 2011.10.14 v.2
 for SH7x sir temp. and humid. sensor
 2011.12.12 v.3
fixed some bugs
 2012.1.22 v.3.1
Added Web tyny server
 2013.8.12 v.4
Revised for IDE 1.7.8 after and applied humid sensor lib.
 2015.12.3 V.4.1
*/

#include <SPI.h>         // needed for Arduino versions later than 0018
#include <Ethernet.h>
#include <EthernetUdp.h>         // UDP library from: bjoern@cs.stanford.edu 12/30/2008
#include <stdio.h>       // for sprintf()
#include <string.h>
#include <Sensirion.h>

// Enter a MAC address, IP address and port number for your controller below.
byte mac[] = { 0x90, 0xA2, 0xDA, 0x0E, 0x0F, 0x0D } ;
IPAddress ip(192,168,11,123) ; // My IP address
IPAddress dnServer(192, 168, 11, 1) ;
IPAddress gateway(192, 168, 11, 1) ;
IPAddress subnet(255, 255, 255, 0) ;
unsigned int localPort = 16520 ;      // local port to listen on
IPAddress remoteIP(255,255,255,255) ; // Remote IP address
unsigned int remotePort = 16520 ;      // remote port to send

// An EthernetUDP instance to let us send and receive packets over UDP
EthernetUDP Udp;

// UECS-CCM skeltons for sending
const char uecsCCM1[] = "<?xml version=\"1.0\"?><UECS><DATA type=\"" ;
const char uecsCCM2[] = "\" room=\"1\" region=\"1\" order=\"1\" priority=\"30\">" ;
const char uecsCCM3[] = "</DATA></UECS>" ;

// define analog input pins
const int sPPF = 2 ;  // conc. of CO2 gas sensor
const int sCO2 = 3 ;  // tiny PPF sensor

// define digital port for SHT1x 7x device
int dataPin = 8 ;  // sensor data (pulled up 10 k-Ohm)
int clockPin = 9 ;  // sensor clock
Sensirion tempSensor = Sensirion(dataPin, clockPin);
float temp, humid, dewp ;


// define valiables (for main function)
double inAirTemp = 0;  // inside air temperature
double inAirHumid = 0 ; // inside relative humidity
double inPPF = 0 ; // inside PPF
double inAirCO2 = 0 ; // concentration of CO2 gas
double inAirAbHumid = 0 ; // absolute humidity
double inAirSatDef = 0 ; // saturation deficit
double inAirDewPoint = 0 ; // dew point temp.

// define valiables (for inside working)
double measV = 0;  // measured voltage (mV)
// previous start time for next measurement timing (milliseconds)
unsigned long ptime = 0 ;

double AnaMeas(int ch) {
  // averaging three times of analog measurement
  double sum = 0 ;
  analogRead(ch) ; // warm up
  delay(1) ;
  sum = (double)analogRead(ch) ;
  sum = sum +  (double)analogRead(ch) ;
  sum = sum +  (double)analogRead(ch) ;
  sum = sum / 3 ; // average of meas value
  return sum ;  
}

char *ftoa(char *a, double f, int precision) {
  // string output from floating point valiable (instead of %.nf function of printf())
  long p[] = {
    1,10,100,1000,10000,100000,1000000,10000000,100000000  };  
  int i ;
  int j = 0 ;
  char *ret = a ;
  char work[10] = "" ;
  char *wp = work ;
  long heiltal = (long)f ;
  itoa(heiltal, a, 10) ;
  if((precision > 0)&&(precision < 9)) {
    while(*a != '\0') a++ ;
    *a++ = '.' ;
    long desimal = abs((long)((f - heiltal) * p[precision])) ;
    itoa(desimal, work, 10) ;
    while(*wp++ != '\0') j++ ;
    for(i = 0; i < (precision - j); i++)  *a++ = '0' ;
    itoa(desimal, a, 10) ;
  }
  return ret;
}

double CalcAH(double t, double rh) {
  // Obtain absolute humidity at air temperature(t) and relative humidity (rh)
  double a1,a2,a3,a4,a5,a6,b1,b2,b3,e0,atc,atemp,ps,es,ep,ah ;
  // constants
  a1 = 10.79574 ;
  a2 = -5.028 ;
  a3 = 1.50475e-4 ;
  a4 = -8.2969 ;
  a5 = 0.42873e-3 ;
  a6 = 4.76955 ;
  b1 = -9.09685 ;
  b2 = -3.56654 ;
  b3 = 0.87682 ;
  e0 = 4.581 ;
  atc = 273.15 ;
  atemp = atc + t ;
  // icing case division by air temperature
  if(t >= 0) {
    ps = a1 * (1.0 - atc / atemp) + a2 * log10(atemp / atc)
      + a3 * (1.0 - pow(10.0, a4 * (atemp / atc - 1.0)))
        + a5 * (pow(10.0, a6 * (1.0 - atc / atemp)) - 1.0)
          + log10(e0) ;
  }
  else {
    ps = b1 * (atc / atemp - 1.0) + b2 * log10(atc / atemp)
      + b3 * (1.0 - atc / atemp) + log10(e0) ;
  }
  // get saturated vapour pressure mmHg
  es = pow(10.0, ps) ;
  // get vapour pressior part by relative humidity
  ep = es * rh / 100.0 ;
  // get saturated absoulte humidity  g kg'-1
  ah = (0.622 * ep / (760.0 - ep) * 1000.0) ;
  return ah ;    
}

// Initialize the Ethernet server library
// with the IP address and port you want to use
// (port 80 is default for HTTP):
EthernetServer server(80);

void setup() {
  // start the Ethernet and UDP:
  Ethernet.begin(mac,ip,dnServer,gateway,subnet);
  Udp.begin(localPort);
  server.begin();
}

void uecsOut(char *typeName, double value, int dgt) {
  // output UDP packet with UECS-CCM tiny format 

    // buffer declear
  char valueBuf[16] ;
  char sendBuf[384] ;

  ftoa(valueBuf, value, dgt) ;
  // send UECS-CCM UDP packet
  sprintf(sendBuf,"%s%s%s%s%s",uecsCCM1,typeName,uecsCCM2,valueBuf,uecsCCM3) ;

  Udp.beginPacket(remoteIP, remotePort);
  Udp.write(sendBuf);
  Udp.endPacket();
}

void loop() {
  char sendBuf[16];
  // listen for incoming clients
  EthernetClient client = server.available();
  if (client) {
    boolean currentLineIsBlank = true;
    while (client.connected()) {
      if (client.available()) {
        char c = client.read();
        // if you've gotten to the end of the line (received a newline
        // character) and the line is blank, the http request has ended,
        // so you can send a reply
        if (c == '\n' && currentLineIsBlank) {
          // send a standard http response header
          client.println("HTTP/1.1 200 OK");
          client.println("Content-Type: text/html");
          client.println("Connection: close");  // the connection will be closed after completion of the response
          client.println("Refresh: 60");  // refresh the page automatically every 60 sec
          client.println();
          client.println("<!DOCTYPE HTML>");
          client.println("<html>");
          client.print("<HEAD><TITLE>UECS arduino climate node</TITLE></HEAD><BODY>");
          client.print("<HR><H1>UECS climate report</H1><HR>Air Temperature: ");
          ftoa(sendBuf, (double)inAirTemp, 1);
          client.print(sendBuf);
          client.print(" C<BR />Relative Humidity: ");
          ftoa(sendBuf, (double)inAirHumid, 0);
          client.print(sendBuf);
          client.print(" %<BR />Absolute Humidity: ");
          ftoa(sendBuf, inAirAbHumid, 2);
          client.print(sendBuf);
          client.print(" gV./kgD.A.<BR />Saturation Deficit: ");
          ftoa(sendBuf, inAirSatDef, 2);
          client.print(sendBuf);
          client.print(" gV./kgD.A.<BR />Dew Point Temperature: ");
          ftoa(sendBuf, inAirDewPoint, 1);
          client.print(sendBuf);
          client.print(" C<BR />Carbon Dioxide (CO2) Gas: ");
          ftoa(sendBuf, inAirCO2, 0);
          client.print(sendBuf);
          client.print(" ppm<BR>Photosynthesis Photon Flux (PPF): ");
          ftoa(sendBuf, inPPF, 1);
          client.print(sendBuf);
          client.print(" umol/m2/s<BR><HR></BODY>");
          client.println("</html>");
          break;
        }
        if (c == '\n') {
          // you're starting a new line
          currentLineIsBlank = true;
        }
        else if (c != '\r') {
          // you've gotten a character on the current line
          currentLineIsBlank = false;
        }
      }
    }
    // give the web browser time to receive the data
    delay(1);
    // close the connection:
    client.stop();
  }

  // measuremet and output of inside air temp.
  tempSensor.measure(&temp, &humid, &dewp);
  inAirTemp = (double)temp ;
  uecsOut("InAirTemp", inAirTemp, 1) ;

  // measuremet and output of inside relative humid.
  inAirHumid = (double)humid ; 
  uecsOut("InAirHumid", inAirHumid, 0) ;

  // measuremet and output of PPF
  measV =  AnaMeas(sPPF) * 5000 / 1024 ;            
  inPPF = (( -9.6918e-08 * measV + 1.3569e-04) * measV + 1.0691) * measV ;
  if(inPPF < 0) inPPF = 0 ;
  uecsOut("InPPF", inPPF, 1) ;

  // measuremet and output of CO2 conc.
  measV =  AnaMeas(sCO2) * 5000 / 1024 ;            
  inAirCO2 = measV / 2 ; 
  uecsOut("InAirCO2", inAirCO2, 0) ;

  // calculate absolute humidity unit: g kg'-1
  inAirAbHumid = CalcAH(inAirTemp, inAirHumid) ;
  uecsOut("InAirAbHumid", inAirAbHumid, 2) ;

  // caluclate saturation deficit unit: g kg'-1 
  inAirSatDef = CalcAH(inAirTemp, 100) ; // get saurated AH
  inAirSatDef = inAirSatDef - inAirAbHumid ;
  uecsOut("InAirSatDef", inAirSatDef, 2) ;
  // uecsOut("InAirSatuDef.mIA", inAirSatDef/1000, 5) ;

  // caluclate dew point temperature 
  measV = inAirAbHumid / 1000 ; // 1 g kg'-1 -> 1 kg kg'-1
  measV = log(101325 * measV / (measV + 0.622)) ; //work1: es
  if(inAirTemp > 0) {
    inAirDewPoint = -42.92 - 0.0514 * measV + 1.052 * measV * measV ;
  }
  else {
    inAirDewPoint = -60.02 + 6.803 * measV + 0.3966 * measV * measV ;
  }
  uecsOut("InAirDewPoint", inAirDewPoint, 1) ;

  // wait for the next measurement time (every 1 second)
  while((millis() - ptime < 1000) && (ptime < millis())) ;
  ptime = millis();
}

