/*
  UecsLetterCheck.cpp - Library for checking of string of UECS message

  Ken-ichiro Yasuba 2013
*/




#include "Arduino.h"
#include "UecsLetterCheck.h"

int UECScheckPacket(int _poi, char *__buf, int __bufsize, char *_checkLetter, int _lettersize){
  int check = -1;
  boolean success = false;
  int poi = 0;
  int i;
  if(_lettersize > __bufsize - _poi){
  }
  else{
    for(i = _poi; i < __bufsize; i++){
      if(__buf[i] == _checkLetter[poi]){
        check = i;
        poi++;
      }
      else if(__buf[i]==32 || __buf[i]==10 || __buf[i]==13) {
        // only increment i 
      }
      else{
        break;
      }
      if(poi == _lettersize){
        success = true;
        break;
      }
    }
  }
  if(success == false){
    check = -1;
  }
  return check;
}

// ROM version

int UECScheckPacketPGM(int _poi, char *__buf, int __bufsize, const char *_romword, int _lettersize){
  int check = -1;
  boolean success = false;
  int poi = 0;
  int i;
  if(_lettersize > __bufsize - _poi){
  }
  else{
    for(i = _poi; i < __bufsize; i++){
      if(__buf[i] == pgm_read_byte(&_romword[poi])){

        check = i;
        poi++;
      }
      else if(__buf[i]==32 || __buf[i]==10 || __buf[i]==13) {
        // only increment i 
      }
      else{
        break;
      }
      if(poi == _lettersize){
        success = true;
        break;
      }
    }
  }
  if(success == false){
    check = -1;
  }
  return check;
}

char* UECSaddPGMChar(const char* _romword, int _charnum, char* _point){
  char* point = _point;
  for(int i = 0; i <= _charnum; i++){
    point = _point + i;
    *point = pgm_read_byte(&_romword[i]);            
  }
  return point;
}


char* UECSaddChar(char* _word, char* _point){
  sprintf(_point, "%s", _word);
  return _point + strlen(_word);  
}

char* UECSaddTempChar(const char* _romword, char* _tempStr, char* _point){
   strcpy_P(_tempStr, _romword);
   _point = UECSaddChar(_tempStr, _point++);
   return _point;
}
