#include <SPI.h>
#include <Ethernet.h>
#include <avr/pgmspace.h>
#include <avr/wdt.h>
#include <CCM.h>
#include <EEPROM.h>
#include <EthernetManager.h>

#define NONE -1
#define A_1S_0 0
#define A_1S_1 1
#define A_10S_0 2
#define A_10S_1 3
#define A_1M_0 4
#define A_1M_1 5
#define S_1S_0 6
#define S_1M_0 7
#define B_0 8
#define B_1 9

#define UECSSHOWDATA 0
#define UECSINPUTDATA 1
#define UECSSELECTDATA 2
#define UECSSHOWSTRING 3

/////////////////////////////////////
//IP reset jupmer pin setting
/////////////////////////////////////
//Pin ID. This pin is pull-upped automatically.
const byte U_InitPin = 3;

//Pin ID
//Arduino can be assigned analog pins to digital I/O pins.
//Uno,ArduinoEthernet  D1-D13:1-13   A0-A5:14-19
//ArduinoMega D1-D53:1-53 A0-A15:54-69

//When U_InitPin status equals this value,IP address is set "192.168.1.7".
//(This is added Ver3 over)
const byte U_InitPin_Sense=HIGH;  
//Attaintion:If IP address is updated from web,reset is needed.

////////////////////////////////////
//Node basic infomation
///////////////////////////////////
const char PROGMEM U_name[] = "UARDECS Node v.1.0";
const char PROGMEM U_vender[] = "XXXXXX Co.";
const char PROGMEM U_uecsid[] = "00000000";
const char PROGMEM U_footnote[] = "Test node";
const int U_footnoteLetterNumber = 48;
char U_nodename[20] = "Sample";
UECSOriginalAttribute U_orgAttribute;
//////////////////////////////////
// html page1 setting
//////////////////////////////////
const int U_HtmlLine = 3; //Total number of HTML table rows.
const char PROGMEM NAME0[] = "Temperature";
const char PROGMEM NAME1[] = "UserSwitch";
const char PROGMEM NAME2[] = "SetTemp";

//select
const char PROGMEM UECSOFF[] = "OFF";
const char PROGMEM UECSON[] = "ON";
const char PROGMEM UECSAUTO[] = "AUTO";
PROGMEM const char *stringONOFFAUTO[3]={
UECSOFF,
UECSON,
UECSAUTO,
};
PROGMEM const char CENT[] = "C";
PROGMEM const char NONES[] = "";
PROGMEM const char note1[]= "Set temp";

signed long webTemp;
signed long setONOFFAUTO;
signed long setONTemp;
const char** dummy = NULL;

struct UECSUserHtml U_html[U_HtmlLine]={
{NAME0, UECSSHOWDATA, CENT, NONES, dummy, 0, &(webTemp), 0, 0, 1},
{NAME1, UECSSELECTDATA, NONES, NONES, stringONOFFAUTO, 3, &(setONOFFAUTO), 0, 0, 0},
{NAME2, UECSINPUTDATA, CENT, note1, dummy, 0, &(setONTemp), 100, 400, 1},
};

//////////////////////////////////
// UserCCM setting
//////////////////////////////////

//define CCMID for identify
//CCMID_dummy must put on last
enum {
CCMID_InAirTemp,
CCMID_cnd,
CCMID_dummy,
};
//This sentence is same as follows:
//#define CCMID_InAirTemp 0
//#define CCMID_cnd 1
//#define CCMID_dummy 2



const int U_MAX_CCM = CCMID_dummy;
UECSCCM U_ccmList[U_MAX_CCM];


const char PROGMEM ccmNameTemp[] = "Temperature";
const char PROGMEM ccmTypeTemp[] = "InAirTemp";
const char PROGMEM ccmUnitTemp[] = "C";

const char PROGMEM ccmNameCnd[] = "NodeCondition";
const char PROGMEM ccmTypeCnd[] = "cnd.xXX";
const char PROGMEM ccmUnitCnd[] = "";


void UserInit(){
//Set proper MAC address
U_orgAttribute.mac[0] = 0x90;
U_orgAttribute.mac[1] = 0xA2;
U_orgAttribute.mac[2] = 0xDA;
U_orgAttribute.mac[3] = 0x12;
U_orgAttribute.mac[4] = 0x34;
U_orgAttribute.mac[5] = 0x56;

//Set ccm list
UECSsetCCM(false, CCMID_InAirTemp, ccmNameTemp, ccmTypeTemp, ccmUnitTemp, 30, 1, A_10S_0);
UECSsetCCM(true,  CCMID_cnd      , ccmNameCnd , ccmTypeCnd , ccmUnitCnd , 30, 0, A_1S_0);
}

void setSendP1Page(){
}

void UserEvery1min(){

//When InAirTemp is recieved truly,  value is updated for html output.
if(U_ccmList[CCMID_InAirTemp].validity)
      {
      webTemp = U_ccmList[CCMID_InAirTemp].value;
      }

//Thermostat 
if(setONOFFAUTO==0)
    {U_ccmList[CCMID_cnd].value=0;}//Manual OFF
else if(setONOFFAUTO==1)
    {U_ccmList[CCMID_cnd].value=1;}//Manual ON
else if(setONOFFAUTO==2 && U_ccmList[CCMID_InAirTemp].validity && U_ccmList[CCMID_InAirTemp].value<setONTemp)
    {U_ccmList[CCMID_cnd].value=1;}//Auto ON
else
    {U_ccmList[CCMID_cnd].value=0;}//OFF
  
}

void UserEveryLoop(){
}


void loop(){
UECSloop();
}


void setup(){
UECSsetup();
}
