/*
  CCM.h - Library of CCM Char of UECS 


  Ken-ichiro Yasuba 2013.
*/


#ifndef CCM_h
#define CCM_h

#include <Ethernet.h>
#include <EthernetUdp.h>
#include <UecsLetterCheck.h>

#define NONE -1
#define UECS_A_1S_0 0
#define UECS_A_1S_1 1
#define UECS_A_10S_0 2
#define UECS_A_10S_1 3
#define UECS_A_1M_0 4
#define UECS_A_1M_1 5
#define UECS_S_1S_0 6
#define UECS_S_1M_0 7
#define UECS_B_0 8
#define UECS_B_1 9
#define MAX_TYPE_CHAR 20


/********************************/
/* ROM CHAR *********************/
/********************************/


const char PROGMEM UECSccmFix0[]="<?xml version=\"1.0\"?><UECS ver=\"1.00-E10\">"; //42 words
const char PROGMEM UECSccmFix00[] = "<DATA type=\""; //12 words
const char PROGMEM UECSccmFix1[]="\" room=\""; // 8 words
const char PROGMEM UECSccmFix2[]="\" region=\"";  // 10 words    
const char PROGMEM UECSccmFix3[]="\" order=\""; // 9 words
const char PROGMEM UECSccmFix4[]="\" priority=\""; //12 words 
const char PROGMEM UECSccmFix5[]="\">"; // 2 words
const char PROGMEM UECSccmFix6[]="</DATA><IP>"; // 11 words
const char PROGMEM UECSccmFix7[]="</IP></UECS>"; // 12 words


const char PROGMEM UECS_A1S0[]="A_1S_0";
const char PROGMEM UECS_A1S1[]="A_1S_1";
const char PROGMEM UECS_A10S0[]="A_10S_0";
const char PROGMEM UECS_A10S1[]="A_10S_1";
const char PROGMEM UECS_A1M0[]="A_1M_0";
const char PROGMEM UECS_A1M1[]="A_1M_1";
const char PROGMEM UECS_S1S[]="S_1S_0";
const char PROGMEM UECS_S1M[]="S_1M_0";
const char PROGMEM UECS_B0_[]="B_0";
const char PROGMEM UECS_B1_[]="B_1";

const char PROGMEM UECSccmFixRN1A[]="<NODESCAN"; // 9 words
const char PROGMEM UECSccmFixRN2A[]="></NODESCAN></UECS>";  //19 words
const char PROGMEM UECSccmFixRN2B[]="/></UECS>";  // 9  words

const char PROGMEM UECSccmFixSN1[]="<NODE><NAME>"; // 12 words
const char PROGMEM UECSccmFixSN2[]="</NAME><VENDER>"; // 15 words
const char PROGMEM UECSccmFixSN3[]="</VENDER><UECSID>"; // 17 words 
const char PROGMEM UECSccmFixSN4[]="</UECSID><IP>"; // 13 words
const char PROGMEM UECSccmFixSN5[]="</IP><MAC>"; // 10 words
const char PROGMEM UECSccmFixSN6[]="</MAC></NODE></UECS>"; // 20 words


const char PROGMEM UECSccmFixRC1A[] = "<CCMSCAN";  // 8 words
const char PROGMEM UECSccmFixRC2A[] = "/></UECS>";  // 9 words
const char PROGMEM UECSccmFixRC2B[] = "></CCMSCAN></UECS>"; //18words
const char PROGMEM UECSccmFixRC2C[] = " page=\""; // 7 words
const char PROGMEM UECSccmFixRC3A[]="\"/></UECS>"; // 10 words

const char PROGMEM UECSccmFixSC1[]="<CCMNUM page=\""; // 14 words
const char PROGMEM UECSccmFixSC2[]="\" total=\""; // 9 words
const char PROGMEM UECSccmFixSC3[]="</CCMNUM><CCM No=\""; // 18 words 
const char PROGMEM UECSccmFixSC4[]="\" cast=\""; // 8 words 
const char PROGMEM UECSccmFixSC5[]="\" unit=\""; // 8 words
const char PROGMEM UECSccmFixSC6[]="\" SR=\""; // 6 words
const char PROGMEM UECSccmFixSC7[]="\" LV=\""; // 6 words
const char PROGMEM UECSccmFixSC8[]="</CCM></UECS>";
unsigned const char UECSattrCharNum[] = {
  8, 10, 9, 12,}; 
  
  
  
/********************************/
/* Original Attribute ***********/
/********************************/
typedef struct UECSOriginalAttribute {
  char nodename[20]; // fix
  char vender[20];   // fix
  char uecsid[20];   // fix
  IPAddress ip;
  byte mac[8];
  byte subnet[4];
  byte gateway[4];
  byte dns[4];
  signed short room;
  signed short region;
  signed short order;
};



/********************************/
/* CCM    ***********************/
/* written by K .Yasuba *********/
/********************************/
typedef struct UECSCCM{
  boolean sender;              // fix
  const char * name;    // fix
  const char * type;    // fix 
  const char * unit;    // fix
  unsigned char decimal;       // fix   
  signed char ccmLevel;        // A_1S_0 etc. fix
  signed long validmillis;   // fix
  signed short attribute[4];
  signed short baseAttribute[3];
  signed long value;
  boolean validity;
  signed long recmillis;
  IPAddress address;
  boolean flagStimeRfirst;
};


/********************************/
/* TEMPCCM    *******************/
/* written by K .Yasuba *********/
/********************************/
typedef struct UECSTEMPCCM{
  char type[20];     
  unsigned char decimal;       // fix   
  signed short attribute[4];
  signed short baseAttribute[3];
  signed long value;
  IPAddress address;
};

boolean UECSparseRec(char * _packetBuffer, char* _tempStr20, struct UECSTEMPCCM *_tempCCM);
void UECSgetCCMSend(char* _packetBuffer, char* _tempStr20, struct UECSCCM* _ccm, struct UECSOriginalAttribute* _orgAttribute);
void UECSupRecCCM(UECSCCM* _ccm, UECSTEMPCCM* _ccmRec, unsigned long _recmillis);
void UECScheckUpDate(UECSCCM _ccmList[], int _maxccm, UECSTEMPCCM* _tempCCM, char* _tempStr20, unsigned long _time);
boolean UECSresNodeScan(UECSCCM _ccmList[], int _maxccm, char* _buffer, char* _tempStr20, const char* _name, const char* _vender, const char* _uecsid, UECSOriginalAttribute* _orgAttribute);
void UECSautomaticSendAndValidManager(UECSCCM* _ccm, unsigned char _counter60s, unsigned long _nowmillis);
#endif
