#include <arduino.h>
#include <EthernetManager.h>
#include <CCM.h>
char UECSbuffer[BUF];
unsigned char UECScounter60s = 0;
signed long UECSsyscounter = 0;
char UECStempStr20[MAX_TYPE_CHAR];
signed long UECSnowmillis;
struct UECSTEMPCCM UECStempCCM;



byte UECStempByte[4];
signed long UECStempValue[20];
unsigned char UECStempDecimal[20];
EthernetUDP UECS_UDP16520;
EthernetUDP UECS_UDP16529;
EthernetServer UECSlogserver(80);
EthernetClient UECSclient;


void UECS_EEPROM_writeLong(int ee, long value)
{
    byte* p = (byte*)(void*)&value;
    for (unsigned int i = 0; i < sizeof(value); i++)
	  EEPROM.write(ee++, *p++);
}

double UECS_EEPROM_readLong(int ee)
{
    long value = 0.0;
    byte* p = (byte*)(void*)&value;
    for (unsigned int i = 0; i < sizeof(value); i++)
	  *p++ = EEPROM.read(ee++);
    return value;
}

char* UECSsetInput(char* point, char* _packetBuffer, char* _tempStr20, byte _value){
    point = UECSaddPGMChar(&(UECShtmlLAN4A[0]), 23, point++);
    sprintf(_tempStr20, "%d", _value);
    point = UECSaddChar(_tempStr20, point++);
    point = UECSaddPGMChar(&(UECShtmlLAN4B[0]), 27, point++);
    return point;
}

void UECSprintLANhtml(char* point, char* _packetBuffer, char* _tempStr20, byte address[]){
  for(int i = 0; i < 4; i++){ 
    
    point = UECSsetInput(point, _packetBuffer, _tempStr20, address[i]);
    if(i != 3){
      point = UECSaddPGMChar(&(UECScoron[0]), 1, point++);        
    }
    else{
      point = UECSaddPGMChar(&(UECSbrfirst[0]), 4, point++);         
    } 
  }      
  *(++point) = 0;
  UECSclient.print(_packetBuffer);

}


void UECSPrintHeader(char* _packetBuffer, char* _tempStr20, UECSOriginalAttribute* _orgAttribute){
  char* point;
  point = UECSaddPGMChar(&(UECShtml0[0]), 86, _packetBuffer);    //<HTML><HEAD><META http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\"><TITLE>
  point = UECSaddTempChar(U_name, _tempStr20,  point++);
  point = UECSaddPGMChar(&(UECShtml1[0]), 39, point++);          //</TITLE><script type=\"text/javascript\">
   *(++point) = 0;
  
  UECSclient.print(_packetBuffer);
}

void UECSsendPageError(char* _packetBuffer, char* _tempStr20){
  /**/
  char* point;
  UECSPrintHeader(_packetBuffer, _tempStr20, &U_orgAttribute);
  point = UECSaddPGMChar(&(UECShtml1A[0]), 34, _packetBuffer);   // </script></HEAD><BODY><CENTER><H1>
  point = UECSaddPGMChar(&(UECSpageError[0]), 7, point++);      
  point = UECSaddPGMChar(&(UECShtml2[0]), 9, point++);
  point = UECSaddPGMChar(&(UECShtml3[0]), 14, point++); 
    *(++point) = 0;
  UECSclient.print(_packetBuffer);
  /**/
}
void UECSsendPageIndex(char* _packetBuffer, char* _tempStr20){
  char* point;
  UECSPrintHeader(_packetBuffer, _tempStr20, &U_orgAttribute);
  point = UECSaddPGMChar(&(UECShtml1A[0]), 34, _packetBuffer);
  point = UECSaddChar(U_nodename, point++);
  point = UECSaddTempChar(UECShtml2, _tempStr20, point++);
  point = UECSaddPGMChar(&(UECShtmlIndex[0]),  117, point++);
  *(++point) = 0;
  UECSclient.println(_packetBuffer);
  point = UECSaddTempChar(UECShrfirst, _tempStr20, _packetBuffer);  
  point = UECSaddPGMChar(&(U_footnote[0]), U_footnoteLetterNumber-1, point++);
  point = UECSaddPGMChar(&(UECShtml3[0]), 14, point++);    //</BODY></HTML>
   *(++point) = 0;
  UECSclient.println(_packetBuffer); 
}



void UECSsendPageLAN(char* _packetBuffer, char* _tempStr20, UECSOriginalAttribute* _orgAttribute, char* _name){
  //wdt_reset();
  char* point;

  UECSPrintHeader(_packetBuffer, _tempStr20, &U_orgAttribute);
/*  */
  point = UECSaddPGMChar(&(UECShtmlLAN0[0]), 217, _packetBuffer); // function m(){err=0;for(i=0;i<document.f.L.length;i++){if((document.f.L[i].value).match(/^(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])$/)){}else{err=1;}}if(err==0){document.f.b.disabled=false;}else{document.f.b.disabled=true;}}
  *(++point)=0;
  UECSclient.print(_packetBuffer);  
  

/* */  
  point = UECSaddPGMChar(&(UECShtml1A[0]), 34, _packetBuffer);  // </script></HEAD><BODY><CENTER><H1>
  point = UECSaddChar(U_nodename, point++);
  point = UECSaddTempChar(UECShtml2, _tempStr20, point++); 
  point = UECSaddTempChar(UECShtml2A, _tempStr20, point++);
  point = UECSaddTempChar(UECShtmlLANTITLE, _tempStr20, point++);
  point = UECSaddTempChar(UECShtml2B, _tempStr20, point++);  
  point = UECSaddPGMChar(&(UECShtmlLAN2[0]), 37, point++);  // <form action=\"./h2.html\" name=\"f\"><p>
  *(++point)=0;
  UECSclient.print(_packetBuffer);
  
  
  point = UECSaddPGMChar(&(UECShtmlLAN3A[0]), 9, _packetBuffer);   // address: 

  for(int i = 0; i < 4; i++){
    UECStempByte[i] = _orgAttribute->ip[i];
  }
  UECSprintLANhtml(point, _packetBuffer, _tempStr20, UECStempByte); // XXX:XXX:XXX:XXX <br>
  point = UECSaddPGMChar(&(UECShtmlLAN3B[0]), 9, _packetBuffer);  // subnet: 
  UECSprintLANhtml(point, _packetBuffer, _tempStr20, _orgAttribute->subnet); // XXX:XXX:XXX:XXX <br>
  point = UECSaddPGMChar(&(UECShtmlLAN3C[0]), 9, _packetBuffer);  // gateway: 
  UECSprintLANhtml(point, _packetBuffer, _tempStr20, _orgAttribute->gateway); // XXX:XXX:XXX:XXX <br>
  point = UECSaddPGMChar(&(UECShtmlLAN3D[0]), 9, _packetBuffer);  // dns: 
  UECSprintLANhtml(point, _packetBuffer, _tempStr20, _orgAttribute->dns); // XXX:XXX:XXX:XXX <br>

  point = UECSaddTempChar(UECShtml2A, _tempStr20, _packetBuffer);// <H2>
  point = UECSaddTempChar(UECShtmlUECSTITLE, _tempStr20, point++); // UECS
  point = UECSaddTempChar(UECShtml2B, _tempStr20, point++); // </H2>
  *(point++) = 0;   
  UECSclient.print(_packetBuffer); 
  
  point = UECSaddTempChar(UECShtmlRoom, _tempStr20, _packetBuffer);   
  point = UECSsetInput(point, _packetBuffer, _tempStr20, (byte)_orgAttribute->room);  
  point = UECSaddTempChar(UECShtmlRegion, _tempStr20, point++);
  point = UECSsetInput(point, _packetBuffer, _tempStr20, (byte)_orgAttribute->region);  
  point = UECSaddTempChar(UECShtmlOrder, _tempStr20, point++);
  point = UECSsetInput(point, _packetBuffer, _tempStr20, (byte)_orgAttribute->order);
  point = UECSaddPGMChar(&(UECSbrfirst[0]), 4, point++);
  *(point++) = 0;   
  UECSclient.print(_packetBuffer); 
  
  point = UECSaddTempChar(UECShtml2A, _tempStr20, _packetBuffer);// <H2>
  point = UECSaddTempChar(UECShtmlNAMETITLE, _tempStr20, point++); //Node Name
  point = UECSaddTempChar(UECShtml2B, _tempStr20, point++); // </H2>
  *(point++) = 0;   
  UECSclient.print(_packetBuffer); 
  point = UECSaddPGMChar(&(UECShtmlLAN4A[0]), 23, _packetBuffer);
  point = UECSaddChar(_name, point++);
  point = UECSaddTempChar(UECShtmlLAN4C, _tempStr20, point++);
  point = UECSaddPGMChar(&(UECSbrfirst[0]), 4, point++);  
   *(point++) = 0;   
  UECSclient.print(_packetBuffer);  
  point = UECSaddPGMChar(&(UECShtmlLAN5[0]), 43, _packetBuffer); // <input name=\"b\" type=\"submit\" value=\"send\">
  point = UECSaddPGMChar(&(UECSformend[0]), 7, point++);   //</form>
  point = UECSaddPGMChar(&(UECShtml4B[0]), 56, point++);
  point = UECSaddPGMChar(&(UECShtml3[0]), 14, point++);    //</BODY></HTML>
  *(point++) = 0;   
  UECSclient.print(_packetBuffer);   

}


void UECSsendPage1(char* _packetBuffer, char* _tempStr20, UECSCCM _ccmList[]){
  //wdt_reset();
  char* point;
  UECSPrintHeader(_packetBuffer, _tempStr20, &U_orgAttribute);
  point = UECSaddPGMChar(&(UECShtml1A[0]), 34, _packetBuffer); // </script></HEAD><BODY><CENTER><H1>
  point = UECSaddChar(U_nodename, point++);   
  point = UECSaddPGMChar(&(UECShtmlCCMRecRes0[0]), 189, point++); // </H1><H2>CCM Status</H2><TABLE border=\"1\"><TBODY align=\"center\"><TR><TH>Info</TH><TH>S/R</TH><TH>Type</TH><TH>SR Lev</TH><TH>Value</TH><TH>Valid</TH><TH>Sec</TH><TH>Atr</TH><TH>IP</TH></TR>
  *(++point) = 0;
  UECSclient.print(_packetBuffer);

  for(int i = 0; i < U_MAX_CCM; i++){
    if(_ccmList[i].ccmLevel != NONE){
      point = UECSaddPGMChar(&(UECStrtd[0]), 8, _packetBuffer); //<tr><td>
      point = UECSaddTempChar(_ccmList[i].name, _tempStr20, point++);         
      point = UECSaddPGMChar(&(UECStdtd[0]), 9, point++); //</td><td>
      if(_ccmList[i].sender){
        sprintf(_tempStr20, "%s", "S");
      }else{
        sprintf(_tempStr20, "%s", "R");       
      } 
      point = UECSaddChar(_tempStr20, point++);
      point = UECSaddPGMChar(&(UECStdtd[0]), 9, point++); //</td><td>
      point = UECSaddTempChar(_ccmList[i].type, _tempStr20, point++);               
      point = UECSaddPGMChar(&(UECStdtd[0]), 9, point++); //</td><td> 

  
      strcpy_P(_tempStr20, (char*)pgm_read_word(&(UECSCCMLEVEL[_ccmList[i].ccmLevel])));
      point = UECSaddChar(_tempStr20, point++);         
      point = UECSaddPGMChar(&(UECStdtd[0]), 9, point++); //</td><td>       

      dtostrf(((double)_ccmList[i].value) / pow(10, _ccmList[i].decimal), -1, _ccmList[i].decimal, _tempStr20);
      point = UECSaddChar(_tempStr20, point++);
      point = UECSaddPGMChar(&(UECStdtd[0]), 9, point++); //</td><td>
      if(_ccmList[i].sender){

      }else{
        if(_ccmList[i].validity){
           sprintf(_tempStr20, "%s", "O");
        }else{
           strcpy_P(_tempStr20, UECSpeke); 
        }
        point = UECSaddChar(_tempStr20, point++);        
      }  

      point = UECSaddPGMChar(&(UECStdtd[0]), 9, point++); //</td><td>      
      
      if(_ccmList[i].flagStimeRfirst && _ccmList[i].sender == false){
        sprintf(_tempStr20, "%lu", (millis() - _ccmList[i].recmillis) / 1000 );           
        
        
      }
      else{
        sprintf(_tempStr20, "%s", ""); 
      }      
      point = UECSaddChar(_tempStr20, point++);
      point = UECSaddPGMChar(&(UECStdtd[0]), 9, point++); //</td><td>   
      
      if(_ccmList[i].flagStimeRfirst && _ccmList[i].sender == false){
        sprintf(_tempStr20, "%d-%d-%d-%d", _ccmList[i].attribute[0], _ccmList[i].attribute[1], _ccmList[i].attribute[2], _ccmList[i].attribute[3]);
        point = UECSaddChar(_tempStr20, point++);         
      }
      sprintf(_tempStr20, "(%d-%d-%d)", _ccmList[i].baseAttribute[0], _ccmList[i].baseAttribute[1], _ccmList[i].baseAttribute[2]);         
      point = UECSaddChar(_tempStr20, point++);
      point = UECSaddPGMChar(&(UECStdtd[0]), 9, point++); //</td><td>  
      
      
      point = UECSaddPGMChar(&(UECSref0[0]), 16, point++);       
      sprintf(_tempStr20, "%d.%d.%d.%d", _ccmList[i].address[0], _ccmList[i].address[1], _ccmList[i].address[2], _ccmList[i].address[3]);        
      point = UECSaddChar(_tempStr20, point++);
      point = UECSaddPGMChar(&(UECSref1[0]), 2, point++);
      point = UECSaddChar(_tempStr20, point++);
      point = UECSaddPGMChar(&(UECSref2[0]), 4, point++);
      
      point = UECSaddPGMChar(&(UECStdtr[0]), 10, point++); //</td></tr>  
      *(++point) = 0;
      UECSclient.print(_packetBuffer);      
    } //NONE route
  }
  point = UECSaddPGMChar(&(UECShtml4A[0]), 16, _packetBuffer); //</TBODY></TABLE>
  
if(U_HtmlLine>0) {
  point = UECSaddPGMChar(&(UECShtmlUserRes0[0]), 162, point++); // </H1><H2>Status</H2><TABLE border=\"1\"><TBODY align=\"center\"><TR><TH>Name</TH><TH>Val</TH><TH>Unit</TH><TH>Detail</TH></TR>
  *(++point) = 0;
  UECSclient.print(_packetBuffer);
  for(int i = 0; i < U_HtmlLine; i++){
      point = UECSaddPGMChar(&(UECStrtd[0]), 8, _packetBuffer);
      point = UECSaddTempChar(U_html[i].name, _tempStr20, point++);
      point = UECSaddPGMChar(&(UECStdtd[0]), 9, point++);
      // only value

      if(U_html[i].pattern == UECSSHOWDATA){
        if(U_html[i].decimal != 0){
           dtostrf(((double)*U_html[i].data) / pow(10, U_html[i].decimal), -1, U_html[i].decimal, _tempStr20);
        }else{
           sprintf(_tempStr20, "%ld", *(U_html[i].data));
        }
        point = UECSaddChar(_tempStr20, point++);
        point = UECSaddPGMChar(&(UECShtmlInputHidden[0]),  41, point++);
      }else if(U_html[i].pattern == UECSINPUTDATA){
        point = UECSaddPGMChar(&(UECShtmlLAN4A[0]), 23,  point++);
        dtostrf(((double)*U_html[i].data) / pow(10, U_html[i].decimal), -1, U_html[i].decimal, _tempStr20);
        point = UECSaddChar(_tempStr20, point++);
        point = UECSaddChar("\"/>", point++);
      }else if(U_html[i].pattern == UECSSELECTDATA){
        point = UECSaddPGMChar(&(UECShtmlSelect[0]),17, point++);
        for(int j = 0; j < U_html[i].selectnum; j++){
          point = UECSaddPGMChar(&(UECShtmlOption[0]), 15, point++);
          if((int)(*U_html[i].data) == j){
             sprintf(_tempStr20, "%d\" selected>", j); 
          }else{   
             sprintf(_tempStr20, "%d\">", j);
          }
          point = UECSaddChar(_tempStr20, point++);
          strcpy_P(_tempStr20, (char*)pgm_read_word(&(U_html[i].selectname[j])));
          point = UECSaddChar(_tempStr20, point++);      
        }       
        point = UECSaddPGMChar(&(UECShtmlSelectEnd[0]), 9, point++);        
      }else if(U_html[i].pattern == UECSSHOWSTRING){
          strcpy_P(_tempStr20, (char*)pgm_read_word(&(U_html[i].selectname[(int)*(U_html[i].data)])));
          point =  UECSaddChar(_tempStr20, point++);
          point = UECSaddPGMChar(&(UECShtmlInputHidden[0]),  41, point++);         
      }
      *(++point) = 0;
      UECSclient.print(_packetBuffer);           
      point = UECSaddPGMChar(&(UECStdtd[0]), 9, _packetBuffer);     
      point = UECSaddTempChar(U_html[i].unit, _tempStr20, point++);   
      point = UECSaddPGMChar(&(UECStdtd[0]), 9, point++);     
      point = UECSaddTempChar(U_html[i].detail, _tempStr20, point++);     
      point = UECSaddPGMChar(&(UECStdtr[0]), 10, point++); //</td></tr>  
      *(++point) = 0;
      UECSclient.print(_packetBuffer);      
  }


  point = UECSaddPGMChar(&(UECShtml4A[0]), 16, _packetBuffer); //</TBODY></TABLE>
  point = UECSaddPGMChar(&(UECShtmlLAN5[0]), 43, point++); // <input name=\"b\" type=\"submit\" value=\"send\">
  point = UECSaddPGMChar(&(UECSformend[0]), 7, point++);   //</form>  
  
}
  point = UECSaddPGMChar(&(UECShtml4B[0]), 56, point++);  //<P align=\"center\">return <A href=\"index.html\">Top</A></P>
  point = UECSaddPGMChar(&(UECShtml3[0]), 14, point++);  
  *(++point) = 0; 
  UECSclient.print(_packetBuffer);    
   
}





void UECScheckHttpRequest(char* _buffer, char* _tempStr20, UECSCCM _ccmList[], UECSOriginalAttribute* _orgAttribute, UECSTEMPCCM* _tempCCM){
  //wdt_reset();
  UECSclient = UECSlogserver.available();
  if(UECSclient){
    int tempcount = 0;
    while(UECSclient.available()){
      char c = UECSclient.read();
      if(tempcount < 300){
        _buffer[tempcount] = c; 
      }
      tempcount++;
    }

    int  pointer = 0;
    int _pointer = 0;
    byte _page;
    _page = 100; 

    
    if((_pointer = UECScheckPacketPGM(pointer, _buffer, strlen(_buffer), &(UECSaccess0[0]), 13)) != -1){    // GET /HTTP/1.1
       _page = 0;
       UECSsendPageIndex( _buffer, _tempStr20);
    }else if((_pointer = UECScheckPacketPGM(pointer, _buffer, strlen(_buffer), &(UECSaccess00[0]), 24)) != -1){    // GET /index.html HTTP/1.1
       _page = 0;
              UECSsendPageIndex( _buffer, _tempStr20);
    }else if((_pointer = UECScheckPacketPGM(pointer, _buffer, strlen(_buffer), &(UECSaccess1[0]), 21)) != -1){    // GET /p1.html HTTP/1.1
       _page = 1;
       UECSsendPage1(_buffer, _tempStr20, _ccmList);
    }else if((_pointer = UECScheckPacketPGM(pointer, _buffer, strlen(_buffer), &(UECSaccess2[0]), 21)) != -1){    // GET /p2.html HTTP/1.1
       _page = 2;
       UECSsendPageLAN(_buffer, _tempStr20, _orgAttribute, U_nodename);
    }else if((_pointer = UECScheckPacketPGM(pointer, _buffer, strlen(_buffer), &(UECSaccess2A[0]), 15)) != -1){    // GET /p2.html?L=
       int countL;
       countL = 0;
       pointer = _pointer + 1;
       while(countL < 20){
         if((_pointer = UECScheckHtmlValue("&L=", 3, _tempCCM, pointer, _buffer)) != -1 && countL < 19){
           UECStempValue[countL] = _tempCCM->value;
           UECStempDecimal[countL] = _tempCCM->decimal;
           pointer = _pointer;
         }else if(countL == 19){
           for(int i = 0 ; i < 19; i++){
              if(_buffer[pointer] != '&'){
                 U_nodename[i] = _buffer[pointer];
              }else{
                 if(_buffer[pointer+1] == 'S'){
                   U_nodename[i] = 0;
                   break;
                 }
              }
              pointer = pointer + 1;
           }
         }else if((_pointer = UECScheckHtmlValue("&S=", 3, _tempCCM, pointer, _buffer)) != -1){
           UECStempValue[countL] = _tempCCM->value;
           UECStempDecimal[countL] = _tempCCM->decimal;
           break;
         }
         countL++;         
       }
       for(int i = 0; i < 20; i++){
           //wdt_reset();
           EEPROM.write(800 + i, (unsigned char)UECStempValue[i]);
       }
       for(int i = 0; i < 20; i++){
           //wdt_reset();
           EEPROM.write(825 + i, (unsigned char)U_nodename[i]);   
       }
         
       
       UECSsendPageLAN(_buffer, _tempStr20, _orgAttribute, U_nodename);
    }else if((_pointer = UECScheckPacketPGM(pointer, _buffer, strlen(_buffer), &(UECSaccess3A[0]), 15)) != -1){    // GET /p1.html?L=
       int countL = 0;
       pointer = _pointer + 1;
       while(countL < U_HtmlLine){
         if((_pointer = UECScheckHtmlValue("&L=", 3, _tempCCM, pointer, _buffer)) != -1){
            if(U_html[countL].pattern == UECSINPUTDATA){
              signed char tCount = ((signed char)U_html[countL].decimal) - (signed char)_tempCCM->decimal;
              *(U_html[countL].data) = _tempCCM->value * pow(10, tCount);
              if(U_html[countL].minValue > *(U_html[countL].data)){
                  *(U_html[countL].data) = U_html[countL].minValue;
              }else if(U_html[countL].maxValue < *(U_html[countL].data)){
                  *(U_html[countL].data) = U_html[countL].maxValue;
              }
            }else if(U_html[countL].pattern == UECSSELECTDATA){
              if(_tempCCM->value >= 0 && _tempCCM->value < U_html[countL].selectnum){
                 *(U_html[countL].data) = _tempCCM->value;
              }
            }
            pointer = _pointer;
         }else if((_pointer = UECScheckHtmlValue("&S=", 3, _tempCCM, pointer, _buffer)) != -1){
            if(U_html[countL].pattern == UECSINPUTDATA){
              signed char tCount = ((signed char)U_html[countL].decimal) - (signed char)_tempCCM->decimal;
              *(U_html[countL].data) = _tempCCM->value * pow(10, tCount);
              if(U_html[countL].minValue >  *(U_html[countL].data)){
                  *(U_html[countL].data) = U_html[countL].minValue;
              }else if(U_html[countL].maxValue < *(U_html[countL].data)){
                  *(U_html[countL].data) = U_html[countL].maxValue;
              }
            }else if(U_html[countL].pattern == UECSSELECTDATA){
              if(_tempCCM->value >= 0 && _tempCCM->value < U_html[countL].selectnum){
                 *(U_html[countL].data) = _tempCCM->value;
              }
            }
            break;
         }
         countL++;         
       }
       for(int i = 0; i < U_HtmlLine; i++){
           //wdt_reset();
           UECS_EEPROM_writeLong(850 + i * 4, *(U_html[i].data));
       }
       setSendP1Page();
       UECSsendPage1(_buffer, _tempStr20, _ccmList);
    }else{
       UECSsendPageError(_buffer, _tempStr20);
    }
  }
  UECSclient.stop();
}

int UECScheckHtmlValue(char *last, int lastsize, UECSTEMPCCM* _tempCCM, int _pointer, char* _packetBuffer){
    //wdt_reset();
     signed long value = 0;
     int __pointer = 0;
     boolean errorValue = false; 
     boolean  minus = false;
     int totalletters = 0;
     int konma = -1;
     int mojiNum = 0;
     boolean endletters = false;
     while((endletters == false && errorValue == false) && _pointer < 300){
         if(_packetBuffer[_pointer] >= 0x30 && _packetBuffer[_pointer] <= 0x39){
             value = value * 10 + (signed long)(_packetBuffer[_pointer] - 0x30);
             mojiNum++;
         }else if(_packetBuffer[_pointer] == '.' && mojiNum != 0 && konma == -1){
             konma = mojiNum;
         }else if(totalletters == 0 && _packetBuffer[_pointer] == '-'){
             minus = true;
         }else if((__pointer = UECScheckPacket(_pointer, _packetBuffer, 300, last, lastsize)) != -1){
             _pointer = __pointer + 1;
             endletters = true;
             break;
         }else{
             errorValue = true; 
         }         
         if(totalletters > 10){
             errorValue = true; 
         }
         totalletters++;
         _pointer++;
    }
    if(endletters){  
        if(konma == -1){
           _tempCCM->decimal = 0;
        }else{  
           _tempCCM->decimal = mojiNum - konma;
        }
        if(minus){
          _tempCCM->value = -value;
        }else{
          _tempCCM->value = value; 
        }
    }else{
            errorValue = true;  
    }  
    if(errorValue){
        _pointer = -1;
    }

    return _pointer;
}


//////////////////
//// html ////////
//////////////////

void UECSupdate16520portReceive(UECSCCM _ccmList[], int _maxccm, char* _buffer, char* _tempStr20, UECSTEMPCCM* _tempCCM, unsigned long _millis){
  //wdt_reset();
  int packetSize = UECS_UDP16520.parsePacket();
  if(packetSize){
    _tempCCM->address = UECS_UDP16520.remoteIP();   
    UECS_UDP16520.read(_buffer, BUF);
    UECSparseRec(_buffer, _tempStr20, _tempCCM);
    UECScheckUpDate(_ccmList, _maxccm, _tempCCM, _tempStr20, _millis);
  }

}

void UECSupdate16529port(UECSCCM _ccmList[], int _maxccm, char* _buffer, char* _tempStr20, UECSTEMPCCM* _tempCCM){

  //wdt_reset();
  int packetSize = UECS_UDP16529.parsePacket();
   if(packetSize){
      _tempCCM->address = UECS_UDP16529.remoteIP();   
      UECS_UDP16529.read(_buffer, BUF);
      if(UECSresNodeScan(_ccmList, _maxccm, _buffer, _tempStr20, U_name, U_vender, U_uecsid, &U_orgAttribute)){
         UECS_UDP16529.beginPacket(_tempCCM->address, 16529);
         UECS_UDP16529.write(_buffer);
         if(UECS_UDP16529.endPacket()==0)
         	{UECSresetEthernet();}//when udpsend failed,reset ethernet status
      }     
   }

}


void UECSsendCCM(char* _packetBuffer, struct UECSCCM* _ccm){
  UECS_UDP16520.beginPacket(_ccm->address, 16520);
  UECS_UDP16520.write(_packetBuffer);
  
  if(UECS_UDP16520.endPacket()==0)
  		{UECSresetEthernet();}//when udpsend failed,reset ethernet status
}

void UECSsetup(){
  //wdt_enable(WDTO_2S);
  wdt_disable();
  UECSinitOrgAttribute();
  UECSinitCCMList();
  UserInit();
  Ethernet.begin(U_orgAttribute.mac, U_orgAttribute.ip, U_orgAttribute.dns, U_orgAttribute.gateway, U_orgAttribute.subnet);
  UECSlogserver.begin();
  UECS_UDP16520.begin(16520);
  UECS_UDP16529.begin(16529);  
  UECStempCCM.attribute[0] = -1;
}
void UECSresetEthernet(){
//digitalWrite(3,!digitalRead(3));
  UECS_UDP16520.stop();
  UECS_UDP16529.stop();
  UECSinitOrgAttribute();
  Ethernet.begin(U_orgAttribute.mac, U_orgAttribute.ip, U_orgAttribute.dns, U_orgAttribute.gateway, U_orgAttribute.subnet);
  UECSlogserver.begin();
  UECS_UDP16520.begin(16520);
  UECS_UDP16529.begin(16529);  
  UECStempCCM.attribute[0] = -1;
}


void UECSloop(){
   //wdt_reset();
  UECSnowmillis = (signed long)millis();

  // network Check
  // 1. http request
  // 2. udp16520Receive
  // 3. udp16529Receive and Send
  // << USER MANAGEMENT >>
  // 4. udp16520Send
  UECScheckHttpRequest(UECSbuffer, UECStempStr20, U_ccmList, &U_orgAttribute, &UECStempCCM);
  UECSupdate16520portReceive(U_ccmList, U_MAX_CCM, UECSbuffer, UECStempStr20, &UECStempCCM, UECSnowmillis);
  UECSupdate16529port(U_ccmList, U_MAX_CCM, UECSbuffer, UECStempStr20, &UECStempCCM);
  
  UserEveryLoop();  

  
  if(UECSnowmillis - UECSsyscounter > 1000 || UECSsyscounter > UECSnowmillis){

    UECSsyscounter = UECSnowmillis;
    UECScounter60s++;
    if(UECScounter60s >= 60){
      UECScounter60s = 0;  
    }   
    for(int i = 0; i < U_MAX_CCM; i++){
       UECSautomaticSendAndValidManager(&U_ccmList[i], UECScounter60s, UECSnowmillis);
    }
    UserEvery1min();
    for(int i = 0; i < U_MAX_CCM; i++){
     if(U_ccmList[i].sender && U_ccmList[i].flagStimeRfirst && U_ccmList[i].ccmLevel != NONE){
         //wdt_reset();
        UECSgetCCMSend(UECSbuffer, UECStempStr20, &U_ccmList[i], &U_orgAttribute);
        UECSsendCCM(UECSbuffer, &U_ccmList[i]);
     }
    }   
  } 
  
  
}
void UECSinitOrgAttribute(){
	pinMode(U_InitPin,INPUT_PULLUP);
	//digitalWrite(U_InitPin, HIGH);
    
  for(int i = 0; i < 19; i++){
     if(i < 4){
       U_orgAttribute.ip[i] = EEPROM.read(i + 800);
     }else if(i < 8){
       U_orgAttribute.subnet[i - 4] =  EEPROM.read(i + 800);
     }else if(i < 12){
       U_orgAttribute.dns[i - 8] =  EEPROM.read(i + 800);
     }else if(i < 16){
       U_orgAttribute.gateway[i - 12] =  EEPROM.read(i + 800);
     }else if(i == 16){
       U_orgAttribute.room =  EEPROM.read(i + 800);
     }else if(i == 17){
       U_orgAttribute.region = EEPROM.read(i + 800);
     }else if(i == 18){
       U_orgAttribute.order =  EEPROM.read(i + 800);
     }
  }
  for(int i = 0; i < 20; i++){
     U_nodename[i] = EEPROM.read(825 + i);
  }
 for(int i = 0; i < U_HtmlLine; i++){
     *(U_html[i].data) = UECS_EEPROM_readLong(850 + i * 4);
 } 
 
if(digitalRead(U_InitPin) == U_InitPin_Sense){
    U_orgAttribute.ip[0] = 192;
    U_orgAttribute.ip[1] = 168;
    U_orgAttribute.ip[2] = 1;
    U_orgAttribute.ip[3] = 7;
    U_orgAttribute.subnet[0] = 255;
    U_orgAttribute.subnet[1] = 255;
    U_orgAttribute.subnet[2] = 255;
    U_orgAttribute.subnet[3] = 0; 
    U_orgAttribute.dns[0] = 0;
    U_orgAttribute.dns[1] = 0;
    U_orgAttribute.dns[2] = 0;
    U_orgAttribute.dns[3] = 0;
    U_orgAttribute.gateway[0] = 0;
    U_orgAttribute.gateway[1] = 0;
    U_orgAttribute.gateway[2] = 0;
    U_orgAttribute.gateway[3] = 0;
    U_orgAttribute.room = 0;
    U_orgAttribute.region = 0;
    U_orgAttribute.order =0;
 }
 
}
void UECSinitCCMList(){
  for(int i = 0; i < U_MAX_CCM; i++){
    U_ccmList[i].ccmLevel = NONE;
    U_ccmList[i].validity = false;
    U_ccmList[i].flagStimeRfirst = false;
    U_ccmList[i].recmillis = 0; 
    U_ccmList[i].attribute[0] = 0;
    U_ccmList[i].attribute[1] = 0;
    U_ccmList[i].attribute[2] = 0;
    U_ccmList[i].attribute[3] = 30;
    U_ccmList[i].baseAttribute[0] = U_orgAttribute.room;
    U_ccmList[i].baseAttribute[1] = U_orgAttribute.region;
    U_ccmList[i].baseAttribute[2] = U_orgAttribute.order;
    U_ccmList[i].address[0] = 255;
    U_ccmList[i].address[1] = 255;
    U_ccmList[i].address[2] = 255;
    U_ccmList[i].address[3] = 255;      
  }
}

signed char UECSsetCCM(boolean _sender,
signed char _num,
const char* _name,
const char* _type,
const char* _unit,
unsigned short _room,
unsigned short _region,
unsigned short _order,
unsigned short _priority,
unsigned char _decimal,
signed char _ccmLevel)
{
  if(_num > U_MAX_CCM || _num < 0){
    return -1;
  }
  U_ccmList[_num].sender = _sender;
  U_ccmList[_num].ccmLevel = _ccmLevel;    
  if(_ccmLevel == A_1S_0 || _ccmLevel == A_1S_1 || _ccmLevel == S_1S_0){
    U_ccmList[_num].validmillis = 3000;  
  }
  else if(_ccmLevel == A_10S_0 || _ccmLevel == A_10S_1){
    U_ccmList[_num].validmillis = 30000;        
  }
  else if(_ccmLevel == A_1M_0 || _ccmLevel == A_1M_1 || _ccmLevel == S_1M_0){
    U_ccmList[_num].validmillis = 180000;          
  }
  else if(_ccmLevel == B_0){
    U_ccmList[_num].validmillis = 0;
  }
  else{
    return -1;
  }
  U_ccmList[_num].name = _name;    
  U_ccmList[_num].type = _type;
  U_ccmList[_num].unit = _unit;    
  U_ccmList[_num].baseAttribute[0] = _room;
  U_ccmList[_num].baseAttribute[1] = _region;
  U_ccmList[_num].baseAttribute[2] = _order;
  U_ccmList[_num].attribute[0] = 0;
  U_ccmList[_num].attribute[1] = 0;
  U_ccmList[_num].attribute[2] = 0;    
  U_ccmList[_num].attribute[3] = _priority;  
  U_ccmList[_num].decimal = _decimal;
  U_ccmList[_num].ccmLevel = _ccmLevel;
  U_ccmList[_num].address[0] = 255;
  U_ccmList[_num].address[1] = 255;    
  U_ccmList[_num].address[2] = 255;
  U_ccmList[_num].address[3] = 255;    
  return _num;
}

signed char UECSsetCCM(boolean _sender, signed char _num, const char* _name, const char* _type, const char* _unit, unsigned short _priority, unsigned char _decimal, signed char _ccmLevel){
  return  UECSsetCCM(_sender, _num, _name, _type, _unit, U_orgAttribute.room, U_orgAttribute.region, U_orgAttribute.order, _priority, _decimal, _ccmLevel);
}
