/*
  Ken-ichiro Yasuba 2013.
  updated by Hideto Kurosaki 2015.
*/



#ifndef EthernetManager_h
#define EthernetManager_h
#include <SPI.h>   
#include <avr/wdt.h>
#include <Ethernet.h>
#include <EthernetUdp.h>
#include <UecsLetterCheck.h>
#include <CCM.h>
#include <EEPROM.h>

#define UECSSHOWDATA 0
#define UECSINPUTDATA 1
#define UECSSELECTDATA 2
#define UECSSHOWSTRING 3

#define NONE -1
#define A_1S_0 0
#define A_1S_1 1
#define A_10S_0 2
#define A_10S_1 3
#define A_1M_0 4
#define A_1M_1 5
#define S_1S_0 6
#define S_1M_0 7
#define B_0 8
#define B_1 9
#define BUF 300



const char PROGMEM UECShtml4A[]="</TBODY></TABLE>"; // 16 words
const char PROGMEM UECShtml4B[]="<P align=\"center\">return<A href=\"index.html\">Top</A></P>"; // 56words
const char PROGMEM UECScoron[] = ":";
const char PROGMEM UECSbrfirst[] = "<br>";



const char PROGMEM UECShtmlLAN0[] ="function m(){err=0;for(i=0;i<document.f.L.length;i++){if((document.f.L[i].value).match(/^(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])$/)){}else{err=1;}}if(err==0){document.f.b.disabled=false;}else{document.f.b.disabled=true;}}"; //217words


const char PROGMEM UECShtmlLAN2[] = "<form action=\"./p2.html\" name=\"f\"><p>"; // 37words


const char PROGMEM UECShtmlLAN3A[] ="address: "; //9 words
const char PROGMEM UECShtmlLAN3B[] ="subnet : ";
const char PROGMEM UECShtmlLAN3C[] ="gateway: ";
const char PROGMEM UECShtmlLAN3D[] ="dns    : ";
const char PROGMEM UECShtmlRoom[] ="room  : "; //8 words
const char PROGMEM UECShtmlRegion[] ="region: ";
const char PROGMEM UECShtmlOrder[] ="order : ";
const char PROGMEM UECShtmlLANTITLE[] = "LAN"; // 3words
const char PROGMEM UECShtmlUECSTITLE[] = "UECS"; // 3words
const char PROGMEM UECShtmlNAMETITLE[] = "Node Name";
const char PROGMEM UECShtmlLAN4A[] = "<input name=\"L\" value=\""; // 23words
const char PROGMEM UECShtmlLAN4B[] = "\" size=\"3\" onChange=\"m()\"/>"; // 27words
const char PROGMEM UECShtmlLAN4C[] = "\" size=\"19\"/>";
const char PROGMEM UECShtmlLAN5[] = "<input type=\"submit\" value=\"send\" name=\"S\">";  //43words

const char PROGMEM UECShtml0[]="<HTML><HEAD><META http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\"><TITLE>"; // 86words
const char PROGMEM UECShtml1[]="</TITLE><script type=\"text/javascript\">"; //39words
const char PROGMEM UECShtml1A[]="</script></HEAD><BODY><CENTER><H1>";//34words
const char PROGMEM UECShtml2[]="</H1>";        //5words
const char PROGMEM UECShtml2A[]="<H2>";
const char PROGMEM UECShtml2B[]="</H2>";
const char PROGMEM UECShtml3[]="</BODY></HTML>";   // 14words
const char PROGMEM UECShtmlCCMRecRes0[]="</H1><H2>CCM Status</H2><TABLE border=\"1\"><TBODY align=\"center\"><TR><TH>Info</TH><TH>S/R</TH><TH>Type</TH><TH>SR Lev</TH><TH>Value</TH><TH>Valid</TH><TH>Sec</TH><TH>Atr</TH><TH>IP</TH></TR>"; // 189words
const char PROGMEM UECStdtd[]="</TD><TD>"; // 9words
const char PROGMEM UECStrtd[]="<TR><TD>"; //8words
const char PROGMEM UECStdtr[]="</TD></TR>";
//const char PROGMEM UECShtml4A[]="</TBODY></TABLE>"; // 16 words
//const char PROGMEM UECShtml4B[]="<P align=\"center\">return<A href=\"index.html\">Top</A></P>"; // 56words
const char PROGMEM UECShrfirst[]="<hr>";
const char PROGMEM UECSformend[] = "</form>"; // 7words

const char PROGMEM UECSpageError[] = "Error!!";

const char PROGMEM UECShtmlIndex[] = "<a href=\"./p1.html\">Status & Setting</a><br><a href=\"./p2.html\">LAN and UECS Parameter</a><br>"; // 117 words

const char PROGMEM UECShtmlUserRes0[]="<H2>Status & SetValue</H2><form action=\"./p1.html\" name=\"f\"><TABLE border=\"1\"><TBODY align=\"center\"><TR><TH>Name</TH><TH>Val</TH><TH>Unit</TH><TH>Detail</TH></TR>"; // 162words
const char PROGMEM UECShtmlInputHidden[] = "<INPUT type=\"hidden\" name=\"L\" value=\"0\"/>";  //41words 
const char PROGMEM UECShtmlInputText[] = "<INPUT name=\"L\" value=\""; //23 words
const char PROGMEM UECShtmlSelect[] =  "<Select name=\"L\">";  //17words
const char PROGMEM UECShtmlOption[] = "<Option value=\""; // 15words
const char PROGMEM UECShtmlSelectEnd[] = "</SELECT>"; // 9words
const char PROGMEM UECShtmlSelected[]= "\" selected>"; // 11 words

const char PROGMEM UECSaccess0[] = "GET /HTTP/1.1"; // 14words
const char PROGMEM UECSaccess00[] = "GET /index.html HTTP/1.1"; // 24words
const char PROGMEM UECSaccess1[] = "GET /p1.html HTTP/1.1"; // 21words
const char PROGMEM UECSaccess2[] = "GET /p2.html HTTP/1.1"; // 21words
const char PROGMEM UECSaccess2A[] = "GET /p2.html?L="; // 15words
const char PROGMEM UECSaccess3[] = "GET /p3.html HTTP/1.1";
const char PROGMEM UECSaccess3A[] = "GET /p1.html?L="; 
const char PROGMEM UECSpeke[] = "X";
const char PROGMEM UECSref0[] = "<a href=\"http://"; //16 words
const char PROGMEM UECSref1[] = "\">";
const char PROGMEM UECSref2[] = "</a>";




typedef struct UECSUserHtml{
  const char* name;
  byte pattern;
  const char* unit;
  const char* detail;
  const char** selectname;
  unsigned char selectnum;
  signed long* data;
  signed long minValue;
  signed long maxValue;
  unsigned char decimal;
};

void UECSinitOrgAttribute();
void UECSinitCCMList();

void UECS_EEPROM_writeLong(int ee, long value);
double UECS_EEPROM_readLong(int ee);
char* UECSsetInput(char* point, char* _packetBuffer, char* _tempStr20, byte _value);
void UECSprintLANhtml(char* point, char* _packetBuffer, char* _tempStr20, byte address[]);


void UECSPrintHeader(char* _packetBuffer);
void UECSsendPageIndex(const char* _name, char* _packetBuffer, char* _tempStr20);
void UECSsendPageLAN(char* _packetBuffer, char* _tempStr20, UECSOriginalAttribute* _orgAttribute);
void UECSsendPage1(char* _packetBuffer, char* _tempStr20, UECSCCM _ccmList[]);
void UECScheckHttpRequest(char* _buffer, char* _tempStr20, UECSCCM _ccmList[], UECSOriginalAttribute* _orgAttribute, UECSTEMPCCM* _tempCCM);
int UECScheckHtmlValue(char *last, int lastsize, UECSTEMPCCM* _tempCCM, int _pointer, char* _packetBuffer);


void UECSupdate16520portReceive(UECSCCM _ccmList[], int _maxccm, char* _buffer, char* _tempStr20, UECSTEMPCCM* _tempCCM, unsigned long _millis);
void UECSupdate16529port(UECSCCM _ccmList[], int _maxccm, char* _buffer, char* _tempStr20);
void UECSsendCCM(char* _packetBuffer, struct UECSCCM* _ccm);
void UECSsetup();
void UECSloop();

signed char UECSsetCCM(boolean _sender,
signed char _num,
const char* _name,
const char* _type,
const char* _unit,
unsigned short _room,
unsigned short _region,
unsigned short _order,
unsigned short _priority,
unsigned char _decimal,
signed char _ccmLevel);

signed char UECSsetCCM(boolean _sender, signed char _num, const char* _name, const char* _type, const char* _unit, unsigned short _priority, unsigned char _decimal, signed char _ccmLevel);

extern const int U_MAX_CCM;
extern const int U_HtmlLine;
extern struct UECSUserHtml U_html[];
extern char buffer[];
extern const byte U_InitPin;
extern const byte U_InitPin_Sense;
extern PROGMEM const char U_name[];
extern PROGMEM const char U_vender[];
extern PROGMEM const char U_uecsid[];
extern PROGMEM const char U_footnote[];
extern const int U_footnoteLetterNumber;
extern char U_nodename[];
extern UECSOriginalAttribute U_orgAttribute;
extern PROGMEM const char *UECSCCMLEVEL[];

extern UECSCCM U_ccmList[];
extern void setSendP1Page();
extern void UserEvery1min();
extern void UserEveryLoop();
extern void UserInit();


void UECSresetEthernet();
#endif