/////////////////////////////////////////
//UARDECS Sample Program "DummyInAirTemp"
//UECS ccm "InAirTemp" sending test program
//////////////////////////////////////////
#include <SPI.h>
#include <Ethernet.h>
#include <avr/pgmspace.h>
#include <avr/wdt.h>
#include <CCM.h>
#include <EEPROM.h>
#include <EthernetManager.h>

#define NONE -1
#define A_1S_0 0
#define A_1S_1 1
#define A_10S_0 2
#define A_10S_1 3
#define A_1M_0 4
#define A_1M_1 5
#define S_1S_0 6
#define S_1M_0 7
#define B_0 8
#define B_1 9

#define UECSSHOWDATA 0
#define UECSINPUTDATA 1
#define UECSSELECTDATA 2
#define UECSSHOWSTRING 3

/////////////////////////////////////
//IP reset jupmer pin setting
/////////////////////////////////////
//Pin ID. This pin is pull-upped automatically.
const byte U_InitPin = 3;


//When U_InitPin status equals this value,IP address is set "192.168.1.7".
//(This is added Ver3 over)
const byte U_InitPin_Sense=HIGH;  
//Attaintion:If IP address is updated from web,reset is needed.

////////////////////////////////////
//Node basic infomation
///////////////////////////////////
const char PROGMEM U_name[] = "UARDECS Node v.1.0";
const char PROGMEM U_vender[] = "XXXXXX Co.";
const char PROGMEM U_uecsid[] = "00000000";
const char PROGMEM U_footnote[] = "Test node";
const int U_footnoteLetterNumber = 48;
char U_nodename[20] = "Sample";
UECSOriginalAttribute U_orgAttribute;
//////////////////////////////////
// html page1 setting
//////////////////////////////////
const int U_HtmlLine = 1; //Total number of HTML table rows.
const char PROGMEM NAME2[] = "SetTemp";

PROGMEM const char CENT[] = "C";
PROGMEM const char NONES[] = "";
PROGMEM const char note1[]= "Set output temp";

signed long setTemp;
const char** dummy = NULL;

struct UECSUserHtml U_html[U_HtmlLine]={
{NAME2, UECSINPUTDATA, CENT, note1, dummy, 0, &(setTemp), -100, 1000, 1},
};

//////////////////////////////////
// UserCCM setting
//////////////////////////////////

//define CCMID for identify
//CCMID_dummy must put on last
enum {
CCMID_InAirTemp,
CCMID_cnd,
CCMID_dummy,
};


const int U_MAX_CCM = CCMID_dummy;
UECSCCM U_ccmList[U_MAX_CCM];


const char PROGMEM ccmNameTemp[] = "Temperature";
const char PROGMEM ccmTypeTemp[] = "InAirTemp";
const char PROGMEM ccmUnitTemp[] = "C";

const char PROGMEM ccmNameCnd[] = "NodeCondition";
const char PROGMEM ccmTypeCnd[] = "cnd.xXX";
const char PROGMEM ccmUnitCnd[] = "";


void UserInit(){
//Set proper MAC address
U_orgAttribute.mac[0] = 0x90;
U_orgAttribute.mac[1] = 0xA2;
U_orgAttribute.mac[2] = 0xDA;
U_orgAttribute.mac[3] = 0x12;
U_orgAttribute.mac[4] = 0x34;
U_orgAttribute.mac[5] = 0x56;

//Set ccm list
UECSsetCCM(true, CCMID_InAirTemp, ccmNameTemp, ccmTypeTemp, ccmUnitTemp, 30, 1, A_1S_0);
UECSsetCCM(true,  CCMID_cnd      , ccmNameCnd , ccmTypeCnd , ccmUnitCnd , 30, 0, A_10S_0);
}

void setSendP1Page(){
  U_ccmList[CCMID_InAirTemp].value=setTemp;
}

void UserEvery1min(){
}

void UserEveryLoop(){
}


void loop(){
UECSloop();
}


void setup(){
UECSsetup();
U_ccmList[CCMID_InAirTemp].value=setTemp;
}
