/*
  Uardecs.h - Library for UECS 


  Ken-ichiro Yasuba 2013.
  updated by Hideto Kurosaki 2015.12.

*/


#ifndef Uardecs_h
#define Uardecs_h


#include <Ethernet.h>
#include <EthernetUdp.h>

#include <Arduino.h>
#include <SPI.h>   
#include <EEPROM.h>
#include <stdio.h>
#include <avr/pgmspace.h>


#define CHOICES(s) sizeof(s)/sizeof(s[0])

//Form CCM.h
//############################################################
//############################################################

#define MAX_TYPE_CHAR 20


/********************************/
/* ROM CHAR *********************/
/********************************/


const char UECSccmFix0[] PROGMEM="<?xml version=\"1.0\"?><UECS ver=\"1.00-E10\">"; //42 words
const char UECSccmFix00[] PROGMEM = "<DATA type=\""; //12 words
const char UECSccmFix1[] PROGMEM="\" room=\""; // 8 words
const char UECSccmFix2[] PROGMEM="\" region=\"";  // 10 words    
const char UECSccmFix3[] PROGMEM="\" order=\""; // 9 words
const char UECSccmFix4[] PROGMEM="\" priority=\""; //12 words 
const char UECSccmFix5[] PROGMEM="\">"; // 2 words
const char UECSccmFix6[] PROGMEM="</DATA><IP>"; // 11 words
const char UECSccmFix7[] PROGMEM="</IP></UECS>"; // 12 words


const char UECS_A1S0[] PROGMEM="A_1S_0";
const char UECS_A1S1[] PROGMEM="A_1S_1";
const char UECS_A10S0[] PROGMEM="A_10S_0";
const char UECS_A10S1[] PROGMEM="A_10S_1";
const char UECS_A1M0[] PROGMEM="A_1M_0";
const char UECS_A1M1[] PROGMEM="A_1M_1";
const char UECS_S1S[] PROGMEM="S_1S_0";
const char UECS_S1M[] PROGMEM="S_1M_0";
const char UECS_B0_[] PROGMEM="B_0";
const char UECS_B1_[] PROGMEM="B_1";

const char UECSccmFixRN1A[] PROGMEM="<NODESCAN"; // 9 words
const char UECSccmFixRN2A[] PROGMEM="></NODESCAN></UECS>";  //19 words
const char UECSccmFixRN2B[] PROGMEM="/></UECS>";  // 9  words

const char UECSccmFixSN1[] PROGMEM="<NODE><NAME>"; // 12 words
const char UECSccmFixSN2[] PROGMEM="</NAME><VENDER>"; // 15 words
const char UECSccmFixSN3[] PROGMEM="</VENDER><UECSID>"; // 17 words 
const char UECSccmFixSN4[] PROGMEM="</UECSID><IP>"; // 13 words
const char UECSccmFixSN5[] PROGMEM="</IP><MAC>"; // 10 words
const char UECSccmFixSN6[] PROGMEM="</MAC></NODE></UECS>"; // 20 words


const char UECSccmFixRC1A[] PROGMEM = "<CCMSCAN";  // 8 words
const char UECSccmFixRC2A[] PROGMEM = "/></UECS>";  // 9 words
const char UECSccmFixRC2B[] PROGMEM = "></CCMSCAN></UECS>"; //18words
const char UECSccmFixRC2C[] PROGMEM = " page=\""; // 7 words
const char UECSccmFixRC3A[] PROGMEM="\"/></UECS>"; // 10 words

const char UECSccmFixSC1[] PROGMEM="<CCMNUM page=\""; // 14 words
const char UECSccmFixSC2[] PROGMEM="\" total=\""; // 9 words
const char UECSccmFixSC3[] PROGMEM="</CCMNUM><CCM No=\""; // 18 words 
const char UECSccmFixSC4[] PROGMEM="\" cast=\""; // 8 words 
const char UECSccmFixSC5[] PROGMEM="\" unit=\""; // 8 words
const char UECSccmFixSC6[] PROGMEM="\" SR=\""; // 6 words
const char UECSccmFixSC7[] PROGMEM="\" LV=\""; // 6 words
const char UECSccmFixSC8[] PROGMEM="</CCM></UECS>";

unsigned const char UECSattrCharNum[] = {  8, 10, 9, 12,}; 
  
  
  
/********************************/
/* Original Attribute ***********/
/********************************/
typedef struct UECSOriginalAttribute {
  char nodename[21]; // fix
  char vender[21];   // fix
  char uecsid[21];   // fix
  IPAddress ip;
  byte mac[8];
  byte subnet[4];
  byte gateway[4];
  byte dns[4];
  unsigned short room;
  unsigned short region;
  unsigned short order;
};



/********************************/
/* CCM    ***********************/
/* written by K .Yasuba *********/
/********************************/
typedef struct UECSCCM{
  boolean sender;              // fix
  const char * name;    // fix
  const char * type;    // fix 
  const char * unit;    // fix
  unsigned char decimal;       // fix   
  char ccmLevel;        // A_1S_0 etc. fix
  signed long validmillis;   // fix
  signed short attribute[4];
  signed short baseAttribute[3];
  signed long value;
  boolean validity;
  signed long recmillis;
  IPAddress address;
  boolean flagStimeRfirst;
  unsigned char flags;
};

#define CCMFLAG_ALLOW_ABRIDGE_TYPE	1

/********************************/
/* TEMPCCM    *******************/
/* written by K .Yasuba *********/
/********************************/
typedef struct UECSTEMPCCM{
  char type[20];     
  unsigned char decimal;       // fix   
  signed short attribute[4];
  signed short baseAttribute[3];
  signed long value;
  IPAddress address;
};

boolean UECSparseRec(char * _packetBuffer, char* _tempStr20, struct UECSTEMPCCM *_tempCCM);
void UECSgetCCMSend(char* _packetBuffer, char* _tempStr20, struct UECSCCM* _ccm, struct UECSOriginalAttribute* _orgAttribute);
void UECSupRecCCM(UECSCCM* _ccm, UECSTEMPCCM* _ccmRec, unsigned long _recmillis);
void UECScheckUpDate(UECSCCM _ccmList[], int _maxccm, UECSTEMPCCM* _tempCCM, char* _tempStr20, unsigned long _time);
boolean UECSresNodeScan(UECSCCM _ccmList[], int _maxccm, char* _buffer, char* _tempStr20, UECSOriginalAttribute* _orgAttribute);
void UECSautomaticSendAndValidManager(UECSCCM* _ccm, unsigned char _counter60s, unsigned long _nowmillis);



//Form EthernetManager.h
//############################################################
//############################################################

#define UECSSHOWDATA 0
#define UECSINPUTDATA 1
#define UECSSELECTDATA 2
#define UECSSHOWSTRING 3

#define NONE -1
#define A_1S_0 0
#define A_1S_1 1
#define A_10S_0 2
#define A_10S_1 3
#define A_1M_0 4
#define A_1M_1 5
#define S_1S_0 6
#define S_1M_0 7
#define B_0 8
#define B_1 9
#define BUF 300
	
#define EEPROM_OFFSET_DATATOP	800
#define EEPROM_OFFSET_IP		800
#define EEPROM_OFFSET_SUBNET	804
#define EEPROM_OFFSET_GATEWAY	808
#define EEPROM_OFFSET_DNS		812
#define EEPROM_OFFSET_ROOM		816
#define EEPROM_OFFSET_REGION	817
#define EEPROM_OFFSET_ORDER_L	818
#define EEPROM_OFFSET_ORDER_H	819
#define EEPROM_OFFSET_NODENAME	825
#define EEPROM_OFFSET_WEBDATA	850
#define EEPROM_OFFSET_DATAEND	1023



const char UECShtml4A[] PROGMEM="</TBODY></TABLE>"; // 16 words
const char UECShtml4B[] PROGMEM="<P align=\"center\">return<A href=\"index\">Top</A></P>"; // 56words
//const char UECScoron[] PROGMEM = ":";
const char UECSbrfirst[] PROGMEM = "<br>";
const char UECShtmlLAN0[] PROGMEM ="function m(){err=0;for(i=0;i<document.f.L.length;i++){if((document.f.L[i].value).match(/^(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])$/)){}else{err=1;}}if(err==0){document.f.b.disabled=false;}else{document.f.b.disabled=true;}}"; //217words
const char UECShtmlLAN2[] PROGMEM = "<form action=\"./p2\" name=\"f\"><p>"; // 37words
const char UECShtmlLAN3A[] PROGMEM ="address:"; //9 words
const char UECShtmlLAN3B[] PROGMEM ="subnet:";
const char UECShtmlLAN3C[] PROGMEM ="gateway:";
const char UECShtmlLAN3D[] PROGMEM ="dns:";
const char UECShtmlRoom[] PROGMEM ="room:"; //8 words
const char UECShtmlRegion[] PROGMEM ="region:";
const char UECShtmlOrder[] PROGMEM ="order:";
const char UECShtmlLANTITLE[] PROGMEM = "LAN"; // 3words
const char UECShtmlUECSTITLE[] PROGMEM = "UECS"; // 3words
const char UECShtmlNAMETITLE[] PROGMEM = "Node Name";
const char UECShtmlATTENTION_RESET[] PROGMEM = "Reset is needed to enable values.";
const char UECShtmlATTENTION_IPSET[] PROGMEM = "InitSW:ON";
const char UECShtmlLAN4A[] PROGMEM = "<input name=\"L\" value=\""; // 23words
const char UECShtmlLAN4B[] PROGMEM = "\" size=\"3\" onChange=\"m()\"/>"; // 27words
const char UECShtmlLAN4C[] PROGMEM = "\" size=\"19\"/>";
const char UECShtmlLAN5[] PROGMEM = "<input type=\"submit\" value=\"send\" name=\"S\">";  //43words
const char UECShtml0[] PROGMEM="<HTML><HEAD><META http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\"><TITLE>"; // 86words
const char UECShtml1[] PROGMEM="</TITLE><script type=\"text/javascript\">"; //39words
const char UECShtml1A[] PROGMEM="</script></HEAD><BODY><CENTER><H1>";//34words
const char UECShtml2[] PROGMEM="</H1>";        //5words
const char UECShtml2A[] PROGMEM="<H2>";
const char UECShtml2B[] PROGMEM="</H2>";
const char UECShtml3[] PROGMEM="</BODY></HTML>";   // 14words
const char UECShtmlCCMRecRes0[] PROGMEM="</H1><H2>CCM Status</H2><TABLE border=\"1\"><TBODY align=\"center\"><TR><TH>Info</TH><TH>S/R</TH><TH>Type</TH><TH>SR Lev</TH><TH>Value</TH><TH>Valid</TH><TH>Sec</TH><TH>Atr</TH><TH>IP</TH></TR>"; // 189words
const char UECStdtd[] PROGMEM="</TD><TD>"; // 9words
const char UECStrtd[] PROGMEM="<TR><TD>"; //8words
const char UECStdtr[] PROGMEM="</TD></TR>";
//const char UECShtml4A[] PROGMEM="</TBODY></TABLE>"; // 16 words
//const char UECShtml4B[] PROGMEM="<P align=\"center\">return<A href=\"index\">Top</A></P>"; // 56words
const char UECShrfirst[] PROGMEM="<hr>";
const char UECSformend[] PROGMEM = "</form>"; // 7words

const char UECSpageError[] PROGMEM = "Error!!";

const char UECShtmlIndex[] PROGMEM = "<a href=\"./p1\">Node Status</a><br><a href=\"./p2\">Network Config</a><br>"; // 117 words

const char UECShtmlUserRes0[] PROGMEM="<H2>Status & SetValue</H2><form action=\"./p1\" name=\"f\"><TABLE border=\"1\"><TBODY align=\"center\"><TR><TH>Name</TH><TH>Val</TH><TH>Unit</TH><TH>Detail</TH></TR>"; // 162words
const char UECShtmlInputHidden[] PROGMEM = "<INPUT type=\"hidden\" name=\"L\" value=\"0\"/>";  //41words 
const char UECShtmlInputText[] PROGMEM = "<INPUT name=\"L\" value=\""; //23 words
const char UECShtmlSelect[] PROGMEM =  "<Select name=\"L\">";  //17words
const char UECShtmlOption[] PROGMEM = "<Option value=\""; // 15words
const char UECShtmlSelectEnd[] PROGMEM = "</SELECT>"; // 9words
const char UECShtmlSelected[] PROGMEM= "\" selected>"; // 11 words

const char UECSaccess0[] PROGMEM = "GET /HTTP/1.1"; // 14words
const char UECSaccess00[] PROGMEM = "GET /index HTTP/1.1"; // 24words
const char UECSaccess1[] PROGMEM = "GET /p1 HTTP/1.1"; // 21words
const char UECSaccess2[] PROGMEM = "GET /p2 HTTP/1.1"; // 21words
const char UECSaccess2A[] PROGMEM = "GET /p2?L="; // 15words
const char UECSaccess3[] PROGMEM = "GET /p3 HTTP/1.1";
const char UECSaccess3A[] PROGMEM = "GET /p1?L="; 
//const char UECSpeke[] PROGMEM = "X";
const char UECSref0[] PROGMEM = "<a href=\"http://"; //16 words
const char UECSref1[] PROGMEM = "\">";
const char UECSref2[] PROGMEM = "</a>";

typedef struct UECSUserHtml{
  const char* name;
  byte pattern;
  const char* unit;
  const char* detail;
  const char** selectname;
  unsigned char selectnum;
  signed long* data;
  signed long minValue;
  signed long maxValue;
  unsigned char decimal;
};

void UECSinitOrgAttribute();
void UECSinitCCMList();
void UECSresetEthernet();
void UECS_EEPROM_writeLong(int ee, long value);
double UECS_EEPROM_readLong(int ee);
char* UECSsetInput(char* point, char* _packetBuffer, char* _tempStr20, short _value);
void UECSprintLANhtml(char* point, char* _packetBuffer, char* _tempStr20, byte address[]);


void UECSPrintHeader();
void UECSsendPageIndex(const char* _name);
void UECSsendPageLAN( UECSOriginalAttribute* _orgAttribute);
void UECSsendPage1( UECSCCM _ccmList[]);
void UECScheckHttpRequest( UECSCCM _ccmList[], UECSOriginalAttribute* _orgAttribute, UECSTEMPCCM* _tempCCM);
int UECScheckHtmlValue(char *last, int lastsize, UECSTEMPCCM* _tempCCM, int _pointer);


void UECSupdate16520portReceive(UECSCCM _ccmList[], int _maxccm, char* _buffer, char* _tempStr20, UECSTEMPCCM* _tempCCM, unsigned long _millis);
void UECSupdate16529port(UECSCCM _ccmList[], int _maxccm, char* _buffer, char* _tempStr20);
void UECSsendCCM(char* _packetBuffer, struct UECSCCM* _ccm);
void UECSsetup();
void UECSloop();

signed char UECSsetCCM(boolean _sender,
signed char _num,
const char* _name,
const char* _type,
const char* _unit,
unsigned short _room,
unsigned short _region,
unsigned short _order,
unsigned short _priority,
unsigned char _decimal,
char _ccmLevel);


signed char UECSsetCCM(boolean _sender, signed char _num, const char* _name, const char* _type, const char* _unit, unsigned short _priority, unsigned char _decimal,  char _ccmLevel);

extern const int U_MAX_CCM;
extern const int U_HtmlLine;
extern struct UECSUserHtml U_html[];
extern char buffer[];
extern const byte U_InitPin;
extern const byte U_InitPin_Sense;
extern const char U_name[] PROGMEM;
extern const char U_vender[] PROGMEM;
extern const char U_uecsid[] PROGMEM;
extern const char U_footnote[] PROGMEM;
extern char U_nodename[];
extern UECSOriginalAttribute U_orgAttribute;
extern const char *UECSCCMLEVEL[];

extern UECSCCM U_ccmList[];
extern void OnWebFormRecieved();
extern void UserEveryMinute();
extern void UserEverySecond();
extern void UserEveryLoop();
extern void UserInit();


//Form UecsLetterCheck.h
//############################################################
//############################################################



#define MAXIMUM_STRINGLENGTH 32767
#define ASCIICODE_SPACE	32
#define ASCIICODE_DQUOT	34
#define ASCIICODE_LF	10
#define ASCIICODE_CR	13


int UECScheckPacket(int _poi, char *__buf, int __bufsize, char *_checkLetter, int _lettersize);
int UECScheckPacketPGM(int _poi, char *__buf,const char *_romword);
char* UECSaddPGMChar(const char* _romword, char* _point);
char* UECSaddChar(char* _word, char* _point);
char* UECSaddTempChar(const char* _romword, char* _tempStr, char* _point);

#endif
