/////////////////////////////////////////
//UARDECS Sample Program "SelectCCMType"
//By H.kurosaki 2016/3/16
//選択肢を表示してCCMのTypeを変更する
//例えば同一機種を複数用いて屋外気温と
//温室内気温を計測したい場合、などに有効です
//////////////////////////////////////////

#include <SPI.h>
#include <Ethernet2.h> //Arduino IDE Ver1.7.2以降でW5500搭載機種
//#include <Ethernet.h> //Ver1.7.2以降でW5100搭載機種
#include <avr/pgmspace.h>
#include <EEPROM.h>
#include <Uardecs.h>

const byte U_InitPin = 3;
const byte U_InitPin_Sense=HIGH;  
const char U_name[] PROGMEM= "UARDECS Node v.1.1";
const char U_vender[] PROGMEM= "XXXXXXXX Co.";
const char U_uecsid[] PROGMEM= "000000000000";
const char U_footnote[] PROGMEM= "UARDECS Sample Program ChangeCCM Type";
char U_nodename[20] = "Sample";
UECSOriginalAttribute U_orgAttribute;
// html setting
const int U_HtmlLine = 1; //Total number of HTML table rows.
const char WEB_NAME[] PROGMEM= "CCMの変更テスト";
const char WEB_NOTE[] PROGMEM= "送信CCMのTypeを選択";

const char WEB_SELTYPE0[] PROGMEM= "InAirTemp";
const char WEB_SELTYPE1[] PROGMEM= "InAirTemp.mIC";
const char WEB_SELTYPE2[] PROGMEM= "WAirTemp";
const char WEB_SELTYPE3[] PROGMEM= "WAirTemp.mOC";

const char NONES[] PROGMEM= "";

const char *stringSELECT[4]={
WEB_SELTYPE0,
WEB_SELTYPE1,
WEB_SELTYPE2,
WEB_SELTYPE3,
};
const char** dummy = NULL;

signed long ccmSelectID;

struct UECSUserHtml U_html[U_HtmlLine]={
{WEB_NAME, UECSSELECTDATA, NONES, WEB_NOTE, stringSELECT, CHOICES(stringSELECT), &(ccmSelectID),0,0,0},
};

// UserCCM setting
enum {
CCMID_InAirTemp,
CCMID_cnd,
CCMID_dummy,
};

const int U_MAX_CCM = CCMID_dummy;
UECSCCM U_ccmList[U_MAX_CCM];

const char ccmNameTemp[] PROGMEM= "Temperature";
//const char ccmTypeTemp[] PROGMEM= "InAirTemp";
const char ccmUnitTemp[] PROGMEM= "C";

const char ccmNameCnd[] PROGMEM= "NodeCondition";
const char ccmTypeCnd[] PROGMEM= "cnd.mIC";
const char ccmUnitCnd[] PROGMEM= "";


void UserInit(){
//MAC address is printed on sticker of Ethernet Shield.
//You must assign unique MAC address to each nodes.
//MACアドレス設定、必ずEthernet Shieldに書かれた値を入力して下さい。
//全てのノードに異なるMACアドレスを設定する必要があります。
U_orgAttribute.mac[0] = 0x00;
U_orgAttribute.mac[1] = 0x00;
U_orgAttribute.mac[2] = 0x00;
U_orgAttribute.mac[3] = 0x00;
U_orgAttribute.mac[4] = 0x00;
U_orgAttribute.mac[5] = 0x01;

SetTempCCM();
UECSsetCCM(true,  CCMID_cnd,ccmNameCnd,ccmTypeCnd,ccmUnitCnd,29,0,A_10S_0);
}

void OnWebFormRecieved(){
  SetTempCCM();
}
void UserEverySecond(){}
void UserEveryMinute(){}
void UserEveryLoop(){}
void loop(){
UECSloop();
}
void setup(){
UECSsetup();
}
void SetTempCCM()
{
  switch (ccmSelectID)
  {
  case 0:
  UECSsetCCM(true, CCMID_InAirTemp, ccmNameTemp,WEB_SELTYPE0, ccmUnitTemp, 29, 1, A_1S_0);
  break;
  case 1:
  UECSsetCCM(true, CCMID_InAirTemp, ccmNameTemp,WEB_SELTYPE1, ccmUnitTemp, 29, 1, A_1S_0);
  break;
  case 2:
  UECSsetCCM(true, CCMID_InAirTemp, ccmNameTemp,WEB_SELTYPE2, ccmUnitTemp, 29, 1, A_1S_0);
  break;
  case 3:
  UECSsetCCM(true, CCMID_InAirTemp, ccmNameTemp,WEB_SELTYPE3, ccmUnitTemp, 29, 1, A_1S_0);
  break;
  }
}


