/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Font;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.time.Day;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;

public class GraphDaily {
    private static final long serialVersionUID = 1L;
    JFreeChart chart;
    TimeSeriesCollection dataLeft;
    TimeSeries ts;
    File file;
    int width = 400;
    int height = 300;
    public String[] key = new String[]{"Min", "Ave", "Max"};
    int[] axisNum;
    String dataName;
    public Data data;

    public GraphDaily() {
    }

    GraphDaily(String dataname, String title, String filename, String rangename1, int _width, int _height) {
        this.data = new Data();
        this.dataName = dataname;
        this.file = new File(filename);
        this.dataLeft = new TimeSeriesCollection();
        this.width = _width;
        this.height = _height;
        int i = 0;
        while (i < this.key.length) {
            this.ts = new TimeSeries((Comparable)((Object)this.key[i]));
            this.dataLeft.addSeries(this.ts);
            this.dataLeft.getSeries((Comparable)((Object)this.key[i])).setMaximumItemCount(30);
            ++i;
        }
        this.chart = ChartFactory.createTimeSeriesChart((String)title, (String)"Time", (String)rangename1, (XYDataset)this.dataLeft, (boolean)true, (boolean)false, (boolean)false);
        XYPlot thisplot = this.chart.getXYPlot();
        this.chart.getTitle().setFont(new Font("MSUIGothic", 0, 14));
        this.chart.getLegend().setItemFont(new Font("MSUIGothic", 0, 10));
        thisplot.getRangeAxis().setLabelFont(new Font("MSUIGothic", 0, 12));
        thisplot.getDomainAxis().setLabelFont(new Font("MSUIGothic", 0, 12));
        DateAxis axis = (DateAxis)thisplot.getDomainAxis();
        axis.setAutoRange(true);
        axis.setDateFormatOverride((DateFormat)new SimpleDateFormat("M/d"));
        thisplot.getRangeAxis().setAutoRange(true);
        this.makegraph();
    }

    public TimeSeriesCollection addValues(Date date, double _min, double _ave, double _max) {
        this.ts = this.dataLeft.getSeries((Comparable)((Object)"Min"));
        if (this.ts != null) {
            this.ts.addOrUpdate((RegularTimePeriod)new Day(date), _min);
        }
        this.ts = this.dataLeft.getSeries((Comparable)((Object)"Ave"));
        if (this.ts != null) {
            this.ts.addOrUpdate((RegularTimePeriod)new Day(date), _ave);
        }
        this.ts = this.dataLeft.getSeries((Comparable)((Object)"Max"));
        if (this.ts != null) {
            this.ts.addOrUpdate((RegularTimePeriod)new Day(date), _max);
        }
        return this.dataLeft;
    }

    public boolean makegraph() {
        boolean success = true;
        try {
            ChartUtilities.saveChartAsJPEG((File)this.file, (JFreeChart)this.chart, (int)this.width, (int)this.height);
        }
        catch (IOException e) {
            success = false;
        }
        return success;
    }

    public class Data {
        boolean alive = false;
        double min;
        double max;
        double sum;
        int count;
    }
}

