/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Font;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.time.Minute;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;

public class GraphMin {
    private static final long serialVersionUID = 1L;
    JFreeChart chart;
    TimeSeriesCollection dataLeft;
    TimeSeriesCollection dataRight;
    TimeSeries ts;
    File file;
    int width = 400;
    int height = 300;
    public String[] key;
    int[] axisNum;
    public XYPlot thisplot;

    public GraphMin() {
    }

    GraphMin(String[] data_key, int[] _axisNumLeft, String title, String filename, String rangename1, String rangename2, int _width, int _height) {
        this.file = new File(filename);
        this.dataLeft = new TimeSeriesCollection();
        this.dataRight = new TimeSeriesCollection();
        this.key = new String[data_key.length];
        this.axisNum = new int[_axisNumLeft.length];
        this.width = _width;
        this.height = _height;
        boolean useAnotherAxis = false;
        int i = 0;
        while (i < data_key.length) {
            this.axisNum[i] = _axisNumLeft[i];
            if (this.axisNum[i] == 1) {
                useAnotherAxis = true;
            }
            this.key[i] = new String(data_key[i]);
            this.ts = new TimeSeries((Comparable)((Object)data_key[i]));
            if (this.axisNum[i] == 1) {
                this.dataRight.addSeries(this.ts);
                this.dataRight.getSeries((Comparable)((Object)data_key[i])).setMaximumItemCount(1440);
            } else {
                this.dataLeft.addSeries(this.ts);
                this.dataLeft.getSeries((Comparable)((Object)data_key[i])).setMaximumItemCount(1440);
            }
            ++i;
        }
        this.chart = ChartFactory.createTimeSeriesChart((String)title, (String)"Time", (String)rangename1, (XYDataset)this.dataLeft, (boolean)true, (boolean)false, (boolean)false);
        this.thisplot = this.chart.getXYPlot();
        NumberAxis anotherAxis = null;
        if (useAnotherAxis) {
            anotherAxis = new NumberAxis(rangename2);
            this.thisplot.setRangeAxis(1, (ValueAxis)anotherAxis);
            this.thisplot.setDataset(1, (XYDataset)this.dataRight);
            this.thisplot.mapDatasetToRangeAxis(1, 1);
            StandardXYItemRenderer renderer2 = new StandardXYItemRenderer();
            this.thisplot.setRenderer(1, (XYItemRenderer)renderer2);
        }
        this.chart.getTitle().setFont(new Font("MSUIGothic", 0, 14));
        this.chart.getLegend().setItemFont(new Font("MSUIGothic", 0, 10));
        this.thisplot.getRangeAxis().setLabelFont(new Font("MSUIGothic", 0, 12));
        this.thisplot.getDomainAxis().setLabelFont(new Font("MSUIGothic", 0, 12));
        DateAxis axis = (DateAxis)this.thisplot.getDomainAxis();
        axis.setAutoRange(true);
        axis.setDateFormatOverride((DateFormat)new SimpleDateFormat("M/d H:mm"));
        this.thisplot.getRangeAxis().setAutoRange(true);
        this.makegraph();
    }

    public TimeSeries addValue(Date date, String _key, double _value) {
        this.ts = this.dataLeft.getSeries((Comparable)((Object)_key));
        if (this.ts != null) {
            this.ts.addOrUpdate((RegularTimePeriod)new Minute(date), _value);
        } else {
            this.ts = this.dataRight.getSeries((Comparable)((Object)_key));
            if (this.ts != null) {
                this.ts.addOrUpdate((RegularTimePeriod)new Minute(date), _value);
            }
        }
        return this.ts;
    }

    public boolean makegraph() {
        boolean success = true;
        try {
            ChartUtilities.saveChartAsJPEG((File)this.file, (JFreeChart)this.chart, (int)this.width, (int)this.height);
        }
        catch (IOException e) {
            success = false;
        }
        return success;
    }
}

