/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import uecs1_00_E10_03.CCMDATARecE10;
import uecs1_00_E10_03.UserMap;

public class ReadInitFile {
    Document doc;
    DocumentBuilder db;
    XPath xpath;
    File initfile;
    public Map<Integer, GraphMin> GraphMinMap = new HashMap<Integer, GraphMin>();
    public Map<Integer, GraphDaily> GraphDailyMap = new HashMap<Integer, GraphDaily>();
    public Map<CCMDATARecE10, TempHumid> enthalpyMap = new HashMap<CCMDATARecE10, TempHumid>();
    public Map<CCMDATARecE10, TempHumid> vapDefMap = new HashMap<CCMDATARecE10, TempHumid>();
    public Map<CCMDATARecE10, TempHumid> absHumidMap = new HashMap<CCMDATARecE10, TempHumid>();
    public List<Ventilation> ventiList = new ArrayList<Ventilation>();
    public Map<String, DailyReport> dailyReportMap = new TreeMap<String, DailyReport>();
    public List<Alert> alertList = new ArrayList<Alert>();

    private void appendUECSLoga(String str) {
        UECSLoga_E10_201101.appendTextWithDate(str);
    }

    ReadInitFile(String file, UserMap um) {
        try {
            this.db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            this.xpath = XPathFactory.newInstance().newXPath();
            this.initfile = new File(file);
            this.parseInitFile(um);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
    }

    int parseInitFile(UserMap um) {
        block17: {
            if (this.initfile.exists()) {
                UECSLoga_E10_201101.appendTextWithDate("\u521d\u671f\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u304c\u898b\u3064\u304b\u308a\u307e\u3057\u305f\uff0e");
                try {
                    this.doc = this.db.parse(this.initfile);
                    XPathExpression expression = this.xpath.compile("ROOT/PRESET_CCM/DATA");
                    if (this.parseReceive((NodeList)expression.evaluate(this.doc, XPathConstants.NODESET), um)) {
                        this.appendUECSLoga("\u53d7\u4fe1CCM\u306e\u767b\u9332\u306f\u6b63\u5e38\u306b\u7d42\u4e86\u3057\u3001\u5408\u8a08\"" + Integer.toString(um.keyset_recCCM().size()) + "\"\u500b\u767b\u9332\u3057\u307e\u3057\u305f\uff0e");
                    } else {
                        this.appendUECSLoga("\u53d7\u4fe1CCM\u306e\u767b\u9332\u306b\u5931\u6557\u3057\u307e\u3057\u305f\uff0e");
                    }
                    expression = this.xpath.compile("ROOT/ENTHALPY");
                    if (this.parseEnthalpy((NodeList)expression.evaluate(this.doc, XPathConstants.NODESET), um, this.enthalpyMap, "ENTHALPY")) {
                        // empty if block
                    }
                    if (this.parseEnthalpy((NodeList)(expression = this.xpath.compile("ROOT/ABSHUMID")).evaluate(this.doc, XPathConstants.NODESET), um, this.absHumidMap, "ABSHUMID")) {
                        // empty if block
                    }
                    if (this.parseEnthalpy((NodeList)(expression = this.xpath.compile("ROOT/VAPDEF")).evaluate(this.doc, XPathConstants.NODESET), um, this.vapDefMap, "VAPDEF")) {
                        // empty if block
                    }
                    if (this.parseVentilation((NodeList)(expression = this.xpath.compile("ROOT/VENTILATION")).evaluate(this.doc, XPathConstants.NODESET), um, this.ventiList, "VENTILATION")) {
                        // empty if block
                    }
                    if (this.parseDailyReport((NodeList)(expression = this.xpath.compile("ROOT/DAILYREPORT")).evaluate(this.doc, XPathConstants.NODESET), um, this.dailyReportMap, "DAILYREPORT")) {
                        // empty if block
                    }
                    if (this.parseAlert((NodeList)(expression = this.xpath.compile("ROOT/ALERT")).evaluate(this.doc, XPathConstants.NODESET), um, this.alertList, "ALERT")) {
                        // empty if block
                    }
                    if (this.parseGraphMin((NodeList)(expression = this.xpath.compile("ROOT/GRAPH/GRAPH_MIN")).evaluate(this.doc, XPathConstants.NODESET), um, this.GraphMinMap)) {
                        this.appendUECSLoga("\u30b0\u30e9\u30d5\uff08\u5206\uff09\u306e\u767b\u9332\u306f\u6b63\u5e38\u306b\u7d42\u4e86\u3057\u307e\u3057\u305f\uff0e");
                    } else {
                        this.appendUECSLoga("\u30b0\u30e9\u30d5\uff08\u5206\uff09\u306e\u767b\u9332\u306b\u5931\u6557\u3057\u307e\u3057\u305f\uff0e");
                    }
                    expression = this.xpath.compile("ROOT/GRAPH/GRAPH_DAILY");
                    if (this.parseGraphDaily((NodeList)expression.evaluate(this.doc, XPathConstants.NODESET), um, this.GraphDailyMap)) {
                        this.appendUECSLoga("\u30b0\u30e9\u30d5\uff08\u65e5\u5831\uff09\u306e\u767b\u9332\u306f\u6b63\u5e38\u306b\u7d42\u4e86\u3057\u307e\u3057\u305f\uff0e");
                        break block17;
                    }
                    this.appendUECSLoga("\u30b0\u30e9\u30d5\uff08\u65e5\u5831\uff09\u306e\u767b\u9332\u306b\u5931\u6557\u3057\u307e\u3057\u305f\uff0e");
                }
                catch (SAXException e) {
                    this.appendUECSLoga("\u30d5\u30a1\u30a4\u30eb\u306e\u89e3\u6790\u306b\u5931\u6557\u3057\u307e\u3057\u305f\uff08SAXException\uff09.");
                }
                catch (IOException e) {
                    this.appendUECSLoga("\u30d5\u30a1\u30a4\u30eb\u306e\u89e3\u6790\u306b\u5931\u6557\u3057\u307e\u3057\u305f\uff08IOException\uff09.");
                }
                catch (XPathExpressionException e) {
                    this.appendUECSLoga("\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u306e\u8a18\u8f09\u65b9\u6cd5\u306e\u554f\u984c\u304c\u898b\u3064\u304b\u308a\u307e\u3057\u305f\uff0e");
                }
            } else {
                this.appendUECSLoga("\u521d\u671f\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\uff0e");
            }
        }
        return 0;
    }

    private boolean parseVentilation(NodeList nodelist, UserMap um, List<Ventilation> ventiList, String node) {
        double lightThrRate = 0.0;
        double lightRefRate = 0.0;
        double thermoThrRate = 0.0;
        double ratioFilmToFloor = 0.0;
        String inAirTemp = "";
        String inAirHumid = "";
        String wAirHumid = "";
        String wAirTemp = "";
        String wRadiation = "";
        boolean success = false;
        try {
            XPathExpression _expression2 = this.xpath.compile("./CONST");
            NodeList nlist = (NodeList)_expression2.evaluate(nodelist.item(0), XPathConstants.NODESET);
            lightThrRate = Double.parseDouble(this.xpath.evaluate("@lightThrRate", nlist.item(0)));
            lightRefRate = Double.parseDouble(this.xpath.evaluate("@lightRefRate", nlist.item(0)));
            thermoThrRate = Double.parseDouble(this.xpath.evaluate("@thermoThrRate", nlist.item(0)));
            ratioFilmToFloor = Double.parseDouble(this.xpath.evaluate("@ratioFilmToFloor", nlist.item(0)));
            _expression2 = this.xpath.compile("./RECVALUE");
            nlist = (NodeList)_expression2.evaluate(nodelist.item(0), XPathConstants.NODESET);
            inAirTemp = this.xpath.evaluate("@inAirTemp", nlist.item(0));
            wAirTemp = this.xpath.evaluate("@wAirTemp", nlist.item(0));
            inAirHumid = this.xpath.evaluate("@inAirHumid", nlist.item(0));
            wAirHumid = this.xpath.evaluate("@wAirHumid", nlist.item(0));
            wRadiation = this.xpath.evaluate("@wRadiation", nlist.item(0));
            if (um.keyset_recCCM().contains(inAirTemp) && um.keyset_recCCM().contains(inAirHumid) && um.keyset_recCCM().contains(wAirTemp) && um.keyset_recCCM().contains(wAirHumid) && um.keyset_recCCM().contains(wRadiation)) {
                success = true;
            }
            if (success) {
                _expression2 = this.xpath.compile("./VENTI");
                nlist = (NodeList)_expression2.evaluate(nodelist.item(0), XPathConstants.NODESET);
                _expression2 = this.xpath.compile("./DATA");
                NodeList nlist2 = (NodeList)_expression2.evaluate(nlist.item(0), XPathConstants.NODESET);
                int room = Integer.parseInt(this.xpath.evaluate("@room", nlist2.item(0)));
                int region = Integer.parseInt(this.xpath.evaluate("@region", nlist2.item(0)));
                int order = Integer.parseInt(this.xpath.evaluate("@order", nlist2.item(0)));
                int priority = Integer.parseInt(this.xpath.evaluate("@priority", nlist2.item(0)));
                String type = this.xpath.evaluate("@type", nlist2.item(0));
                String nameVenti = this.xpath.evaluate("@name", nlist2.item(0));
                CCMDATARecE10 ccmVenti = new CCMDATARecE10(room, region, order, priority, type);
                um.put_recCCM(nameVenti, ccmVenti);
                _expression2 = this.xpath.compile("./EVAPO");
                nlist = (NodeList)_expression2.evaluate(nodelist.item(0), XPathConstants.NODESET);
                _expression2 = this.xpath.compile("./DATA");
                nlist2 = (NodeList)_expression2.evaluate(nlist.item(0), XPathConstants.NODESET);
                room = Integer.parseInt(this.xpath.evaluate("@room", nlist2.item(0)));
                region = Integer.parseInt(this.xpath.evaluate("@region", nlist2.item(0)));
                order = Integer.parseInt(this.xpath.evaluate("@order", nlist2.item(0)));
                priority = Integer.parseInt(this.xpath.evaluate("@priority", nlist2.item(0)));
                type = this.xpath.evaluate("@type", nlist2.item(0));
                String nameEvapo = this.xpath.evaluate("@name", nlist2.item(0));
                CCMDATARecE10 ccmEvapo = new CCMDATARecE10(room, region, order, priority, type);
                um.put_recCCM(nameEvapo, ccmEvapo);
                ventiList.add(new Ventilation(inAirTemp, inAirHumid, wAirTemp, wAirHumid, wRadiation, nameVenti, nameEvapo, lightThrRate, lightRefRate, thermoThrRate, ratioFilmToFloor));
            }
            success = true;
        }
        catch (Exception e) {
            success = false;
        }
        return success;
    }

    private boolean parseAlert(NodeList nodelist, UserMap um, List<Alert> alertList, String node) {
        try {
            XPathExpression _expression2 = this.xpath.compile("./LEVEL");
            NodeList nlist = (NodeList)_expression2.evaluate(nodelist.item(0), XPathConstants.NODESET);
            int i = 0;
            while (i < nlist.getLength()) {
                String name = this.xpath.evaluate("@name", nlist.item(i));
                if (um.keyset_recCCM().contains(name)) {
                    String thread = this.xpath.evaluate("@thread", nlist.item(i));
                    double value = Double.parseDouble(this.xpath.evaluate("@value", nlist.item(i)));
                    int minute = Integer.parseInt(this.xpath.evaluate("@min", nlist.item(i)));
                    if (thread != null && thread.equals("over")) {
                        alertList.add(new Alert(name, value, minute, Alert.ThreadValue.OVER));
                        this.appendUECSLoga("\u4e0a\u9650\u8b66\u5831(" + name + "\u304c" + value + "\u4ee5\u4e0a\u3068\u306a\u3063\u305f\u72b6\u614b\u304c" + minute + "\u5206\u3067\u8b66\u5831\u30e1\u30fc\u30eb\u9001\u4fe1)\u3092\u8a2d\u5b9a\u3057\u307e\u3057\u305f\u3002");
                    } else if (thread != null && thread.equals("under")) {
                        alertList.add(new Alert(name, value, minute, Alert.ThreadValue.UNDER));
                        this.appendUECSLoga("\u4e0b\u9650\u8b66\u5831(" + name + "\u304c" + value + "\u4ee5\u4e0b\u3068\u306a\u3063\u305f\u72b6\u614b\u304c" + minute + "\u5206\u3067\u8b66\u5831\u30e1\u30fc\u30eb\u9001\u4fe1)\u3092\u8a2d\u5b9a\u3057\u307e\u3057\u305f\u3002");
                    } else {
                        this.appendUECSLoga("\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u306e" + node + "\u306e" + name + "\u89e3\u6790\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002");
                    }
                } else {
                    this.appendUECSLoga("\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u306e" + node + "\u306e" + name + "\u89e3\u6790\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002");
                }
                ++i;
            }
        }
        catch (XPathExpressionException e) {
            this.appendUECSLoga("\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u306e" + node + "\u89e3\u6790\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002");
        }
        return true;
    }

    private boolean parseDailyReport(NodeList nodelist, UserMap um, Map<String, DailyReport> dailyReportMap, String node) {
        try {
            XPathExpression _expression2 = this.xpath.compile("./REPORT");
            NodeList nlist = (NodeList)_expression2.evaluate(nodelist.item(0), XPathConstants.NODESET);
            int i = 0;
            while (i < nlist.getLength()) {
                String name = this.xpath.evaluate("@name", nlist.item(i));
                if (um.keyset_recCCM().contains(name)) {
                    dailyReportMap.put(name, new DailyReport());
                } else {
                    this.appendUECSLoga("\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u306e" + node + "\u306e" + name + "\u89e3\u6790\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002");
                }
                ++i;
            }
        }
        catch (XPathExpressionException e) {
            this.appendUECSLoga("\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u306e\u89e3\u6790\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002");
        }
        catch (Exception e) {
            this.appendUECSLoga("\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u306e\u89e3\u6790\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002");
        }
        return true;
    }

    private boolean parseEnthalpy(NodeList nodelist, UserMap um, Map<CCMDATARecE10, TempHumid> thMap, String node) {
        try {
            int i = 0;
            while (i < nodelist.getLength()) {
                String temperature = this.xpath.evaluate("@temp", nodelist.item(i));
                String rh = this.xpath.evaluate("@rh", nodelist.item(i));
                if (um.keyset_recCCM().contains(temperature) && um.keyset_recCCM().contains(rh)) {
                    XPathExpression _expression2 = this.xpath.compile("./DATA");
                    NodeList nlist = (NodeList)_expression2.evaluate(nodelist.item(i), XPathConstants.NODESET);
                    int room = Integer.parseInt(this.xpath.evaluate("@room", nlist.item(0)));
                    int region = Integer.parseInt(this.xpath.evaluate("@region", nlist.item(0)));
                    int order = Integer.parseInt(this.xpath.evaluate("@order", nlist.item(0)));
                    int priority = Integer.parseInt(this.xpath.evaluate("@priority", nlist.item(0)));
                    String type = this.xpath.evaluate("@type", nlist.item(0));
                    String name = this.xpath.evaluate("@name", nlist.item(0));
                    um.put_recCCM(name, new CCMDATARecE10(room, region, order, priority, type));
                    thMap.put(um.get_recCCM(name), new TempHumid(temperature, rh));
                } else {
                    this.appendUECSLoga("\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u306e" + node + "\u306e\u89e3\u6790\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\uff0e\u672a\u767b\u9332\u306eCCM\u3092\u4f7f\u7528\u3057\u3066\u3044\u307e\u3059\u3002");
                }
                ++i;
            }
        }
        catch (XPathExpressionException e) {
            this.appendUECSLoga("\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u306e\u306e\u89e3\u6790\u4e2d\u306bXPathExpressionException\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\uff0e");
        }
        catch (Exception e) {
            this.appendUECSLoga("\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u306e\u306e\u89e3\u6790\u4e2d\u306bException\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\uff0e");
        }
        return false;
    }

    private boolean parseGraphMin(NodeList nodelist, UserMap um, Map<Integer, GraphMin> _gmm) throws XPathExpressionException {
        boolean success = true;
        String title = "#ERROR";
        String rangeRight = "";
        int width = 400;
        int height = 300;
        try {
            int i = 0;
            while (i < nodelist.getLength()) {
                title = this.xpath.evaluate("@title", (Element)nodelist.item(i));
                String rangeLeft = this.xpath.evaluate("@rangeleft", (Element)nodelist.item(i));
                rangeRight = this.xpath.evaluate("@rangeRight", (Element)nodelist.item(i));
                try {
                    width = Integer.parseInt(this.xpath.evaluate("@width", (Element)nodelist.item(i)));
                    if (width <= 0) {
                        width = 400;
                    }
                }
                catch (NumberFormatException e) {
                    width = 400;
                }
                try {
                    height = Integer.parseInt(this.xpath.evaluate("@height", (Element)nodelist.item(i)));
                    if (height <= 0) {
                        height = 300;
                    }
                }
                catch (NumberFormatException e) {
                    height = 300;
                }
                XPathExpression _expression = this.xpath.compile("./DATA");
                NodeList nlist = (NodeList)_expression.evaluate(nodelist.item(i), XPathConstants.NODESET);
                String[] key = new String[nlist.getLength()];
                int[] axis = new int[nlist.getLength()];
                int j = 0;
                while (j < nlist.getLength()) {
                    key[j] = this.xpath.evaluate("./text()", (Element)nlist.item(j));
                    axis[j] = "right".equals(this.xpath.evaluate("@axis", (Element)nlist.item(j))) ? 1 : 0;
                    ++j;
                }
                boolean keysuccess = true;
                int j2 = 0;
                while (j2 < key.length) {
                    if (um.get_recCCM(key[j2]) == null) {
                        keysuccess = false;
                    }
                    ++j2;
                }
                if (keysuccess) {
                    _gmm.put(i, new GraphMin(key, axis, title, "./DATA/Graph" + Integer.toString(i) + ".jpg", rangeLeft, rangeRight, width, height));
                    _expression = this.xpath.compile("./RANGE");
                    nlist = (NodeList)_expression.evaluate(nodelist.item(i), XPathConstants.NODESET);
                    j2 = 0;
                    while (j2 < nlist.getLength()) {
                        String _axis = this.xpath.evaluate("@axis", (Element)nlist.item(j2));
                        if ("left".equals(_axis)) {
                            if (_gmm.get((Object)Integer.valueOf((int)i)).thisplot.getRangeAxis(0) != null) {
                                _gmm.get((Object)Integer.valueOf((int)i)).thisplot.getRangeAxis(0).setAutoRange(false);
                                _gmm.get((Object)Integer.valueOf((int)i)).thisplot.getRangeAxis(0).setRange(Double.parseDouble(this.xpath.evaluate("@min", (Element)nlist.item(j2))), Double.parseDouble(this.xpath.evaluate("@max", (Element)nlist.item(j2))));
                            }
                        } else if ("right".equals(_axis) && _gmm.get((Object)Integer.valueOf((int)i)).thisplot.getRangeAxis(1) != null) {
                            _gmm.get((Object)Integer.valueOf((int)i)).thisplot.getRangeAxis(1).setAutoRange(false);
                            _gmm.get((Object)Integer.valueOf((int)i)).thisplot.getRangeAxis(1).setRange(Double.parseDouble(this.xpath.evaluate("@min", (Element)nlist.item(j2))), Double.parseDouble(this.xpath.evaluate("@max", (Element)nlist.item(j2))));
                        }
                        ++j2;
                    }
                } else {
                    this.appendUECSLoga("\u30b0\u30e9\u30d5\uff08\u5206\uff09 \"" + Integer.toString(i + 1) + "\" \u756a\u76ee\u767b\u9332\u6642\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f");
                }
                ++i;
            }
        }
        catch (Exception e) {
            success = false;
            _gmm.clear();
        }
        return success;
    }

    private boolean parseGraphDaily(NodeList nodelist, UserMap um, Map<Integer, GraphDaily> _gmm) throws XPathExpressionException {
        boolean success = true;
        String title = "#ERROR";
        int width = 400;
        int height = 300;
        try {
            int i = 0;
            while (i < nodelist.getLength()) {
                title = this.xpath.evaluate("@title", (Element)nodelist.item(i));
                String rangeLeft = this.xpath.evaluate("@range", (Element)nodelist.item(i));
                try {
                    width = Integer.parseInt(this.xpath.evaluate("@width", (Element)nodelist.item(i)));
                    if (width <= 0) {
                        width = 400;
                    }
                }
                catch (NumberFormatException e) {
                    width = 400;
                }
                try {
                    height = Integer.parseInt(this.xpath.evaluate("@height", (Element)nodelist.item(i)));
                    if (height <= 0) {
                        height = 300;
                    }
                }
                catch (NumberFormatException e) {
                    height = 300;
                }
                String key = this.xpath.evaluate("./text()", (Element)nodelist.item(i));
                boolean keysuccess = true;
                if (um.get_recCCM(key) == null) {
                    keysuccess = false;
                }
                if (keysuccess) {
                    _gmm.put(i, new GraphDaily(key, title, "./DATA/GraphDaily" + Integer.toString(i) + ".jpg", rangeLeft, width, height));
                } else {
                    this.appendUECSLoga("\u30b0\u30e9\u30d5\uff08\u65e5\uff09 \"" + Integer.toString(i + 1) + "\" \u756a\u76ee\u767b\u9332\u6642\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f");
                }
                ++i;
            }
        }
        catch (Exception e) {
            success = false;
            _gmm.clear();
        }
        return success;
    }

    private boolean parseReceive(NodeList nodelist, UserMap um) {
        boolean success = true;
        int room = 0;
        int region = 0;
        int order = 0;
        int priority = 29;
        String type = "";
        String name = "";
        try {
            int i = 0;
            while (i < nodelist.getLength()) {
                name = this.xpath.evaluate("@name", (Element)nodelist.item(i));
                type = this.xpath.evaluate("@type", (Element)nodelist.item(i));
                room = Integer.parseInt(this.xpath.evaluate("@room", (Element)nodelist.item(i)));
                region = Integer.parseInt(this.xpath.evaluate("@region", (Element)nodelist.item(i)));
                order = Integer.parseInt(this.xpath.evaluate("@order", (Element)nodelist.item(i)));
                priority = Integer.parseInt(this.xpath.evaluate("@priority", (Element)nodelist.item(i)));
                CCMDATARecE10 tempCCM = new CCMDATARecE10(room, region, order, priority, type);
                tempCCM.ip = "none";
                um.put_recCCM(name, tempCCM);
                ++i;
            }
        }
        catch (XPathExpressionException e) {
            this.appendUECSLoga("\u53d7\u4fe1\u767b\u9332CCM\u306e\u89e3\u6790\u4e2d\u306b\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u306e\u8a18\u8f09\u65b9\u6cd5\u306e\u554f\u984c\u304c\u898b\u3064\u304b\u308a\u307e\u3057\u305f\uff0e");
            um.clear_recCCM();
            success = false;
        }
        catch (NumberFormatException e) {
            this.appendUECSLoga("\u53d7\u4fe1\u767b\u9332CCM\u306e\u89e3\u6790\u4e2d\u306b\u6570\u5b57\u304c\u8981\u6c42\u3055\u308c\u3066\u3044\u308b\u7b87\u6240\u306b\u4e0d\u9069\u5207\u306a\u8a18\u8f09\u304c\u898b\u3064\u304b\u308a\u307e\u3057\u305f\uff0e");
            um.clear_recCCM();
            success = false;
        }
        catch (Exception e) {
            this.appendUECSLoga("\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u306e\u53d7\u4fe1\u767b\u9332CCM\u306e\u89e3\u6790\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\uff0e");
            um.clear_recCCM();
            success = false;
        }
        return success;
    }
}

