/*
 * Decompiled with CFR 0.152.
 */
public class TempHumid {
    String temperature;
    String rh;

    TempHumid(String _temperature, String _rh) {
        this.temperature = _temperature;
        this.rh = _rh;
    }

    public static double getVaperSaturate(double temperature) {
        return 6.1078 * Math.exp(17.2693882 * temperature / (237.3 + temperature));
    }

    public static double getVaper(double temperature, double rh) {
        return TempHumid.getVaperSaturate(temperature) * rh / 100.0;
    }

    public static double getVaperDef(double temperature, double rh) {
        return TempHumid.getVaperSaturate(temperature) * (100.0 - rh) / 100.0;
    }

    public static double getAbstractHumid(double temperature, double rh) {
        double e = TempHumid.getVaper(temperature, rh);
        return 0.622 * e / (1013.25 - e);
    }

    public static double getEnthalpy(double temperature, double rh) {
        return 1.005 * temperature + (2501.0 + 1.846 * temperature) * TempHumid.getAbstractHumid(temperature, rh);
    }
}

