/*
 * Decompiled with CFR 0.152.
 */
public class Ventilation {
    String inAirTemp;
    String inAirHumid;
    String wAirTemp;
    String wAirHumid;
    String wRadiation;
    String venti;
    String evapo;
    double lightThrRate;
    double lightRefRate;
    double thermoThrRate;
    double ratioFilmToFloor;

    public Ventilation(String _inAirTemp, String _inAirHumid, String _wAirTemp, String _wAirHumid, String _wRadiation, String _venti, String _evapo, double _lightThrRate, double _lightRefRate, double _thermoThrRate, double _ratioFilmToFloor) {
        this.inAirTemp = _inAirTemp;
        this.inAirHumid = _inAirHumid;
        this.wAirTemp = _wAirTemp;
        this.wAirHumid = _wAirHumid;
        this.wRadiation = _wRadiation;
        this.venti = _venti;
        this.evapo = _evapo;
        this.lightThrRate = _lightThrRate;
        this.lightRefRate = _lightRefRate;
        this.thermoThrRate = _thermoThrRate;
        this.ratioFilmToFloor = _ratioFilmToFloor;
    }

    double getVentilationRate(double inTemp, double inRH, double wTemp, double wRH, double wRad) {
        double ventiration = 0.0;
        ventiration = (wRad * 0.2389 * 60.0 * (1.0 - this.lightRefRate) * this.lightThrRate - this.thermoThrRate * 0.2389 * 60.0 / 1000.0 * this.ratioFilmToFloor * (inTemp - wTemp)) / (1.2 * (TempHumid.getEnthalpy(inTemp, inRH) - TempHumid.getEnthalpy(wTemp, wRH)) * 0.2389);
        return ventiration;
    }

    double getEvaporationRate(double inTemp, double inRH, double wTemp, double wRH, double wRad) {
        double evapo = 1.2 * this.getVentilationRate(inTemp, inRH, wTemp, wRH, wRad) * (TempHumid.getAbstractHumid(inTemp, inRH) - TempHumid.getAbstractHumid(wTemp, wRH)) * 1000.0;
        return evapo;
    }
}

