/*
 * Decompiled with CFR 0.152.
 */
package mail;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import javax.mail.AuthenticationFailedException;
import javax.mail.Authenticator;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.NoSuchProviderException;
import javax.mail.Part;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeUtility;

public class MailSend {
    static Properties sendPrp = new Properties();
    static Properties recPrp = new Properties();

    public static void setMailReceiveMarameter(String _pop, String _port, String _user, String _password, boolean _ssl, boolean _starttls, boolean _apop, String _title, boolean _checkEnable) {
        ReceiveParameter.pop = _pop;
        ReceiveParameter.port = _port;
        ReceiveParameter.user = _user;
        ReceiveParameter.password = _password;
        ReceiveParameter.ssl = _ssl;
        ReceiveParameter.starttls = _starttls;
        ReceiveParameter.apop = _apop;
        ReceiveParameter.title = _title;
        ReceiveParameter.checkEnable = _checkEnable;
        recPrp.setProperty("mail.pop3.host", ReceiveParameter.pop);
        recPrp.setProperty("mail.pop3.port", ReceiveParameter.port);
        recPrp.setProperty("mail.pop3.connectiontimeout", "20000");
        recPrp.setProperty("mail.pop3.timeout", "20000");
        if (ReceiveParameter.ssl) {
            recPrp.setProperty("mail.pop3.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            recPrp.setProperty("mail.pop3.socketFactory.fallback", "false");
            recPrp.setProperty("mail.pop3.socketFactory.port", ReceiveParameter.port);
        } else {
            recPrp.setProperty("mail.pop3.socketFactory.class", "javax.net.SocketFactory");
            recPrp.setProperty("mail.pop3.socketFactory.fallback", "true");
        }
        if (ReceiveParameter.starttls) {
            recPrp.put("mail.pop3.starttls.enable", "true");
        } else {
            recPrp.put("mail.pop3.starttls.enable", "false");
        }
        if (ReceiveParameter.apop) {
            recPrp.put("mail.pop3.apop.enable", "true");
        } else {
            recPrp.put("mail.pop3.apop.enable", "false");
        }
    }

    public static void setMailSendParameter(String _smtp, String _port, boolean _ssl, boolean _auth, String _user, String _password, boolean _popSend, String _popPortSend, String _serverPOPSend, String _userPOPSend, String _passwordPOPSend, boolean _starttls) {
        SendParameter.smtp = _smtp;
        SendParameter.port = _port;
        SendParameter.ssl = _ssl;
        SendParameter.auth = _auth;
        SendParameter.user = _user;
        SendParameter.password = _password;
        SendParameter.popSend = _popSend;
        SendParameter.popPortSend = _popPortSend;
        SendParameter.serverPOPSend = _serverPOPSend;
        SendParameter.userPOPSend = _userPOPSend;
        SendParameter.passwordPOPSend = _passwordPOPSend;
        SendParameter.starttls = _starttls;
        sendPrp.put("mail.smtp.host", SendParameter.smtp);
        sendPrp.setProperty("mail.smtp.port", SendParameter.port);
        sendPrp.setProperty("mail.smtp.socketFactory.port", SendParameter.port);
        sendPrp.setProperty("mail.smtp.timeout", "10000");
        if (SendParameter.auth) {
            sendPrp.setProperty("mail.smtp.auth", "true");
        } else {
            sendPrp.setProperty("mail.smtp.auth", "false");
        }
        if (SendParameter.ssl) {
            sendPrp.setProperty("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            sendPrp.setProperty("mail.smtp.socketFactory.fallback", "false");
        } else {
            sendPrp.setProperty("mail.smtp.socketFactory.class", "javax.net.SocketFactory");
            sendPrp.setProperty("mail.smtp.socketFactory.fallback", "true");
        }
        if (SendParameter.starttls) {
            sendPrp.put("mail.smtp.starttls.enable", "true");
        } else {
            sendPrp.put("mail.smtp.starttls.enable", "false");
        }
    }

    static boolean receiveMail() {
        boolean receivesuccess = true;
        ReceiveParameter.session = Session.getDefaultInstance(recPrp, new Authenticator(){

            @Override
            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(ReceiveParameter.user, ReceiveParameter.password);
            }
        });
        ReceiveParameter.session.setDebug(true);
        Store store = null;
        try {
            try {
                store = ReceiveParameter.session.getStore("pop3");
            }
            catch (NoSuchProviderException e) {
                receivesuccess = false;
            }
            try {
                store.connect();
            }
            catch (AuthenticationFailedException e) {
                System.out.println("\u30e1\u30fc\u30eb\u53d7\u4fe1: \u30b5\u30fc\u30d0\u63a5\u7d9a\u6642\u306b\u8a8d\u8a3c\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002" + e.toString());
                receivesuccess = false;
            }
            catch (MessagingException e) {
                System.out.println("\u30e1\u30fc\u30eb\u53d7\u4fe1: \u30b5\u30fc\u30d0\u63a5\u7d9a\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002" + e.toString());
                receivesuccess = false;
            }
            Folder folder = null;
            try {
                try {
                    folder = store.getFolder("INBOX");
                }
                catch (MessagingException e) {
                    e.printStackTrace();
                }
                try {
                    folder.open(1);
                }
                catch (MessagingException e) {
                    e.printStackTrace();
                }
                try {
                    Message[] messages = folder.getMessages();
                    System.out.println("\u5408\u8a08" + messages.length + "\u4ef6\u306e\u53d7\u4fe1\u30e1\u30c3\u30bb\u30fc\u30b8\u304c\u898b\u3064\u304b\u308a\u307e\u3057\u305f\u3002");
                    System.out.println("\u4ef6\u540d\u304c" + ReceiveParameter.title + "\u306e\u3082\u306e\u306e\u307f\u691c\u7d22\u3092\u884c\u3044\u307e\u3059");
                    int index = 0;
                    while (index < messages.length) {
                        Message message = messages[index];
                        if (ReceiveParameter.title.equals(message.getSubject())) {
                            MailSend.saveAttachmentFile(message);
                        }
                        ++index;
                    }
                }
                catch (MessagingException e) {
                    e.printStackTrace();
                }
            }
            finally {
                if (folder != null) {
                    try {
                        folder.close(false);
                    }
                    catch (MessagingException e) {
                        System.out.println("\u30e1\u30fc\u30eb\u53d7\u4fe1: \u30d5\u30a9\u30eb\u30c0\u30af\u30ed\u30fc\u30ba\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002" + e.toString());
                    }
                }
            }
        }
        finally {
            if (store != null) {
                try {
                    store.close();
                }
                catch (MessagingException e) {
                    System.out.println("\u30e1\u30fc\u30eb\u53d7\u4fe1: \u30b5\u30fc\u30d0\u5207\u65ad\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002" + e.toString());
                }
            }
        }
        return receivesuccess;
    }

    static void saveAttachmentFile(Part mes) {
        boolean readsuccess = true;
        try {
            String temp = mes.getDisposition();
            if (temp == null || temp.equalsIgnoreCase("attachment")) {
                int c;
                String filename = mes.getFileName();
                if (filename != null) {
                    filename = MimeUtility.decodeText(filename);
                } else {
                    readsuccess = false;
                }
                File f = new File(String.valueOf(filename) + ".xml");
                if (f.exists()) {
                    throw new IOException("\u540c\u540d\u306e\u30d5\u30a1\u30a4\u30eb\u304c\u5b58\u5728\u3057\u307e\u3059");
                }
                BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(f));
                InputStream is = mes.getInputStream();
                while ((c = is.read()) != -1) {
                    ((OutputStream)os).write(c);
                }
                ((OutputStream)os).close();
                System.out.println(String.valueOf(filename) + "\u3092\u4fdd\u5b58\u3057\u307e\u3057\u305f\u3002");
            }
        }
        catch (MessagingException e) {
            readsuccess = false;
        }
        catch (UnsupportedEncodingException e) {
            readsuccess = false;
        }
        catch (IOException e) {
            readsuccess = false;
        }
    }

    static int sendMail(String[] address, String subject, String text, String fromAddress, String fromName) {
        int sendsuccess = 0;
        SendParameter.session = Session.getDefaultInstance(sendPrp, new Authenticator(){

            @Override
            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(SendParameter.user, SendParameter.password);
            }
        });
        if (SendParameter.popSend) {
            sendPrp.setProperty("mail.pop3.socketFactory.port", SendParameter.popPortSend);
        }
        SendParameter.session.setDebug(true);
        if (SendParameter.popSend) {
            Store store = null;
            try {
                store = SendParameter.session.getStore("pop3");
                store.connect(SendParameter.serverPOPSend, SendParameter.userPOPSend, SendParameter.passwordPOPSend);
            }
            catch (NoSuchProviderException e1) {
                sendsuccess = 1;
            }
            catch (MessagingException e) {
                sendsuccess = 2;
            }
        }
        if (sendsuccess == 0) {
            MimeMessage objMsg = new MimeMessage(SendParameter.session);
            try {
                int i = 0;
                while (i < address.length) {
                    objMsg.addRecipients(Message.RecipientType.TO, address[i]);
                    ++i;
                }
                InternetAddress objFrm = new InternetAddress(fromAddress, fromName);
                objMsg.setFrom(objFrm);
                objMsg.setSubject(subject, "ISO-2022-JP");
                objMsg.setText(text, "ISO-2022-JP");
                Transport.send(objMsg);
            }
            catch (UnsupportedEncodingException e) {
                sendsuccess = 3;
            }
            catch (MessagingException e) {
                sendsuccess = 2;
            }
        }
        return sendsuccess;
    }

    public static class ReceiveParameter {
        static Session session = null;
        static String pop = "";
        static String port = "";
        static String user = "";
        static String password = "";
        static boolean ssl = false;
        static boolean starttls = false;
        static boolean apop = false;
        static String title = "";
        static boolean checkEnable = false;
    }

    public static class SendParameter {
        static Session session = null;
        static String password = "";
        static String user = "";
        static String serverPOPSend = "";
        static String passwordPOPSend = "";
        static String userPOPSend = "";
        static String popPortSend = "";
        static boolean ssl = false;
        static boolean popSend = false;
        static boolean auth = false;
        static String smtp = "";
        static String port = "";
        static boolean starttls = false;
    }
}

