/*
 * Decompiled with CFR 0.152.
 */
package postgre;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import postgre.DBStatus;
import postgre.JTextAreaLog;
import postgre.ReadPostgreFile;

public class JPanelPostgre
extends JPanel {
    public int postgreserror = 0;
    SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    public DefaultListModel listGraph;
    public DBStatus dbs;
    private static final long serialVersionUID = 1L;
    private JLabel jLabelPostgre = null;
    private JLabel jLabelServerName = null;
    private JTextField jTextFieldServer = null;
    private JLabel jLabelPort = null;
    private JLabel jLabelPassword = null;
    private JLabel jLabelPass = null;
    private JLabel jLabelUser = null;
    private JLabel jLabelTable = null;
    private JPasswordField jPasswordField = null;
    private JTextField jTextFieldPort = null;
    private JTextField jTextFieldDBName = null;
    private JTextField jTextFieldUser = null;
    private JTextField jTextFieldTable = null;
    private JTextField jTextFieldGreenHouse = null;
    private Date date = new Date();
    private JButton jButtonTestConnect = null;
    public JRadioButton jRadioButtonUpDate;
    private JScrollPane jScrollPaneText = null;
    private JTextAreaLog jTextAreaLog;
    private JLabel jLabelGreenHouse;

    public void doUpdateDB(String[] sql) {
        DBThread thread = new DBThread(sql);
        thread.start();
        thread = null;
    }

    public JPanelPostgre() {
        ReadPostgreFile rpf = new ReadPostgreFile("./PostgreUECS.xml");
        this.dbs = rpf.parseInitFile();
        this.initialize();
    }

    private void initialize() {
        this.setSize(300, 200);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 3;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        this.jLabelPostgre = new JLabel();
        this.jLabelPostgre.setText("\u5916\u90e8\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\uff08PostgreSQL\uff09\u63a5\u7d9a\u8a2d\u5b9a\u3000 ");
        this.add((Component)this.jLabelPostgre, gbc);
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.anchor = 13;
        this.jLabelServerName = new JLabel();
        this.jLabelServerName.setText("\u30b5\u30fc\u30d0\u30fc\u30a2\u30c9\u30ec\u30b9\u3000");
        this.add((Component)this.jLabelServerName, gbc);
        gbc.gridy = 2;
        this.jLabelPort = new JLabel();
        this.jLabelPort.setText("\u30b5\u30fc\u30d0\u30fc\u30dd\u30fc\u30c8\u3000");
        this.add((Component)this.jLabelPort, gbc);
        gbc.gridy = 3;
        this.jLabelPass = new JLabel();
        this.jLabelPass.setText("\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u540d\u3000");
        this.add((Component)this.jLabelPass, gbc);
        gbc.gridy = 4;
        this.jLabelTable = new JLabel();
        this.jLabelTable.setText("\u30c6\u30fc\u30d6\u30eb\u540d\u3000");
        this.add((Component)this.jLabelTable, gbc);
        gbc.gridy = 5;
        this.jLabelUser = new JLabel();
        this.jLabelUser.setText("\u30e6\u30fc\u30b6\u30fc\u540d\u3000");
        this.add((Component)this.jLabelUser, gbc);
        gbc.gridy = 6;
        this.jLabelPassword = new JLabel();
        this.jLabelPassword.setText("\u30d1\u30b9\u30ef\u30fc\u30c9\u3000");
        this.add((Component)this.jLabelPassword, gbc);
        gbc.gridy = 7;
        this.jLabelGreenHouse = new JLabel();
        this.jLabelGreenHouse.setText("\u6e29\u5ba4\u540d\uff1a\u3000");
        this.add((Component)this.jLabelGreenHouse, gbc);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.anchor = 17;
        this.add((Component)this.getJTextFieldServer(), gbc);
        gbc.gridy = 2;
        this.add((Component)this.getJTextFieldPort(), gbc);
        gbc.gridy = 3;
        this.add((Component)this.getJTextFieldDBName(), gbc);
        gbc.gridy = 4;
        this.add((Component)this.getJTextFieldTable(), gbc);
        gbc.gridy = 5;
        this.add((Component)this.getJTextFieldUser(), gbc);
        gbc.gridy = 6;
        this.add((Component)this.getJPasswordField(), gbc);
        gbc.gridy = 7;
        this.add((Component)this.getJTextFieldGreenHouse(), gbc);
        if (this.dbs != null) {
            this.getJTextFieldServer().setText(this.dbs.ip);
            this.getJTextFieldPort().setText(this.dbs.port);
            this.getJTextFieldDBName().setText(this.dbs.name);
            this.getJTextFieldUser().setText(this.dbs.username);
            this.getJPasswordField().setText(this.dbs.password);
            this.getJTextFieldTable().setText(this.dbs.table);
            this.getJTextFieldGreenHouse().setText(this.dbs.greenhouse);
        }
        gbc.gridx = 0;
        gbc.gridy = 8;
        gbc.gridwidth = 2;
        gbc.anchor = 10;
        this.add((Component)this.getJRadioButtonUpDate(), gbc);
        gbc.gridy = 9;
        this.add((Component)this.getJButtonTestConnect(), gbc);
        gbc.gridy = 10;
        gbc.fill = 1;
        this.add((Component)this.getJScrollPaneText(), gbc);
    }

    private JScrollPane getJScrollPaneText() {
        if (this.jScrollPaneText == null) {
            this.jScrollPaneText = new JScrollPane();
            this.jScrollPaneText.setMinimumSize(new Dimension(500, 100));
            this.jScrollPaneText.setPreferredSize(this.jScrollPaneText.getMinimumSize());
            this.jScrollPaneText.setViewportView(this.getJTextAreaLog());
        }
        return this.jScrollPaneText;
    }

    private JTextAreaLog getJTextAreaLog() {
        if (this.jTextAreaLog == null) {
            this.jTextAreaLog = new JTextAreaLog();
        }
        return this.jTextAreaLog;
    }

    private JTextField getJTextFieldGreenHouse() {
        if (this.jTextFieldGreenHouse == null) {
            this.jTextFieldGreenHouse = new JTextField();
            this.jTextFieldGreenHouse.setMinimumSize(new Dimension(300, 20));
            this.jTextFieldGreenHouse.setPreferredSize(this.jTextFieldGreenHouse.getMinimumSize());
        }
        return this.jTextFieldGreenHouse;
    }

    private JButton getJButtonTestConnect() {
        if (this.jButtonTestConnect == null) {
            this.jButtonTestConnect = new JButton();
            this.jButtonTestConnect.setText("\u63a5\u7d9a\u30c6\u30b9\u30c8");
            this.jButtonTestConnect.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DBConnectTest dct = new DBConnectTest();
                    dct.start();
                    dct = null;
                }
            });
        }
        return this.jButtonTestConnect;
    }

    private JTextField getJTextFieldUser() {
        if (this.jTextFieldUser == null) {
            this.jTextFieldUser = new JTextField();
            this.jTextFieldUser.setMinimumSize(new Dimension(300, 20));
            this.jTextFieldUser.setPreferredSize(this.jTextFieldUser.getMinimumSize());
        }
        return this.jTextFieldUser;
    }

    private JTextField getJTextFieldTable() {
        if (this.jTextFieldTable == null) {
            this.jTextFieldTable = new JTextField();
            this.jTextFieldTable.setMinimumSize(new Dimension(300, 20));
            this.jTextFieldTable.setPreferredSize(this.jTextFieldTable.getMinimumSize());
        }
        return this.jTextFieldTable;
    }

    private JTextField getJTextFieldServer() {
        if (this.jTextFieldServer == null) {
            this.jTextFieldServer = new JTextField();
            this.jTextFieldServer.setMinimumSize(new Dimension(300, 20));
            this.jTextFieldServer.setPreferredSize(this.jTextFieldServer.getMinimumSize());
        }
        return this.jTextFieldServer;
    }

    private JPasswordField getJPasswordField() {
        if (this.jPasswordField == null) {
            this.jPasswordField = new JPasswordField();
            this.jPasswordField.setMinimumSize(new Dimension(300, 20));
            this.jPasswordField.setPreferredSize(this.jPasswordField.getMinimumSize());
        }
        return this.jPasswordField;
    }

    private JTextField getJTextFieldPort() {
        if (this.jTextFieldPort == null) {
            this.jTextFieldPort = new JTextField();
            this.jTextFieldPort.setMinimumSize(new Dimension(300, 20));
            this.jTextFieldPort.setPreferredSize(this.jTextFieldPort.getMinimumSize());
        }
        return this.jTextFieldPort;
    }

    private JTextField getJTextFieldDBName() {
        if (this.jTextFieldDBName == null) {
            this.jTextFieldDBName = new JTextField();
            this.jTextFieldDBName.setMinimumSize(new Dimension(300, 20));
            this.jTextFieldDBName.setPreferredSize(this.jTextFieldDBName.getMinimumSize());
        }
        return this.jTextFieldDBName;
    }

    public void addListGraph(String filename) {
    }

    private JRadioButton getJRadioButtonUpDate() {
        if (this.jRadioButtonUpDate == null) {
            this.jRadioButtonUpDate = new JRadioButton();
            this.jRadioButtonUpDate.setText("10\u5206\u304a\u304d\u306b\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u306b\u30a2\u30c3\u30d7\u30ed\u30fc\u30c9\u3092\u884c\u3046\uff0e");
            this.jRadioButtonUpDate.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (JPanelPostgre.this.jRadioButtonUpDate.isSelected()) {
                        JPanelPostgre.this.jTextFieldUser.setEnabled(false);
                        JPanelPostgre.this.jTextFieldTable.setEnabled(false);
                        JPanelPostgre.this.jTextFieldServer.setEnabled(false);
                        JPanelPostgre.this.jTextFieldDBName.setEnabled(false);
                        JPanelPostgre.this.jTextFieldPort.setEnabled(false);
                        JPanelPostgre.this.jPasswordField.setEnabled(false);
                        JPanelPostgre.this.jTextFieldGreenHouse.setEnabled(false);
                    } else {
                        JPanelPostgre.this.jTextFieldUser.setEnabled(true);
                        JPanelPostgre.this.jTextFieldTable.setEnabled(true);
                        JPanelPostgre.this.jTextFieldServer.setEnabled(true);
                        JPanelPostgre.this.jTextFieldDBName.setEnabled(true);
                        JPanelPostgre.this.jTextFieldPort.setEnabled(true);
                        JPanelPostgre.this.jPasswordField.setEnabled(true);
                        JPanelPostgre.this.jTextFieldGreenHouse.setEnabled(true);
                    }
                }
            });
        }
        return this.jRadioButtonUpDate;
    }

    public class DBConnectTest
    extends Thread {
        Connection con;
        String database;

        DBConnectTest() {
            JPanelPostgre.this.date.setTime(System.currentTimeMillis());
            try {
                Class.forName("org.postgresql.Driver");
                JPanelPostgre.this.dbs.ip = JPanelPostgre.this.getJTextFieldServer().getText();
                JPanelPostgre.this.dbs.port = JPanelPostgre.this.getJTextFieldPort().getText();
                JPanelPostgre.this.dbs.username = JPanelPostgre.this.getJTextFieldUser().getText();
                JPanelPostgre.this.dbs.password = JPanelPostgre.this.getJPasswordField().getText();
                JPanelPostgre.this.dbs.name = JPanelPostgre.this.getJTextFieldDBName().getText();
                this.database = "jdbc:postgresql://" + JPanelPostgre.this.dbs.ip + ":" + JPanelPostgre.this.dbs.port + "/" + JPanelPostgre.this.dbs.name;
                JPanelPostgre.this.dbs.table = JPanelPostgre.this.getJTextFieldTable().getText();
                JPanelPostgre.this.jTextAreaLog.append(String.valueOf(JPanelPostgre.this.sdf.format(JPanelPostgre.this.date)) + "  \u30c9\u30e9\u30a4\u30d0\u8aad\u307f\u8fbc\u307f\u6210\u529f." + System.getProperty("line.separator"));
            }
            catch (ClassNotFoundException e) {
                JPanelPostgre.this.jTextAreaLog.append(String.valueOf(JPanelPostgre.this.sdf.format(JPanelPostgre.this.date)) + "  \u63a5\u7d9a\u5931\u6557\u3002ClassNotFoundException\u304c\u767a\u751f\u3057\u307e\u3057\u305f." + e.getMessage() + System.getProperty("line.separator"));
            }
        }

        @Override
        public void run() {
            JPanelPostgre.this.date.setTime(System.currentTimeMillis());
            try {
                this.con = DriverManager.getConnection(this.database, JPanelPostgre.this.dbs.username, JPanelPostgre.this.dbs.password);
                Statement st = this.con.createStatement();
                ResultSet set = st.executeQuery("Select * from " + JPanelPostgre.this.dbs.table);
                JPanelPostgre.this.jTextAreaLog.append(String.valueOf(JPanelPostgre.this.sdf.format(JPanelPostgre.this.date)) + "  DB\u63a5\u7d9a\u6210\u529f." + System.getProperty("line.separator"));
                if (this.con != null && !this.con.isClosed()) {
                    this.con.close();
                }
            }
            catch (SQLException e) {
                JPanelPostgre.this.jTextAreaLog.append(String.valueOf(JPanelPostgre.this.sdf.format(JPanelPostgre.this.date)) + "  DB\u63a5\u7d9a\u5931\u6557.SQLException\u304c\u767a\u751f\u3057\u307e\u3057\u305f." + e.getMessage() + System.getProperty("line.separator"));
            }
        }
    }

    public class DBThread
    extends Thread {
        Connection con;
        String database;
        String[] sql;

        DBThread(String[] _sql) {
            JPanelPostgre.this.date.setTime(System.currentTimeMillis());
            try {
                Class.forName("org.postgresql.Driver");
                JPanelPostgre.this.dbs.ip = JPanelPostgre.this.getJTextFieldServer().getText();
                JPanelPostgre.this.dbs.port = JPanelPostgre.this.getJTextFieldPort().getText();
                JPanelPostgre.this.dbs.username = JPanelPostgre.this.getJTextFieldUser().getText();
                JPanelPostgre.this.dbs.password = JPanelPostgre.this.getJPasswordField().getText();
                JPanelPostgre.this.dbs.name = JPanelPostgre.this.getJTextFieldDBName().getText();
                this.database = "jdbc:postgresql://" + JPanelPostgre.this.dbs.ip + ":" + JPanelPostgre.this.dbs.port + "/" + JPanelPostgre.this.dbs.name;
                JPanelPostgre.this.dbs.table = JPanelPostgre.this.getJTextFieldTable().getText();
                this.sql = _sql;
            }
            catch (ClassNotFoundException e) {
                JPanelPostgre.this.jTextAreaLog.append(String.valueOf(JPanelPostgre.this.sdf.format(JPanelPostgre.this.date)) + "  \u63a5\u7d9a\u5931\u6557.ClassNotFoundException\u304c\u767a\u751f\u3057\u307e\u3057\u305f." + e.getMessage() + System.getProperty("line.separator"));
            }
        }

        @Override
        public void run() {
            long time = System.currentTimeMillis();
            JPanelPostgre.this.date.setTime(time);
            try {
                this.con = DriverManager.getConnection(this.database, JPanelPostgre.this.dbs.username, JPanelPostgre.this.dbs.password);
                Statement st = this.con.createStatement();
                int miss = 0;
                int i = 0;
                while (i < this.sql.length) {
                    try {
                        st.execute(this.sql[i]);
                    }
                    catch (SQLException e) {
                        ++miss;
                        JPanelPostgre.this.jTextAreaLog.append(String.valueOf(JPanelPostgre.this.sdf.format(JPanelPostgre.this.date)) + "  \u4fdd\u5b58\u5931\u6557.(" + this.sql[i] + ")" + System.getProperty("line.separator"));
                    }
                    ++i;
                }
                JPanelPostgre.this.jTextAreaLog.append(String.valueOf(JPanelPostgre.this.sdf.format(JPanelPostgre.this.date)) + "  " + Integer.toString(this.sql.length - miss) + "\u500b\u4fdd\u5b58." + Integer.toString(miss) + "\u500b\u5931\u6557.\u6642\u9593" + Long.toString(System.currentTimeMillis() - time) + "\u30df\u30ea\u79d2" + System.getProperty("line.separator"));
                st.close();
                if (this.con != null && !this.con.isClosed()) {
                    this.con.close();
                }
            }
            catch (SQLException e) {
                JPanelPostgre.this.jTextAreaLog.append(String.valueOf(JPanelPostgre.this.sdf.format(JPanelPostgre.this.date)) + "  SQLException\u304c\u767a\u751f\u3057\u307e\u3057\u305f." + e.getMessage() + System.getProperty("line.separator"));
            }
        }
    }
}

